/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisUtil {
    protected static ReentrantLock lockPool = new ReentrantLock();
    protected static ReentrantLock lockJedis = new ReentrantLock();
    private static Logger _log = LoggerFactory.getLogger(RedisUtil.class);
    private static String IP = "api.t.weitao.kr";
    private static int PORT = 6379;
    private static String PASSWORD = "PQ9YUYckcPWZcgxPDAqyCRWYyRvwGo";
    private static int DB = 8;
    private static int MAX_ACTIVE = 50000;
    private static int MAX_IDLE = 50;
    private static int MAX_WAIT = 10000;
    private static int TIMEOUT = 10000;
    private static boolean TEST_ON_BORROW = false;
    private static JedisPool jedisPool = null;
    public static final int EXRP_HOUR = 3600;
    public static final int EXRP_DAY = 86400;
    public static final int EXRP_MONTH = 2592000;

    private static void initialPool() {
        try {
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(MAX_ACTIVE);
            config.setMaxIdle(MAX_IDLE);
            config.setMaxWaitMillis((long)MAX_WAIT);
            config.setTestOnBorrow(TEST_ON_BORROW);
            jedisPool = new JedisPool((GenericObjectPoolConfig)config, IP, PORT, TIMEOUT, PASSWORD, DB);
        }
        catch (Exception e) {
            _log.error("First create JedisPool error : " + e);
        }
    }

    private static synchronized void poolInit() {
        if (null == jedisPool) {
            RedisUtil.initialPool();
        }
    }

    public static synchronized Jedis getJedis() {
        RedisUtil.poolInit();
        Jedis jedis = null;
        try {
            if (null != jedisPool) {
                jedis = jedisPool.getResource();
                try {
                    jedis.auth(PASSWORD);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            _log.error("Get jedis error : " + e);
        }
        return jedis;
    }

    public static synchronized void set(String key, String value) {
        try {
            value = StringUtils.isBlank((String)value) ? "" : value;
            Jedis jedis = RedisUtil.getJedis();
            if (jedis != null) {
                jedis.set(key, value);
                jedis.close();
            }
        }
        catch (Exception e) {
            _log.error("Set key error : " + e);
        }
    }

    public static synchronized void set(byte[] key, byte[] value) {
        try {
            Jedis jedis = RedisUtil.getJedis();
            if (jedis != null) {
                jedis.set(key, value);
                jedis.close();
            }
        }
        catch (Exception e) {
            _log.error("Set key error : " + e);
        }
    }

    public static synchronized void set(String key, String value, int seconds) {
        try {
            value = StringUtils.isBlank((String)value) ? "" : value;
            Jedis jedis = RedisUtil.getJedis();
            if (jedis != null) {
                jedis.setex(key, seconds, value);
                jedis.close();
            }
        }
        catch (Exception e) {
            _log.error("Set keyex error : " + e);
        }
    }

    public static synchronized void set(byte[] key, byte[] value, int seconds) {
        try {
            Jedis jedis = RedisUtil.getJedis();
            if (jedis == null) {
                return;
            }
            jedis.set(key, value);
            jedis.expire(key, seconds);
            jedis.close();
        }
        catch (Exception e) {
            _log.error("Set key error : " + e);
        }
    }

    public static synchronized String get(String key) {
        Jedis jedis = RedisUtil.getJedis();
        if (null == jedis) {
            return null;
        }
        String value = jedis.get(key);
        jedis.close();
        return value;
    }

    public static synchronized Boolean exists(String key) {
        Jedis jedis = RedisUtil.getJedis();
        if (null == jedis) {
            return null;
        }
        Boolean flag = jedis.exists(key);
        jedis.close();
        return flag;
    }

    public static synchronized Set<String> getcontains(String key) {
        Jedis jedis = RedisUtil.getJedis();
        if (null == jedis) {
            return null;
        }
        Set strings = jedis.keys("*" + key + "*");
        jedis.close();
        return strings;
    }

    public static synchronized byte[] get(byte[] key) {
        Jedis jedis = RedisUtil.getJedis();
        if (null == jedis) {
            return null;
        }
        byte[] value = jedis.get(key);
        jedis.close();
        return value;
    }

    public static synchronized void remove(String key) {
        try {
            Jedis jedis = RedisUtil.getJedis();
            if (jedis == null) {
                return;
            }
            jedis.del(key);
            jedis.close();
        }
        catch (Exception e) {
            _log.error("Remove keyex error : " + e);
        }
    }

    public static synchronized void removeall(String key) {
        try {
            Jedis jedis = RedisUtil.getJedis();
            if (jedis == null) {
                return;
            }
            Set<String> stringSet = RedisUtil.getcontains(key);
            for (String s : stringSet) {
                RedisUtil.remove(s);
            }
            jedis.del(key);
            jedis.close();
        }
        catch (Exception e) {
            _log.error("Remove keyex error : " + e);
        }
    }

    public static synchronized void remove(byte[] key) {
        try {
            Jedis jedis = RedisUtil.getJedis();
            if (jedis == null) {
                return;
            }
            jedis.del(key);
            jedis.close();
        }
        catch (Exception e) {
            _log.error("Remove keyex error : " + e);
        }
    }

    public static synchronized void lpush(String key, String ... strings) {
        try {
            Jedis jedis = RedisUtil.getJedis();
            if (jedis == null) {
                return;
            }
            jedis.lpush(key, strings);
            jedis.close();
        }
        catch (Exception e) {
            _log.error("lpush error : " + e);
        }
    }

    public static synchronized void lrem(String key, long count, String value) {
        try {
            Jedis jedis = RedisUtil.getJedis();
            if (jedis == null) {
                return;
            }
            jedis.lrem(key, count, value);
            jedis.close();
        }
        catch (Exception e) {
            _log.error("lpush error : " + e);
        }
    }

    public static synchronized void sadd(String key, String value, int seconds) {
        try {
            Jedis jedis = RedisUtil.getJedis();
            if (jedis == null) {
                return;
            }
            jedis.sadd(key, new String[]{value});
            jedis.expire(key, seconds);
            jedis.close();
        }
        catch (Exception e) {
            _log.error("sadd error : " + e);
        }
    }

    public static void main(String[] args) {
        Jedis jedis = RedisUtil.getJedis();
        if (jedis == null) {
            return;
        }
        Set keys = jedis.keys("tm_*");
        System.out.println(keys.size());
        if (keys != null && !keys.isEmpty()) {
            String[] keyArr = new String[keys.size()];
            jedis.del(keys.toArray(keyArr));
        }
    }
}

