/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class OutExcelUtil {
    private static final String XLS = "xls";
    private static final String XLSX = "xlsx";
    private static final String PATH = "d:/";
    private static final String SHEET_NAME = "\u8868\u683c1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outExcel(JSONArray dataArray, LinkedHashMap<String, Object> headerMap, String fileName) {
        FileOutputStream fileOutputStream = null;
        Workbook workbook = null;
        try {
            List<String> tempList;
            String suffixName = fileName.split("\\.")[1];
            workbook = OutExcelUtil.createWriteWorkBook(suffixName);
            Sheet sheet = workbook.createSheet(SHEET_NAME);
            Row hssfRow = sheet.createRow(0);
            Iterator<Map.Entry<String, Object>> iterator = headerMap.entrySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Map.Entry<String, Object> next = iterator.next();
                Cell hssfCell = hssfRow.createCell(i);
                hssfCell.setCellValue(String.valueOf(next.getValue()));
                sheet.setDefaultColumnWidth(30);
                hssfCell.setCellStyle(OutExcelUtil.createHeadStyle(workbook));
                ++i;
            }
            ArrayList dataList = new ArrayList();
            for (int d = 0; d < dataArray.size(); ++d) {
                JSONObject dataObj = dataArray.getJSONObject(d);
                tempList = new ArrayList();
                for (String key : headerMap.keySet()) {
                    String value = "";
                    if (dataObj.containsKey((Object)key)) {
                        value = String.valueOf(dataObj.getString(key));
                    }
                    tempList.add(value);
                }
                dataList.add(tempList);
            }
            for (int i1 = 0; i1 < dataList.size(); ++i1) {
                Row dataHssfRow = sheet.createRow(i1 + 1);
                tempList = (List)dataList.get(i1);
                for (int i2 = 0; i2 < tempList.size(); ++i2) {
                    Cell dataHssfCell = dataHssfRow.createCell(i2);
                    dataHssfCell.setCellValue(String.valueOf(tempList.get(i2)));
                    dataHssfCell.setCellStyle(OutExcelUtil.createDataStyle(workbook));
                }
            }
            fileOutputStream = new FileOutputStream(PATH + fileName);
            workbook.write((OutputStream)fileOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileOutputStream.close();
                workbook.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Workbook createWriteWorkBook(String suffixName) {
        Object workbook = null;
        workbook = XLSX.equals(suffixName.toLowerCase()) ? new XSSFWorkbook() : new HSSFWorkbook();
        return workbook;
    }

    public static Workbook createReadWorkBook(String suffixName, InputStream inputStream) {
        Object workbook = null;
        try {
            workbook = XLSX.equals(suffixName.toLowerCase()) ? new XSSFWorkbook(inputStream) : new HSSFWorkbook(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }

    public static CellStyle createHeadStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setFillForegroundColor(IndexedColors.ROYAL_BLUE.getIndex());
        cellStyle.setFillPattern((short)1);
        Font font = workbook.createFont();
        font.setBold(true);
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setFontHeightInPoints((short)12);
        font.setColor(IndexedColors.WHITE.getIndex());
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static CellStyle createDataStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        Font font = workbook.createFont();
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setFontHeightInPoints((short)12);
        font.setColor(IndexedColors.BLACK.getIndex());
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static void main(String[] args) throws Exception {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("name", "\u540d\u5b5722222222222222222");
        linkedHashMap.put("age", "\u5e74\u9f84");
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)"1");
        jsonObject.put("age", null);
        jsonObject.put("sex", (Object)"3");
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("name", (Object)"4");
        jsonObject1.put("age", (Object)"5");
        jsonObject1.put("sex", (Object)"6");
        jsonArray.add((Object)jsonObject);
        jsonArray.add((Object)jsonObject1);
        OutExcelUtil.outExcel(jsonArray, linkedHashMap, "a.xls");
        OutExcelUtil.outExcel(jsonArray, linkedHashMap, "a.xlsx");
    }
}

