/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kr.weitao.common.util.StringUtils;

public class MD5Util {
    private MessageDigest md;
    private long length;
    private InputStream input;
    private String checksum;
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MD5Util() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public void setInputStream(InputStream stream) {
        this.input = stream;
    }

    private static char char2Int(char ch) {
        if (ch >= '0' && ch <= '9') {
            return (char)(ch - 48);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (char)(ch - 97 + 10);
        }
        if (ch >= 'A' && ch <= 'F') {
            return (char)(ch - 65 + 10);
        }
        return ' ';
    }

    private static byte str2Bin(char[] str) {
        char[] tempWord = new char[]{MD5Util.char2Int(str[0]), MD5Util.char2Int(str[1])};
        byte chn = (byte)(tempWord[0] << 4 | tempWord[1]);
        return chn;
    }

    public static byte[] compress(char[] md5chs32len) {
        char[] tem = new char[2];
        byte[] sDst = new byte[md5chs32len.length / 2];
        int j = 0;
        int i = 0;
        while (i + 1 < md5chs32len.length) {
            tem[0] = md5chs32len[i];
            tem[1] = md5chs32len[i + 1];
            sDst[j++] = MD5Util.str2Bin(tem);
            i += 2;
        }
        return sDst;
    }

    public static String unCompress(byte[] md5b16) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < md5b16.length; ++i) {
            byte b = md5b16[i];
            sb.append(Integer.toHexString(b >> 4 & 0xF));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] getMD5Byte16(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(str.getBytes("UTF-8"));
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String byteToHexString(byte[] tmp) {
        char[] str = new char[32];
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            byte byte0 = tmp[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        String s = new String(str);
        return s;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String encode(byte[] binaryData) {
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        for (int i = 0; i < 16; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = hexadecimal[high];
            buffer[i * 2 + 1] = hexadecimal[low];
        }
        return new String(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(File file) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)stream).read(buf, 0, 1024)) != -1) {
                baos.write(buf, 0, len);
            }
            ((InputStream)stream).close();
        }
        catch (Exception exception) {
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (Exception exception) {}
            }
        }
        return baos.toByteArray();
    }

    public void execute() throws IOException {
        this.readInputStream();
        this.setChecksum(this.encode(this.md.digest()));
    }

    private void update(byte[] buffer, int offset, int len) {
        this.md.update(buffer, offset, len);
        this.length += (long)len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInputStream() throws IOException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(this.input);
            this.reset();
            int len = 0;
            byte[] buffer = new byte[8192];
            while ((len = bis.read(buffer)) > -1) {
                this.update(buffer, 0, len);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void reset() {
        this.md.reset();
        this.length = 0L;
    }

    public static String toCheckSumStr(String str) throws IOException {
        MD5Util sum = new MD5Util();
        sum.setInputStream(new ByteArrayInputStream(str.getBytes("UTF-8")));
        sum.execute();
        return sum.getChecksum();
    }

    public static String toCheckSum(InputStream fileStream) throws IOException {
        MD5Util sum = new MD5Util();
        sum.setInputStream(fileStream);
        sum.execute();
        return sum.getChecksum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toCheckSum(String file) throws IOException {
        MD5Util sum = new MD5Util();
        FileInputStream fileStream = new FileInputStream(file);
        try {
            sum.setInputStream(fileStream);
            sum.execute();
            String string = sum.getChecksum();
            return string;
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String getSign(String ts, String userId, String skey) {
        String sign = null;
        try {
            new MD5Util();
            sign = MD5Util.toCheckSumStr(userId + ts + skey);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sign;
    }

    public static String getMD5Str32(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        if (MD5Util.getMD5Byte16(str) == null) {
            return null;
        }
        return MD5Util.byteToHexString(MD5Util.getMD5Byte16(str));
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(MD5Util.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return StringUtils.valueOf(Character.valueOf(hexDigits[d1])) + StringUtils.valueOf(Character.valueOf(hexDigits[d2]));
    }

    public static String MD5Encode(String origin, String charsetname) {
        String resultString = null;
        try {
            resultString = new String(origin);
            MessageDigest md = MessageDigest.getInstance("MD5");
            resultString = charsetname == null || "".equals(charsetname) ? MD5Util.byteArrayToHexString(md.digest(resultString.getBytes())) : MD5Util.byteArrayToHexString(md.digest(resultString.getBytes(charsetname)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultString;
    }
}

