/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kr.weitao.common.util.MD5Util;
import kr.weitao.common.util.RestUtils;
import kr.weitao.common.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeysenApiUtil {
    private static final Logger log = LoggerFactory.getLogger(LeysenApiUtil.class);

    public static void main(String[] args) {
        JSONObject jsonObject = new JSONObject();
        String key = "07031dec76d8-4cfd-4f73-b9e2-749c2d1224c3";
        jsonObject.put("appName", (Object)"10011");
        jsonObject.put("appTime", (Object)(TimeUtils.formatDateByPattern(new Date(), "yyyyMMddHHmmss") + key));
        String characterEncoding = "UTF-8";
        String mySign = LeysenApiUtil.createSign(characterEncoding, jsonObject, key);
        System.out.println("\u6211 \u7684\u7b7e\u540d\u662f\uff1a" + mySign);
    }

    public static String createSign(String characterEncoding, JSONObject jsonObject, String key) {
        String newKey = "appName=" + jsonObject.getString("appName") + "&appTime=" + jsonObject.getString("appTime") + key;
        System.out.println("\u5b57\u7b26\u4e32:" + newKey);
        String sign = MD5Util.MD5Encode(newKey, characterEncoding).toUpperCase();
        System.out.println("MD5\u52a0\u5bc6\u503c:" + sign);
        return sign;
    }

    public static JSONObject getToken(JSONObject object, String domain) {
        JSONObject tokenObject = new JSONObject();
        tokenObject = object;
        String appName = object.getString("appName");
        String appKey = object.getString("appKey");
        tokenObject.put("appName", (Object)appName);
        tokenObject.put("appTime", (Object)TimeUtils.formatDateByPattern(new Date(), "yyyyMMddHHmmss"));
        String sign = LeysenApiUtil.createSign("UTF-8", tokenObject, appKey);
        tokenObject.put("sign", (Object)sign);
        String resutStr = null;
        try {
            resutStr = RestUtils.sendRequest_buff(domain + "/leysen/thrid/token/getToken", tokenObject.toString(), "POST");
            log.info("---| get token param:{},url:{}", (Object)tokenObject.toString(), (Object)(domain + "/leysen/thrid/token/getToken"));
            log.info("---| get token result:{}", (Object)resutStr);
        }
        catch (Exception e) {
            log.error("get erp api token error");
            e.printStackTrace();
        }
        JSONObject result = JSONObject.parseObject(resutStr);
        if (!"0000".equals(result.getString("code"))) {
            log.error("get Leysen token Api error");
        }
        tokenObject.put("token", (Object)result.getString("data"));
        log.debug("get token:" + tokenObject.toString());
        return tokenObject;
    }
}

