/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static OkHttpClient client = null;
    private static HashMap<String, List<Cookie>> cookieStore = new HashMap();
    private static Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    private static ConnectionPool connectionPool() {
        return new ConnectionPool(5, 5L, TimeUnit.MINUTES);
    }

    public static String executeGet(String url, Map<String, String> head) {
        String bodyStr = null;
        try {
            Request.Builder build = new Request.Builder().url(url);
            if (head != null) {
                Set<String> set = head.keySet();
                for (String key : set) {
                    build.header(key, head.get(key));
                }
            }
            Request request = build.build();
            Response response = null;
            response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                bodyStr = response.body().string();
            } else {
                logger.warn("bodyStr:{}", (Object)response.body().string());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bodyStr;
    }

    public static String executePost(String url, Map<String, String> head, Map<String, String> param) {
        String bodyStr = null;
        try {
            Request.Builder build = new Request.Builder().url(url);
            if (head != null) {
                Set<String> headSet = head.keySet();
                for (String string : headSet) {
                    build.header(string, head.get(string));
                }
            }
            FormBody.Builder formBody = new FormBody.Builder();
            if (param != null) {
                Set<String> paramSet = param.keySet();
                for (String key : paramSet) {
                    formBody.add(key, param.get(key));
                }
            }
            Request request = build.post((RequestBody)formBody.build()).build();
            Object var7_11 = null;
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                bodyStr = response.body().string();
            } else {
                logger.warn("bodyStr:{}", (Object)response.body().string());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bodyStr;
    }

    public static String executeUploadFileAndParam(String url, Map<String, String> head, List<File> files, Map<String, String> param) {
        String bodyStr = null;
        try {
            Request.Builder build = new Request.Builder().url(url);
            if (head != null) {
                Set<String> headSet = head.keySet();
                for (String string : headSet) {
                    build.header(string, head.get(string));
                }
            }
            MultipartBody.Builder multiBuild = new MultipartBody.Builder();
            multiBuild.setType(MultipartBody.FORM);
            if (files != null) {
                for (int i = 0; i < files.size(); ++i) {
                    multiBuild.addFormDataPart("file", files.get(i).getName(), RequestBody.create(null, (File)files.get(i)));
                }
            }
            if (param != null) {
                Set<String> paramSet = param.keySet();
                for (String key : paramSet) {
                    multiBuild.addFormDataPart(key, param.get(key));
                }
            }
            Request request = build.post((RequestBody)multiBuild.build()).build();
            Object var8_13 = null;
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                bodyStr = response.body().string();
            } else {
                logger.warn("bodyStr:{}", (Object)response.body().string());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bodyStr;
    }

    public static String executePost(String url, String json, Map<String, String> head) {
        String bodyStr = null;
        try {
            RequestBody body;
            Request request;
            Response response;
            Request.Builder build = new Request.Builder().url(url);
            if (head != null) {
                Set<String> headSet = head.keySet();
                for (String key : headSet) {
                    build.header(key, head.get(key));
                }
            }
            if ((response = client.newCall(request = build.post(body = RequestBody.create((MediaType)JSON, (String)json)).build()).execute()).isSuccessful()) {
                bodyStr = response.body().string();
            } else {
                logger.warn("bodyStr:{}", (Object)response.body().string());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bodyStr;
    }

    public static byte[] executeGetToBytes(String url, Map<String, String> head) {
        byte[] bodyStr = new byte[]{};
        try {
            Request.Builder build = new Request.Builder().url(url);
            if (head != null) {
                Set<String> set = head.keySet();
                for (String key : set) {
                    build.header(key, head.get(key));
                }
            }
            Request request = build.build();
            Response response = null;
            response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                bodyStr = response.body().bytes();
            } else {
                logger.warn("bodyStr:{}", (Object)response.body().string());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bodyStr;
    }

    public static byte[] executePostToBytes(String url, String json, Map<String, String> head) {
        byte[] bodyStr = new byte[]{};
        try {
            RequestBody body;
            Request request;
            Response response;
            Request.Builder build = new Request.Builder().url(url);
            if (head != null) {
                Set<String> headSet = head.keySet();
                for (String key : headSet) {
                    build.header(key, head.get(key));
                }
            }
            if ((response = client.newCall(request = build.post(body = RequestBody.create((MediaType)JSON, (String)json)).build()).execute()).isSuccessful()) {
                bodyStr = response.body().bytes();
            } else {
                logger.warn("bodyStr:{}", (Object)response.body().string());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bodyStr;
    }

    public static String executeDelete(String url, String json, Map<String, String> head) {
        String bodyStr = null;
        try {
            RequestBody body;
            Request request;
            Response response;
            Request.Builder build = new Request.Builder().url(url);
            if (head != null) {
                Set<String> headSet = head.keySet();
                for (String key : headSet) {
                    build.header(key, head.get(key));
                }
            }
            if ((response = client.newCall(request = build.delete(body = RequestBody.create((MediaType)JSON, (String)json)).build()).execute()).isSuccessful()) {
                bodyStr = response.body().string();
            } else {
                logger.warn("bodyStr:{}", (Object)response.body().string());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bodyStr;
    }

    public static String executePut(String url, String json, Map<String, String> head) {
        String bodyStr = null;
        try {
            RequestBody body;
            Request request;
            Response response;
            Request.Builder build = new Request.Builder().url(url);
            if (head != null) {
                Set<String> headSet = head.keySet();
                for (String key : headSet) {
                    build.header(key, head.get(key));
                }
            }
            if ((response = client.newCall(request = build.put(body = RequestBody.create((MediaType)JSON, (String)json)).build()).execute()).isSuccessful()) {
                bodyStr = response.body().string();
            } else {
                logger.warn("bodyStr:{}", (Object)response.body().string());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bodyStr;
    }

    static {
        client = new OkHttpClient.Builder().cookieJar(new CookieJar(){

            public void saveFromResponse(HttpUrl httpUrl, List<Cookie> list) {
                cookieStore.put(httpUrl.host(), list);
            }

            public List<Cookie> loadForRequest(HttpUrl httpUrl) {
                List cookies = (List)cookieStore.get(httpUrl.host());
                return cookies != null ? cookies : new ArrayList();
            }
        }).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).retryOnConnectionFailure(true).connectionPool(HttpClientUtils.connectionPool()).build();
    }
}

