/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final String TMP_IMAGE_NAME = "image";
    private static final String TMP_OTHER_NAME = "other";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFile(String url) {
        log.info("---| url\u8f6c\u6362\u4e3afile\u5bf9\u8c61,url:{}", (Object)url);
        FileUtils u = new FileUtils();
        String path = u.getClass().getResource("/").getPath();
        log.info("---| path:{}", (Object)path);
        String suffixFileName = url.substring(url.lastIndexOf("."), url.length());
        String urlFileName = url.substring(url.lastIndexOf("/"), url.length());
        File file = null;
        InputStream input = null;
        OutputStream output = null;
        try {
            String uri = suffixFileName.contains("jpg") || suffixFileName.contains("png") || suffixFileName.contains("jpeg") || suffixFileName.contains("bmp") ? TMP_IMAGE_NAME : TMP_OTHER_NAME;
            file = new File(path + uri + "/");
            if (!file.exists()) {
                file.mkdir();
            }
            file = new File(path + uri + urlFileName);
            log.info("---| file path:{}", (Object)file.getPath());
            if (file.exists()) {
                File file2 = file;
                return file2;
            }
            URL urlFile = new URL(url);
            input = urlFile.openStream();
            output = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[1024];
            while ((bytesRead = input.read(buffer, 0, 1024)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            log.error("net file address convert to File object error! message:" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (null != input) {
                    input.close();
                }
                if (null != output) {
                    output.close();
                }
            }
            catch (Exception e) {
                log.error("stream close error! message:" + e.getMessage(), (Throwable)e);
            }
        }
        return file;
    }
}

