/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.wx.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.weitao.business.common.agent.UserAgent;
import kr.weitao.business.entity.Corp;
import kr.weitao.business.entity.LogOrderSendQYMsg;
import kr.weitao.business.entity.User;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.Base64Util;
import kr.weitao.common.util.HttpClientUtils;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.common.util.XMLUtil;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.redis.RedisClient;
import kr.weitao.wechat.service.utils.ThreadPoolUtil;
import kr.weitao.wechat.service.wx.NetWorkCommon;
import kr.weitao.wechat.service.wx.WxService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class WxServiceImpl
implements WxService {
    private static final Logger log = LogManager.getLogger(WxServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisClient redisClient;
    @Autowired
    UserAgent userAgent;
    @Autowired
    AliCDNUrlAuth aliCDNUrlAuth;
    @Autowired
    private ThreadPoolUtil threadPool;
    @Value(value="${spring.profiles.active}")
    private String active;
    private static final String GET_TOKEN_INTERFACE = "/gettoken";
    private static final String GET_JSCODE2SESSION_INTERFACE = "/miniprogram/jscode2session";
    private static final String SEND_QY_MSG = "/message/send";
    @Value(value="${work.weixin.baseUrl}")
    private String baseUrl;
    @Value(value="${weixin.server.domain}")
    private String domain;
    public static final String NotOnline = "401";
    public static final String BASE64_HEAD = "data:img/jpg;base64,";

    public DataResponse genQrcode(DataRequest dataRequest) {
        this.userLogout(dataRequest);
        JSONObject data = dataRequest.getData();
        String userId = data.getString("user_id");
        String rebind = data.getString("rebind");
        String auto_login = data.getString("auto_login");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("deviceId", (Object)userId);
        jsonObject.put("noticeUrl", (Object)this.domain);
        jsonObject.put("proxyIp", (Object)"");
        jsonObject.put("proxyUserName", (Object)"");
        jsonObject.put("proxyPassword", (Object)"");
        if (StringUtils.isNull((Object)rebind)) {
            jsonObject.put("auto_login", (Object)"Y");
        }
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
        String port = this.getUserPort("");
        log.info("------port-----" + port);
        String result = "\u5fae\u4fe1\u7ed1\u5b9a\u529f\u80fd\u6b63\u5728\u7ef4\u62a4,\u6682\u505c\u4f7f\u7528";
        try {
            if (this.redisClient.exists("wxBind_" + userId)) {
                JSONObject object = JSONObject.parseObject((String)this.redisClient.getValueOps().getValueString("wxBind_" + userId));
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(object);
            }
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/api/Login/GetQrCode", (String)port);
            log.info("--WX_GET_GENQRCODE_PATH---" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.getBoolean("Success").booleanValue()) {
                JSONObject resultData = object.getJSONObject("Data");
                this.redisClient.getValueOps().setValueStringWithExpire("wxBind_" + userId, resultData.toJSONString(), Long.valueOf(600L));
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(resultData);
            }
            String msg = object.getString("Message");
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
            return new DataResponse().setStatus(Status.FAILED).setMsg(result);
        }
    }

    public DataResponse userLogout(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String userId = data.getString("user_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)userId);
        jsonObject.put("update", (Object)true);
        String result = "";
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        if (StringUtils.isNull((Object)user_.getWx_id())) {
            return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
        }
        log.info("----user----" + user_);
        String port = this.getUserPort(user_.getPort());
        String path = "/api/Login/LogOut/{wxId}";
        path = path.replace("{wxId}", user_.getWx_id());
        try {
            result = NetWorkCommon.commonwx((JSONObject)new JSONObject(), (String)path, (String)port);
            log.info("---------" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.getBoolean("Success").booleanValue()) {
                jsonObject.put("message", (Object)object);
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
            }
            String msg = object.getString("Message");
            if (NotOnline.equals(object.getString("Code"))) {
                msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
            }
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
            return new DataResponse().setStatus(Status.FAILED).setMsg(result);
        }
    }

    public DataResponse checkLogin(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String userId = data.getString("user_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)userId);
        jsonObject.put("active", (Object)this.active);
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = this.getUserPort(user_.getPort());
        if (!this.redisClient.exists("wxBind_" + userId)) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u5f53\u524d\u7528\u6237\u5df2\u79bb\u7ebf");
        }
        JSONObject qrcodeObject = JSONObject.parseObject((String)this.redisClient.getValueOps().getValueString("wxBind_" + userId));
        String qrcode = qrcodeObject.getString("QrBase64");
        String expiredTime = qrcodeObject.getString("ExpiredTime");
        String uuid = qrcodeObject.getString("Uuid");
        String path = "/api/Login/CheckLogin/{uuid}";
        path = path.replace("{uuid}", uuid);
        try {
            String result = NetWorkCommon.commonwx((JSONObject)new JSONObject(), (String)path, (String)port);
            log.debug(" ===checkLogin= :" + result);
            JSONObject object = JSON.parseObject((String)result);
            if (object.getBoolean("Success").booleanValue()) {
                JSONObject resultData = object.getJSONObject("Data");
                jsonObject.put("message", (Object)"offline");
                jsonObject.put("is_online", (Object)false);
                jsonObject.put("expiredTime", (Object)expiredTime);
                jsonObject.put("qr_code", (Object)qrcode);
                try {
                    String wx_id = resultData.getString("WxId");
                    String state = resultData.getString("State");
                    if ("0".equals(state)) {
                        jsonObject.put("has_scan", (Object)false);
                    } else if ("1".equals(state)) {
                        jsonObject.put("has_scan", (Object)true);
                    } else if ("2".equals(state)) {
                        jsonObject.put("has_scan", (Object)true);
                        jsonObject.put("message", (Object)"online");
                        jsonObject.put("is_online", (Object)true);
                    }
                    if (StringUtils.isNotNull((Object)wx_id)) {
                        Update update = new Update();
                        update.set("wx_id", (Object)wx_id);
                        update.set("uin", (Object)wx_id);
                        update.set("head_img", (Object)resultData.getString("HeadUrl"));
                        update.set("nick_name", (Object)resultData.getString("NickName"));
                        update.set("is_online", (Object)"true");
                        String time = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                        update.set("wx_login_time", (Object)time);
                        this.mongoTemplate.upsert(query_, update, User.class);
                        JSONObject wx_object = new JSONObject();
                        wx_object.put("login_time", (Object)time);
                        wx_object.put("user_id", (Object)userId);
                        wx_object.put("way", (Object)"\u626b\u7801\u767b\u5165");
                        wx_object.put("phone", (Object)user_.getPhone());
                        wx_object.put("wx_id", (Object)wx_id);
                        wx_object.put("uin", (Object)user_.getUin());
                        this.mongoTemplate.save((Object)wx_object, "def_wx_login");
                        jsonObject.put("wx_id", (Object)wx_id);
                        jsonObject.put("head_img", (Object)resultData.getString("HeadUrl"));
                        jsonObject.put("nick_name", (Object)resultData.getString("NickName"));
                    }
                }
                catch (Exception wx_id) {
                    // empty catch block
                }
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
            }
            String msg = object.getString("Message");
            if (NotOnline.equals(object.getString("Code"))) {
                try {
                    Update update = new Update();
                    update.set("is_online", (Object)"false");
                    this.mongoTemplate.upsert(query_, update, User.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u8bf7\u6c42\u5931\u8d25");
        }
    }

    public DataResponse getState(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String userId = data.getString("user_id");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)userId);
        jsonObject.put("active", (Object)this.active);
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        if (StringUtils.isNull((Object)user_.getWx_id())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a");
        }
        String port = this.getUserPort(user_.getPort());
        String path = "/api/Login/HeartBeat/{wxId}";
        path = path.replace("{wxId}", user_.getWx_id());
        try {
            String result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)path, (String)port);
            JSONObject object = JSON.parseObject((String)result);
            if (object.getBoolean("Success").booleanValue()) {
                jsonObject.put("message", (Object)"online");
                jsonObject.put("is_online", (Object)true);
                jsonObject.put("wx_id", (Object)user_.getWx_id());
                jsonObject.put("head_img", (Object)user_.getHead_img());
                jsonObject.put("nick_name", (Object)user_.getNick_name());
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
            }
            String msg = object.getString("Message");
            if (NotOnline.equals(object.getString("Code"))) {
                msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
            }
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u5929\u6c14\u592a\u70ed\uff0c\u670d\u52a1\u5668\u907f\u6691\u53bb\u5566\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        }
    }

    public DataResponse getContactListV1(DataRequest dataRequest) {
        String userId;
        block6: {
            JSONObject data = dataRequest.getData();
            userId = data.getString("user_id");
            String result = "";
            Query query_ = new Query();
            query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
            User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("syncKey", (Object)0);
            jsonObject.put("buffer ", (Object)"");
            jsonObject.put("wxId", (Object)user_.getWx_id());
            String port = this.getUserPort(user_.getPort());
            try {
                result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/api/Login/InitUser", (String)port);
                JSONObject object = JSONObject.parseObject((String)result);
                if (object.getBoolean("Success").booleanValue()) {
                    if (object.getJSONObject("Data").containsKey((Object)"InitResponse")) {
                        JSONArray array = new JSONArray();
                        JSONArray contacts = object.getJSONObject("Data").getJSONObject("InitResponse").getJSONArray("ModContacts");
                        for (int i = 0; i < contacts.size(); ++i) {
                            JSONObject contactObj = contacts.getJSONObject(i);
                            JSONObject contact = new JSONObject();
                            contact.put("nick_name", (Object)contactObj.getJSONObject("NickName").getString("String"));
                            contact.put("wx_id", (Object)contactObj.getJSONObject("UserName").getString("String"));
                            contact.put("sex", (Object)contactObj.getString("Sex"));
                            contact.put("remark_name", (Object)contactObj.getJSONObject("Remark").getString("String"));
                            contact.put("is_group", (Object)"false");
                            contact.put("head_img", (Object)"");
                            contact.put("province", (Object)contactObj.getString("Province"));
                            contact.put("city", (Object)contactObj.getString("City"));
                            contact.put("py_initial", (Object)contactObj.getJSONObject("PYInitial").getString("String"));
                            contact.put("remark_py_initial", (Object)contactObj.getJSONObject("RemarkPYInitial").getString("String"));
                            contact.put("u_uin", (Object)user_.getUin());
                            array.add((Object)contact);
                        }
                        jsonObject.put("message", (Object)array);
                        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                    }
                    break block6;
                }
                String msg = object.getString("Message");
                if (NotOnline.equals(object.getString("Code"))) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25--user_id---" + userId, (Throwable)e);
            }
        }
        log.info("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25--user_id---" + userId);
        return new DataResponse().setStatus(Status.FAILED).setMsg("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25--user_id---" + userId);
    }

    public DataResponse getContactList(DataRequest dataRequest) {
        String userId;
        block10: {
            JSONObject data = dataRequest.getData();
            userId = data.getString("user_id");
            String syncId = data.getString("sync_id");
            String result = "";
            Query query_ = new Query();
            query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
            User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
            String port = this.getUserPort(user_.getPort());
            try {
                JSONArray array = new JSONArray();
                int currentWxcontactSeq = 0;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("currentWxcontactSeq", (Object)0);
                jsonObject.put("currentChatRoomContactSeq ", (Object)0);
                jsonObject.put("wxId", (Object)user_.getWx_id());
                result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/api/Friend/GetContractList", (String)port);
                JSONObject object = JSONObject.parseObject((String)result);
                if (object.getBoolean("Success").booleanValue()) {
                    if (object.getJSONObject("Data").containsKey((Object)"Contracts")) {
                        int i;
                        ArrayList<String> allContacts = new ArrayList<String>();
                        int newCurrentWxcontactSeq = object.getJSONObject("Data").getInteger("CurrentWxcontactSeq");
                        JSONArray contacts = object.getJSONObject("Data").getJSONArray("Contracts");
                        for (i = 0; i < contacts.size(); ++i) {
                            if (contacts.getString(i).startsWith("gh_") || allContacts.contains(contacts.getString(i))) continue;
                            allContacts.add(contacts.getString(i));
                        }
                        while (newCurrentWxcontactSeq != currentWxcontactSeq) {
                            currentWxcontactSeq = newCurrentWxcontactSeq;
                            jsonObject.put("currentWxcontactSeq", (Object)currentWxcontactSeq);
                            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/api/Friend/GetContractList", (String)port);
                            object = JSONObject.parseObject((String)result);
                            if (!object.getBoolean("Success").booleanValue() || !object.getJSONObject("Data").containsKey((Object)"Contracts")) continue;
                            newCurrentWxcontactSeq = object.getJSONObject("Data").getInteger("CurrentWxcontactSeq");
                            if (!StringUtils.isNotNull((Object)object.getJSONObject("Data").get((Object)"Contracts"))) break;
                            contacts = object.getJSONObject("Data").getJSONArray("Contracts");
                            for (i = 0; i < contacts.size(); ++i) {
                                if (contacts.getString(i).startsWith("gh_") || contacts.getString(i).contains("@chatroom") || allContacts.contains(contacts.getString(i))) continue;
                                allContacts.add(contacts.getString(i));
                            }
                        }
                        int size = allContacts.size();
                        int pages = size / 20 + 1;
                        JSONObject batchProfileParam = new JSONObject();
                        for (int i2 = 0; i2 < pages; ++i2) {
                            int end = (i2 + 1) * 20 <= size - 1 ? (i2 + 1) * 20 : size - 1;
                            List searchWxIds = allContacts.subList(i2 * 20, end);
                            batchProfileParam.put("searchWxIds", searchWxIds);
                            batchProfileParam.put("wxId", (Object)user_.getWx_id());
                            JSONObject batchProfileResult = JSONObject.parseObject((String)NetWorkCommon.commonwx((JSONObject)batchProfileParam, (String)"/api/Friend/GetContractDetail", (String)port));
                            if (!batchProfileResult.getBoolean("Success").booleanValue()) continue;
                            JSONArray contactProfiles = batchProfileResult.getJSONArray("Data");
                            for (int j = 0; j < contactProfiles.size(); ++j) {
                                JSONObject contactObj = contactProfiles.getJSONObject(j);
                                JSONObject contact = new JSONObject();
                                contact.put("nick_name", (Object)contactObj.getJSONObject("NickName").getString("String"));
                                contact.put("wx_id", (Object)contactObj.getJSONObject("UserName").getString("String"));
                                contact.put("sex", (Object)contactObj.getString("Sex"));
                                contact.put("remark_name", (Object)contactObj.getJSONObject("Remark").getString("String"));
                                contact.put("is_group", (Object)"false");
                                contact.put("head_img", (Object)contactObj.getString("SmallHeadImgUrl"));
                                contact.put("province", (Object)contactObj.getString("Province"));
                                contact.put("city", (Object)contactObj.getString("City"));
                                contact.put("py_initial", (Object)contactObj.getJSONObject("PYInitial").getString("String"));
                                contact.put("remark_py_initial", (Object)contactObj.getJSONObject("RemarkPYInitial").getString("String"));
                                contact.put("u_uin", (Object)user_.getUin());
                                contact.put("user_wx_id", (Object)user_.getWx_id());
                                array.add((Object)contact);
                            }
                        }
                        jsonObject.put("message", (Object)array);
                        jsonObject.put("message", (Object)array);
                        jsonObject.put("sync_id", (Object)syncId);
                        jsonObject.put("user_id", (Object)userId);
                        this.userAgent.getData(jsonObject, "/vip/syncContacts");
                        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
                    }
                    break block10;
                }
                String msg = object.getString("Message");
                if (NotOnline.equals(object.getString("Code"))) {
                    msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
                }
                return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25--user_id---" + userId, (Throwable)e);
            }
        }
        log.info("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25--user_id---" + userId);
        return new DataResponse().setStatus(Status.FAILED).setMsg("-\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25--user_id---" + userId);
    }

    public DataResponse snsUploadImg(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String userId = data.getString("user_id");
        String imgKey = data.getString("img_key");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
        User user_ = (User)this.mongoTemplate.findOne(query, User.class);
        String port = this.getUserPort(user_.getPort());
        String result = "";
        try {
            imgKey = this.aliCDNUrlAuth.getAuthUrl(imgKey);
            JSONArray base64s = new JSONArray();
            base64s.add((Object)(BASE64_HEAD + Base64Util.ImageToBase64ByOnline((String)imgKey)));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("wxId", (Object)user_.getWx_id());
            jsonObject.put("base64s", (Object)base64s);
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/api/FriendCircle/SendFriendCircleImage", (String)port);
            log.info("-snsUploadImg--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.getBoolean("Success").booleanValue()) {
                JSONObject dataObj = object.getJSONArray("Data").getJSONObject(0);
                dataObj.put("url", (Object)dataObj.getJSONObject("BufferUrl").getString("Url"));
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(dataObj);
            }
            String msg = object.getString("Message");
            if (StringUtils.isNull((Object)msg)) {
                msg = "\u4e0a\u4f20\u56fe\u7247\u5931\u8d25";
            }
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
            return new DataResponse().setStatus(Status.FAILED).setMsg(result);
        }
    }

    public DataResponse snsPublish(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String userId = data.getString("user_id");
        String type = data.getString("type");
        String content = data.getString("content");
        JSONArray pictures = data.getJSONArray("pictures");
        String title = data.getString("title");
        String contentUrl = data.getString("url");
        String description = data.getString("content_desc");
        int snsType = 0;
        if ("text".equals(type)) {
            snsType = 0;
        } else if ("picture".equals(type)) {
            snsType = 1;
        } else if ("video".equals(type)) {
            snsType = 2;
        } else if ("link".equals(type)) {
            snsType = 3;
        }
        JSONArray medias = new JSONArray();
        DataRequest dataRequest1 = new DataRequest();
        JSONObject data1 = new JSONObject();
        if (StringUtils.isNotNull((Object)pictures)) {
            for (int i = 0; i < pictures.size(); ++i) {
                String img = pictures.getString(i);
                JSONObject object = new JSONObject();
                object.put("url", (Object)"");
                object.put("width", (Object)0);
                object.put("height", (Object)0);
                object.put("totalSize", (Object)0);
                if (!img.contains("mmsns.qpic.cn")) {
                    data1.put("user_id", (Object)userId);
                    data1.put("img_key", (Object)img);
                    dataRequest1.setData(data1);
                    DataResponse dataResponse1 = this.snsUploadImg(dataRequest1);
                    if (!dataResponse1.getStatus().equals((Object)Status.SUCCESS)) continue;
                    object.put("imageUrl", (Object)dataResponse1.getData().getString("url"));
                    medias.add((Object)object);
                    continue;
                }
                object.put("imageUrl", (Object)img);
                medias.add((Object)object);
            }
        }
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = this.getUserPort(user_.getPort());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("blackList", (Object)new JSONArray());
        jsonObject.put("withUserList", (Object)new JSONArray());
        jsonObject.put("type", (Object)snsType);
        jsonObject.put("mediaInfos", (Object)medias);
        jsonObject.put("title", (Object)title);
        jsonObject.put("contentUrl", (Object)contentUrl);
        jsonObject.put("description", (Object)description);
        jsonObject.put("content", (Object)content);
        jsonObject.put("wxId", (Object)user_.getWx_id());
        String result = "";
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/api/FriendCircle/SendFriendCircle", (String)port);
            log.info("-snsPublish--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.getBoolean("Success").booleanValue()) {
                String buffer = object.getJSONObject("Data").getJSONObject("objectDesc").getString("buffer");
                Map map = XMLUtil.doXMLParse((String)buffer);
                jsonObject.put("message", (Object)"");
                jsonObject.put("status", (Object)0);
                jsonObject.put("data", (Object)map);
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
            }
            String msg = object.getString("Message");
            if (StringUtils.isNull((Object)msg)) {
                msg = "\u53d1\u5e03\u670b\u53cb\u5708\u5931\u8d25";
            }
            if (NotOnline.equals(object.getString("Code"))) {
                msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
            }
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
            return new DataResponse().setStatus(Status.FAILED).setMsg(result);
        }
    }

    public DataResponse snsRemove(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String content_id = data.getString("content_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = this.getUserPort(user_.getPort());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("wxId", (Object)user_.getWx_id());
        jsonObject.put("id", (Object)content_id);
        jsonObject.put("type", (Object)1);
        String result = "";
        try {
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/api/FriendCircle/SetFriendCircle", (String)port);
            log.info("-snsRemove--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.getBoolean("Success").booleanValue()) {
                jsonObject.put("message", (Object)JSONObject.parseObject((String)result).getJSONObject("data"));
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
            }
            String msg = object.getString("Message");
            if (StringUtils.isNull((Object)msg)) {
                msg = "\u5220\u9664\u5931\u8d25";
            }
            if (NotOnline.equals(object.getString("Code"))) {
                msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
            }
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
            return new DataResponse().setStatus(Status.FAILED).setMsg(result);
        }
    }

    public DataResponse getOnlineUsers(DataRequest dataRequest) {
        try {
            ArrayList<String> wx_ids = new ArrayList<String>();
            String result = NetWorkCommon.commonwx((JSONObject)new JSONObject(), (String)"/api/Common/GetOnlineWechat", (String)"8080");
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.getBoolean("Success").booleanValue()) {
                JSONArray total_user_list = object.getJSONArray("Data");
                for (int i = 0; i < total_user_list.size(); ++i) {
                    if (2 != total_user_list.getJSONObject(i).getInteger("state")) continue;
                    wx_ids.add(total_user_list.getJSONObject(i).getString("wx_id"));
                }
                BasicDBObject userQuery = new BasicDBObject();
                userQuery.put((Object)"wx_id", (Object)new BasicDBObject("$in", wx_ids));
                BasicDBObject userShow = new BasicDBObject();
                userShow.put((Object)"user_id", (Object)1);
                DBCursor users = this.mongoTemplate.getCollection("def_user").find((DBObject)userQuery);
                ArrayList<String> user_ids = new ArrayList<String>();
                while (users.hasNext()) {
                    user_ids.add(users.next().get("user_id").toString());
                }
                JSONObject data = new JSONObject();
                data.put("message", user_ids);
                log.info("---------" + data);
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(data);
            }
            return new DataResponse().setStatus(Status.FAILED).setMsg(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DataResponse().setStatus(Status.FAILED).setMsg(e.getLocalizedMessage());
        }
    }

    public DataResponse getUserQrcode(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String userId = data.getString("user_id");
        Query query_ = new Query();
        query_.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
        User user_ = (User)this.mongoTemplate.findOne(query_, User.class);
        String port = this.getUserPort(user_.getPort());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("user_id", (Object)userId);
        String result = "";
        String path = "/api/Common/GetMyQrCode/{wxId}/{toWxId}";
        path = path.replace("{wxId}", user_.getWx_id()).replace("{toWxId}", user_.getWx_id());
        try {
            result = NetWorkCommon.commonwx((JSONObject)new JSONObject(), (String)path, (String)port);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.getBoolean("Success").booleanValue()) {
                String qrCode = object.getString("Data");
                qrCode = qrCode.replace(BASE64_HEAD, "");
                object.put("qr_code", (Object)qrCode);
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(object);
            }
            String msg = object.getString("Message");
            if (StringUtils.isNull((Object)msg)) {
                msg = "\u83b7\u53d6\u5931\u8d25";
            }
            if (NotOnline.equals(object.getString("Code"))) {
                msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
            }
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
            return new DataResponse().setStatus(Status.FAILED).setMsg(result);
        }
    }

    public DataResponse sendMsg(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String userId = data.getString("user_id");
        String wxId = data.getString("wx_id");
        String type = data.getString("msg_type");
        String content = data.getString("msg_content");
        Query queryUser = new Query();
        queryUser.addCriteria((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)userId));
        User user = (User)this.mongoTemplate.findOne(queryUser, User.class);
        String port = this.getUserPort(user.getPort());
        String result = "";
        try {
            JSONArray toWxIds = new JSONArray();
            toWxIds.add((Object)wxId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("wxId", (Object)user.getWx_id());
            jsonObject.put("toWxIds", (Object)toWxIds);
            String path = "";
            if ("Text".equals(type)) {
                jsonObject.put("content", (Object)content);
                path = "/api/Message/SendTxtMessage";
            } else if ("Picture".equals(type)) {
                content = this.aliCDNUrlAuth.getAuthUrl(content);
                jsonObject.put("base64", (Object)(BASE64_HEAD + Base64Util.ImageToBase64ByOnline((String)content)));
                path = "/api/Message/SendImageMessage";
            }
            result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)path, (String)port);
            log.info("-sendMsg--" + result);
            JSONObject object = JSONObject.parseObject((String)result);
            if (object.getBoolean("Success").booleanValue()) {
                jsonObject.put("message", (Object)object);
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
            }
            String msg = object.getString("Message");
            if (StringUtils.isNull((Object)msg)) {
                msg = "\u53d1\u5e03\u670b\u53cb\u5708\u5931\u8d25";
            }
            if (NotOnline.equals(object.getString("Code"))) {
                msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
            }
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e, (Throwable)e);
            return new DataResponse().setStatus(Status.FAILED).setMsg(result);
        }
    }

    private String getUserPort(String port) {
        return "10001";
    }

    public static void main(String[] args) throws Exception {
        JSONArray array = new JSONArray();
        String port = "10000";
        int currentWxcontactSeq = 0;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("currentWxcontactSeq", (Object)0);
        jsonObject.put("currentChatRoomContactSeq ", (Object)0);
        jsonObject.put("wxId", (Object)"zy19931021ying");
        String result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/api/Friend/GetContractList", (String)"10000");
        JSONObject object = JSONObject.parseObject((String)result);
        if (object.getBoolean("Success").booleanValue()) {
            if (object.getJSONObject("Data").containsKey((Object)"Contracts")) {
                int i;
                ArrayList<String> allContacts = new ArrayList<String>();
                int newCurrentWxcontactSeq = object.getJSONObject("Data").getInteger("CurrentWxcontactSeq");
                JSONArray contacts = object.getJSONObject("Data").getJSONArray("Contracts");
                for (i = 0; i < contacts.size(); ++i) {
                    if (contacts.getString(i).startsWith("gh_") || allContacts.contains(contacts.getString(i))) continue;
                    allContacts.add(contacts.getString(i));
                }
                while (newCurrentWxcontactSeq != currentWxcontactSeq) {
                    currentWxcontactSeq = newCurrentWxcontactSeq;
                    jsonObject.put("currentWxcontactSeq", (Object)currentWxcontactSeq);
                    result = NetWorkCommon.commonwx((JSONObject)jsonObject, (String)"/api/Friend/GetContractList", (String)port);
                    object = JSONObject.parseObject((String)result);
                    if (!object.getBoolean("Success").booleanValue() || !object.getJSONObject("Data").containsKey((Object)"Contracts")) continue;
                    newCurrentWxcontactSeq = object.getJSONObject("Data").getInteger("CurrentWxcontactSeq");
                    contacts = object.getJSONObject("Data").getJSONArray("Contracts");
                    for (i = 0; i < contacts.size(); ++i) {
                        if (contacts.getString(i).startsWith("gh_") || allContacts.contains(contacts.getString(i))) continue;
                        allContacts.add(contacts.getString(i));
                    }
                }
                int size = allContacts.size();
                int pages = size / 20 + 1;
                JSONObject batchProfileParam = new JSONObject();
                for (int i2 = 0; i2 < pages; ++i2) {
                    int end = (i2 + 1) * 20 <= size - 1 ? (i2 + 1) * 20 : size - 1;
                    List searchWxIds = allContacts.subList(i2 * 20, end);
                    batchProfileParam.put("searchWxIds", searchWxIds);
                    batchProfileParam.put("wxId", (Object)"zy19931021ying");
                    JSONObject batchProfileResult = JSONObject.parseObject((String)NetWorkCommon.commonwx((JSONObject)batchProfileParam, (String)"/api/Friend/GetContractDetail", (String)port));
                    if (!batchProfileResult.getBoolean("Success").booleanValue()) continue;
                    JSONArray contactProfiles = batchProfileResult.getJSONArray("Data");
                    for (int j = 0; j < contactProfiles.size(); ++j) {
                        JSONObject contactObj = contactProfiles.getJSONObject(j);
                        JSONObject contact = new JSONObject();
                        contact.put("nick_name", (Object)contactObj.getJSONObject("NickName").getString("String"));
                        contact.put("wx_id", (Object)contactObj.getJSONObject("UserName").getString("String"));
                        contact.put("sex", (Object)contactObj.getString("Sex"));
                        contact.put("remark_name", (Object)contactObj.getJSONObject("Remark").getString("String"));
                        contact.put("is_group", (Object)"false");
                        contact.put("head_img", (Object)contactObj.getString("SmallHeadImgUrl"));
                        contact.put("province", (Object)contactObj.getString("Province"));
                        contact.put("city", (Object)contactObj.getString("City"));
                        contact.put("py_initial", (Object)contactObj.getJSONObject("PYInitial").getString("String"));
                        contact.put("remark_py_initial", (Object)contactObj.getJSONObject("RemarkPYInitial").getString("String"));
                        array.add((Object)contact);
                    }
                }
                jsonObject.put("message", (Object)array);
            }
        } else {
            String msg = object.getString("Message");
            if (NotOnline.equals(object.getString("Code"))) {
                msg = "\u5f53\u524d\u5fae\u4fe1\u6682\u672a\u7ed1\u5b9a";
            }
        }
    }

    public DataResponse getEnterPriceWechatToken(DataRequest dataRequest) {
        String corpSecret;
        DBObject ew;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DataResponse response = new DataResponse();
        JSONObject resultDate = new JSONObject();
        response.setCode("-1");
        response.setStatus(Status.FAILED);
        JSONObject data = dataRequest.getData();
        String scene = data.getString("scene");
        String corp_code = data.getString("corp_code");
        BasicDBObject queryEw = new BasicDBObject("corp_code", (Object)corp_code);
        queryEw.put("is_active", (Object)"Y");
        queryEw.put("scene", (Object)scene);
        if (StringUtils.isNull((Object)scene)) {
            queryEw.put("scene", (Object)"common");
        }
        if (StringUtils.isNull((Object)(ew = this.mongoTemplate.getCollection("def_enterprise_wechat").findOne((DBObject)queryEw)))) {
            response.setMsg("\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u5fae\u4fe1\u7684\u76f8\u5173\u4fe1\u606f");
            return response;
        }
        String id = ew.get("_id").toString();
        String corpId = ew.get("corpId") != null ? ew.get("corpId").toString() : "";
        String string = corpSecret = ew.get("corpSecret") != null ? ew.get("corpSecret").toString() : "";
        if (StringUtils.isNull((Object)corpId) && StringUtils.isNull((Object)corpSecret)) {
            response.setMsg("\u5173\u952e\u6570\u636e\u7f3a\u5931");
            return response;
        }
        Date now = new Date();
        if (StringUtils.isNotNull((Object)ew.get("expire_date")) && StringUtils.isNotNull((Object)ew.get("token"))) {
            Date expireDate = new Date();
            try {
                expireDate = format.parse(ew.get("expire_date").toString());
                if (expireDate.compareTo(now) > 0) {
                    resultDate.put("token", (Object)ew.get("token").toString());
                    response.setMsg("\u83b7\u53d6token\u6210\u529f");
                    response.setData(resultDate);
                    response.setCode("0");
                    response.setStatus(Status.SUCCESS);
                    return response;
                }
            }
            catch (Exception e) {
                log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
            }
        }
        StringBuilder url = new StringBuilder(this.baseUrl).append(GET_TOKEN_INTERFACE);
        url.append("?corpid=").append(corpId).append("&").append("corpsecret=").append(corpSecret);
        String nowString = format.format(now);
        try {
            String wxResponse = HttpClientUtils.executeGet((String)url.toString(), null);
            if (StringUtils.isNull((Object)wxResponse)) {
                response.setMsg("\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a");
                return response;
            }
            JSONObject wxObj = JSONObject.parseObject((String)wxResponse);
            if (wxObj.getInteger("errcode") != 0) {
                response.setMsg(wxObj.getString("errmsg"));
                return response;
            }
            String token = wxObj.getString("access_token");
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scene").is((Object)scene));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
            Update update = new Update();
            update.set("modified_date", (Object)nowString);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            calendar.add(10, 2);
            String expireDateString = format.format(calendar.getTime());
            update.set("expire_date", (Object)expireDateString);
            update.set("token", (Object)token);
            this.mongoTemplate.updateFirst(query, update, "def_enterprise_wechat");
            resultDate.put("token", (Object)token);
        }
        catch (Exception e) {
            log.error("\u9519\u8bef\u4fe1\u606f", (Throwable)e);
        }
        response.setData(resultDate);
        response.setMsg("\u83b7\u53d6\u6210\u529f");
        response.setCode("0");
        response.setStatus(Status.SUCCESS);
        return response;
    }

    public DataResponse getQYCode2Session(DataRequest dataRequest) {
        DataResponse enterPriceWechatTokenResponse;
        Corp corp;
        DataResponse response = new DataResponse();
        response.setCode("-1");
        response.setStatus(Status.FAILED);
        JSONObject data = dataRequest.getData();
        String js_code = data.getString("js_code");
        if (StringUtils.isNull((Object)js_code)) {
            response.setMsg("\u8bf7\u6c42\u53c2\u6570js_code\u4e3a\u7a7a");
            return response;
        }
        String mini_appid = data.getString("mini_appid");
        if (StringUtils.isNotNull((Object)mini_appid) && StringUtils.isNotNull((Object)(corp = (Corp)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"mini_appid").is((Object)mini_appid)), Corp.class)))) {
            data.put("corp_code", (Object)corp.getCorp_code());
            dataRequest.setData(data);
        }
        if (Integer.parseInt((enterPriceWechatTokenResponse = this.getEnterPriceWechatToken(dataRequest)).getCode()) < 0) {
            return enterPriceWechatTokenResponse;
        }
        JSONObject getTokenData = enterPriceWechatTokenResponse.getData();
        String token = getTokenData.getString("token");
        if (StringUtils.isNull((Object)token)) {
            response.setMsg("\u83b7\u53d6token\u4e3a\u7a7a");
            return response;
        }
        StringBuilder url = new StringBuilder(this.baseUrl).append(GET_JSCODE2SESSION_INTERFACE).append("?access_token=").append(token).append("&js_code=").append(js_code).append("&grant_type=authorization_code");
        String s = HttpClientUtils.executeGet((String)url.toString(), null);
        if (StringUtils.isNull((Object)s)) {
            return response;
        }
        JSONObject resultObject = JSONObject.parseObject((String)s);
        if (resultObject.getInteger("errcode") != 0) {
            response.setMsg(resultObject.getString("errmsg"));
            return response;
        }
        response.setCode("0");
        response.setStatus(Status.SUCCESS);
        response.setData(resultObject);
        return response;
    }

    public DataResponse sendQYMsg(DataRequest dataRequest) {
        DataResponse enterPriceWechatTokenResponse = this.getEnterPriceWechatToken(dataRequest);
        DataResponse response = new DataResponse();
        response.setCode("-1");
        response.setStatus(Status.FAILED);
        if (Integer.parseInt(enterPriceWechatTokenResponse.getCode()) < 0) {
            return enterPriceWechatTokenResponse;
        }
        JSONObject data = dataRequest.getData();
        String corp_code = data.getString("corp_code");
        String userIds = data.getString("userIds");
        String party = data.getString("party");
        String tag = data.getString("tag");
        DBObject enterPriseWechat = this.mongoTemplate.getCollection("def_enterprise_wechat").findOne((DBObject)new BasicDBObject("corp_code", (Object)corp_code));
        String agentId = enterPriseWechat.get("agentId").toString();
        String token = enterPriceWechatTokenResponse.getData().getString("token");
        StringBuilder url = new StringBuilder(this.baseUrl).append(SEND_QY_MSG).append("?access_token=").append(token);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("touser", userIds);
        if (StringUtils.isNull((Object)party)) {
            map.put("toparty", "@all");
        } else {
            map.put("toparty", "@all");
        }
        if (StringUtils.isNull((Object)tag)) {
            map.put("totag", "@all");
        } else {
            map.put("totag", tag);
        }
        map.put("agentid", agentId);
        JSONObject text = new JSONObject();
        text.put("content", (Object)data.getString("content"));
        map.put("text", (String)text);
        map.put("safe", "0");
        map.put("msgtype", "text");
        ObjectMapper objectMapper = new ObjectMapper();
        String params = "";
        try {
            params = objectMapper.writeValueAsString(map);
        }
        catch (Exception e) {
            response.setMsg(e.getMessage());
            return response;
        }
        String s = HttpClientUtils.executePost((String)url.toString(), (String)params, new HashMap());
        this.threadPool.getPool().execute(() -> this.sendLog(corp_code, userIds, party, tag, data.getString("content"), s));
        JSONObject resultData = JSONObject.parseObject((String)s);
        response.setData(resultData);
        response.setCode("0");
        response.setStatus(Status.SUCCESS);
        if (resultData.getInteger("errcode") != 0) {
            response.setCode("-1");
            response.setStatus(Status.FAILED);
            response.setMsg(resultData.getString("errmsg"));
            return response;
        }
        return response;
    }

    private void sendLog(String corp_code, String user_ids, String party, String tag, String content, String result) {
        LogOrderSendQYMsg log = new LogOrderSendQYMsg();
        log.setCorp_code(corp_code);
        log.setUser_ids(user_ids);
        log.setParty(party);
        log.setTag(tag);
        log.setContent(content);
        log.setResult(result);
        log.setSend_time(TimeUtils.getTime((long)System.currentTimeMillis()));
        this.mongoTemplate.insert((Object)log);
    }
}

