/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.wx.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import kr.weitao.business.entity.QYWechatTokenManage;
import kr.weitao.business.entity.User;
import kr.weitao.common.exception.CommonException;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.wechat.mp.util.OKHttpUtil;
import kr.weitao.wechat.service.wx.WxLiveService;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class WxLiveServiceImpl
implements WxLiveService {
    private static final Logger log = LogManager.getLogger(WxLiveServiceImpl.class);
    @Autowired
    private OKHttpUtil httpUtil;
    @Autowired
    private MongoTemplate mongoTemplate;

    public DataResponse getToken(DataRequest req) {
        JSONObject data = req.getData();
        if (Objects.isNull(data) || data.isEmpty()) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String mini_appid = data.getString("appId");
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"mini_appid").is((Object)mini_appid).and("scene_type").is((Object)"1"));
        QYWechatTokenManage token = (QYWechatTokenManage)this.mongoTemplate.findOne(query, QYWechatTokenManage.class);
        long now = System.currentTimeMillis();
        if (Objects.isNull(token)) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("token\u914d\u7f6e\u9519\u8bef!");
        }
        if (token.getRefresh_token_date().compareTo(now) > 0) {
            JSONObject result = new JSONObject();
            result.put("access_token", (Object)token.getAccess_token());
            return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(result);
        }
        String corpsecret = token.getScene_secret();
        String corpid = token.getCorp_id();
        if (StringUtils.isBlank((CharSequence)corpid) || StringUtils.isBlank((CharSequence)corpsecret)) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("corpid \u6216 corpsecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = String.format("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s", corpid, corpsecret);
        JSONObject result = this.httpUtil.get(url);
        if (Objects.isNull(result) || result.isEmpty()) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u83b7\u53d6token\u5931\u8d25");
        }
        if (!"0".equals(result.getString("errcode"))) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg(result.getString("errmsg"));
        }
        Update update = new Update();
        update.set("access_token", (Object)result.getString("access_token"));
        update.set("expires_in", (Object)result.getString("expires_in"));
        update.set("refresh_token_date", (Object)(now + (result.getLong("expires_in") - 100L) * 1000L));
        this.mongoTemplate.updateMulti(query, update, QYWechatTokenManage.class);
        return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(result);
    }

    public DataResponse getLivingShareInfo(DataRequest req) {
        log.debug("---| \u83b7\u53d6\u8df3\u8f6c\u5c0f\u7a0b\u5e8f\u5546\u57ce\u7684\u76f4\u64ad\u89c2\u4f17\u4fe1\u606f,\u5165\u53c2:" + JSON.toJSONString((Object)req));
        JSONObject data = req.getData();
        if (Objects.isNull(data) || data.isEmpty()) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String ww_share_code = data.getString("ww_share_code");
        String appId = data.getString("mini_appid");
        String access_token = this.getStringToken(appId);
        String url = String.format("https://qyapi.weixin.qq.com/cgi-bin/living/get_living_share_info?access_token=%s", access_token);
        JSONObject param = new JSONObject();
        param.put("ww_share_code", (Object)ww_share_code);
        JSONObject result = this.httpUtil.jsonPost(param, url);
        String invitor_userid = "";
        String share_userid = "";
        if (Objects.nonNull(result) && !result.isEmpty()) {
            if ("0".equals(result.getString("errcode"))) {
                invitor_userid = result.getString("invitor_userid") != null ? result.getString("invitor_userid") : "";
                Query query = Query.query((CriteriaDefinition)Criteria.where((String)"phone").is((Object)invitor_userid));
                User share_user = (User)this.mongoTemplate.findOne(query, User.class);
                share_userid = Objects.isNull(share_user) ? "" : (share_user.getUser_id() != null ? share_user.getUser_id() : "");
                result.put("invitor_userid", (Object)share_userid);
                return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(result);
            }
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg(result.getString("errmsg"));
        }
        return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u83b7\u53d6\u8df3\u8f6c\u5c0f\u7a0b\u5e8f\u5546\u57ce\u7684\u76f4\u64ad\u89c2\u4f17\u4fe1\u606f\u5931\u8d25");
    }

    public DataResponse getLivingInfo(DataRequest req) {
        String livingid;
        log.debug("---| \u83b7\u53d6\u76f4\u64ad\u8be6\u60c5,\u5165\u53c2:" + JSON.toJSONString((Object)req));
        JSONObject data = req.getData();
        if (Objects.isNull(data) || data.isEmpty()) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String appId = data.getString("mini_appid");
        String token = this.getStringToken(appId);
        String url = String.format("https://qyapi.weixin.qq.com/cgi-bin/living/get_living_info?access_token=%s&livingid=%s", token, livingid = data.getString("livingid"));
        JSONObject result = this.httpUtil.get(url);
        if (Objects.nonNull(result) && !result.isEmpty()) {
            if ("0".equals(result.getString("errcode"))) {
                return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(result.getJSONObject("living_info"));
            }
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg(result.getString("errmsg"));
        }
        return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u83b7\u53d6\u76f4\u64ad\u8be6\u60c5\u5931\u8d25");
    }

    public DataResponse getWatchStat(DataRequest req) {
        log.debug("===\u83b7\u53d6\u76f4\u64ad\u89c2\u770b\u8be6\u60c5\uff0c\u5165\u53c2===" + JSON.toJSONString((Object)req));
        JSONObject data = req.getData();
        if (Objects.isNull(data) || data.isEmpty()) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String livingid = data.getString("livingid");
        String next_key = data.getString("next_key");
        String appId = data.getString("mini_appid");
        String access_token = this.getStringToken(appId);
        JSONObject jsonObject = new JSONObject();
        JSONArray external_users = new JSONArray();
        String url = String.format("https://qyapi.weixin.qq.com/cgi-bin/living/get_watch_stat?access_token=%s", access_token);
        JSONObject params = new JSONObject();
        params.put("livingid", (Object)livingid);
        params.put("next_key", (Object)next_key);
        JSONObject returnJo = this.httpUtil.jsonPost(params, url);
        if (Objects.nonNull(returnJo) && !returnJo.isEmpty()) {
            if ("0".equals(returnJo.getString("errcode"))) {
                JSONObject stat_info;
                Integer ending = returnJo.getInteger("ending");
                if (ending != 1) {
                    while (ending.equals(0)) {
                        next_key = returnJo.getString("next_key");
                        stat_info = returnJo.getJSONObject("stat_info");
                        JSONArray external_users1 = stat_info.getJSONArray("external_users");
                        external_users.add((Object)external_users1);
                        params.put("next_key", (Object)next_key);
                        returnJo = this.httpUtil.jsonPost(params, url);
                        ending = returnJo.getInteger("ending");
                    }
                } else {
                    stat_info = returnJo.getJSONObject("stat_info");
                    external_users = stat_info.getJSONArray("external_users");
                }
                jsonObject.put("external_users", (Object)external_users);
                DataResponse result = new DataResponse();
                log.info("=====\u67e5\u8be2\u5230\u7684\u8be6\u60c5\u4fe1\u606f=====   " + result.toString());
                return result.setCode("0").setStatus(Status.SUCCESS).setData(jsonObject);
            }
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg(returnJo.getString("errmsg"));
        }
        return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u83b7\u53d6\u76f4\u64ad\u89c2\u770b\u8be6\u60c5\u5931\u8d25");
    }

    private String getStringToken(String appid) {
        JSONObject param = new JSONObject();
        param.put("appId", (Object)appid);
        DataRequest req = new DataRequest();
        req.setData(param);
        DataResponse tokenResult = this.getToken(req);
        if (tokenResult.getCode().compareTo("0") != 0) {
            throw new CommonException(tokenResult.getMsg());
        }
        return tokenResult.getData().getString("access_token");
    }
}

