/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.mp.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.wechat.mp.api.PayMchAPI;
import kr.weitao.wechat.mp.bean.paymch.Unifiedorder;
import kr.weitao.wechat.mp.bean.paymch.UnifiedorderResult;
import kr.weitao.wechat.mp.util.SignatureUtil;
import kr.weitao.wechat.service.mp.PayService;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl
implements PayService {
    private static final Logger log = LogManager.getLogger(PayServiceImpl.class);

    public DataResponse getPayInfo(DataRequest dataRequest) {
        JSONObject web_data = dataRequest.getData();
        log.debug("getPayInfo web_data:" + web_data);
        String pay_appid = web_data.getString("pay_appid");
        String mch_id = web_data.getString("mch_id");
        String key = web_data.getString("key");
        String body = web_data.getString("body");
        String isaccep = web_data.getString("isaccep");
        String openid = web_data.getString("openid");
        String out_trade_no = web_data.getString("out_trade_no");
        String total_fee = web_data.getString("total_fee");
        String spbill_create_ip = web_data.getString("spbill_create_ip");
        String notify_url = web_data.getString("notify_url");
        String trade_type = web_data.getString("trade_type");
        String randomstr = RandomStringUtils.randomAlphanumeric((int)32);
        Unifiedorder unifiedorder = new Unifiedorder();
        unifiedorder.setAppid(pay_appid);
        unifiedorder.setNonce_str(randomstr);
        unifiedorder.setBody(body);
        unifiedorder.setMch_id(mch_id);
        unifiedorder.setOut_trade_no(out_trade_no);
        unifiedorder.setTotal_fee(total_fee);
        unifiedorder.setSpbill_create_ip(spbill_create_ip);
        unifiedorder.setNotify_url(notify_url);
        unifiedorder.setTrade_type(trade_type);
        if ("Y".equals(isaccep)) {
            String sub_mch_id = web_data.getString("sub_mch_id");
            String sub_appid = web_data.getString("sub_appid");
            unifiedorder.setSub_appid(sub_appid);
            unifiedorder.setSub_mch_id(sub_mch_id);
            unifiedorder.setSub_openid(openid);
        } else {
            unifiedorder.setOpenid(openid);
        }
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        UnifiedorderResult result = PayMchAPI.payUnifiedorder((Unifiedorder)unifiedorder, (String)key);
        if (!result.isReturnSuccess()) {
            dataResponse.setCode("-1").setMsg(result.getReturn_msg()).setStatus(Status.FAILED);
            return dataResponse;
        }
        if (!result.isResultSuccess()) {
            dataResponse.setCode("-1").setMsg(result.getErr_code_des()).setStatus(Status.FAILED);
            return dataResponse;
        }
        String prepay_id = "prepay_id=" + result.getPrepay_id();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        randomstr = RandomStringUtils.randomAlphanumeric((int)32);
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("appId", pay_appid);
        mp.put("timeStamp", timestamp);
        mp.put("nonceStr", randomstr);
        mp.put("package", prepay_id);
        mp.put("signType", "MD5");
        log.debug("appId:" + pay_appid + ",timeStamp:" + timestamp + ",nonceStr:" + randomstr + ",prepay_id:" + prepay_id);
        log.debug("key:" + key);
        String paySign = SignatureUtil.generateSign(mp, (String)"MD5", (String)key);
        mp.put("paySign", paySign);
        log.debug("paySign:" + paySign);
        JSONObject response_data = new JSONObject(mp);
        dataResponse.setCode("0").setMsg("success").setStatus(Status.SUCCESS).setData(response_data);
        return dataResponse;
    }
}

