/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.mp.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.Set;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.wechat.mp.api.MessageAPI;
import kr.weitao.wechat.mp.bean.BaseResult;
import kr.weitao.wechat.mp.bean.message.ApiAddTemplateResult;
import kr.weitao.wechat.mp.bean.message.templatemessage.TemplateMessage;
import kr.weitao.wechat.mp.bean.message.templatemessage.TemplateMessageItem;
import kr.weitao.wechat.mp.bean.message.templatemessage.TemplateMessageResult;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PublicManager;
import kr.weitao.wechat.service.mp.MsgTemplateService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgTemplateServiceImp
implements MsgTemplateService {
    private static final Logger log = LogManager.getLogger(MsgTemplateServiceImp.class);
    @Autowired
    PublicManager publicManager;
    @Autowired
    GetWechatInfo getWechatInfo;

    public DataResponse getMsgTemplateInfo(DataRequest dataRequest) {
        return null;
    }

    public DataResponse delMsgTemplate(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String template_id = data_jo.getString("template_id");
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        log.debug("----->publicInfo:" + public_appid + "," + publicInfo.toString());
        this.publicManager.setPublic(publicInfo);
        BaseResult baseResult = MessageAPI.templateDel_private_template((String)this.publicManager.getAccessToken(), (String)template_id);
        if (!"0".equals(baseResult.getErrcode())) {
            dataResponse.setMsg(baseResult.getErrmsg()).setStatus(Status.FAILED);
            return dataResponse;
        }
        dataResponse.setStatus(Status.SUCCESS).setMsg("success").setData(JSON.parseObject((String)JSON.toJSONString((Object)baseResult)));
        return dataResponse;
    }

    public DataResponse getMsgTemplateCount(DataRequest dataRequest) {
        return null;
    }

    public DataResponse getBatchMsgTemplate(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String template_id_short = data_jo.getString("template_id_short");
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        log.debug("----->publicInfo:" + public_appid + "," + publicInfo.toString());
        this.publicManager.setPublic(publicInfo);
        ApiAddTemplateResult apiAddTemplateResult = MessageAPI.templateApi_add_template((String)this.publicManager.getAccessToken(), (String)template_id_short);
        if (!"0".equals(apiAddTemplateResult.getErrcode())) {
            dataResponse.setMsg(apiAddTemplateResult.getErrmsg()).setStatus(Status.FAILED);
            return dataResponse;
        }
        String template_id = apiAddTemplateResult.getTemplate_id();
        log.info("--template_id---" + template_id);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("template_id", (Object)template_id);
        dataResponse.setStatus(Status.SUCCESS).setMsg("success").setData(jsonObject);
        return dataResponse;
    }

    public DataResponse sendMsgTemplate(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String template_id = data_jo.getString("template_id");
        String open_id = data_jo.getString("open_id");
        String url = data_jo.getString("url");
        String data = data_jo.getJSONObject("data").toJSONString();
        log.info("--data---->>" + data);
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        this.publicManager.setPublic(publicInfo);
        TemplateMessage templateMessage = new TemplateMessage();
        templateMessage.setUrl(url);
        LinkedHashMap<String, TemplateMessageItem> templateMessageItems = new LinkedHashMap<String, TemplateMessageItem>();
        JSONObject data_object = null;
        try {
            data_object = JSON.parseObject((String)data);
        }
        catch (Exception e) {
            dataResponse.setStatus(Status.FAILED).setMsg(e.getMessage());
        }
        if (null != data_object) {
            Set set = data_object.keySet();
            for (int i = 0; i < set.size(); ++i) {
            }
            for (String key : set) {
                JSONObject jsonObject = data_object.getJSONObject(key);
                String value = jsonObject.getString("value");
                String color = jsonObject.getString("color");
                templateMessageItems.put(key, new TemplateMessageItem(value, color));
            }
            templateMessage.setData(templateMessageItems);
            templateMessage.setTemplate_id(template_id);
            templateMessage.setTouser(open_id);
            TemplateMessageResult templateMessageResult = MessageAPI.messageTemplateSend((String)this.publicManager.getAccessToken(), (TemplateMessage)templateMessage);
            log.info("-----templateMessageResult-----" + templateMessageResult.getErrcode());
            if (!"0".equals(templateMessageResult.getErrcode())) {
                dataResponse.setMsg(templateMessageResult.getErrmsg()).setStatus(Status.FAILED);
                return dataResponse;
            }
            log.info("-----------\u6210\u529f-----------------");
            dataResponse.setStatus(Status.SUCCESS).setMsg("success").setData(JSON.parseObject((String)JSON.toJSONString((Object)templateMessageResult)));
        }
        return dataResponse;
    }
}

