/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.mp.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import javax.imageio.ImageIO;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.common.util.qrcode.QRCodeUtil;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.oss.BlobClient;
import kr.weitao.wechat.mp.api.MiniProgramApi;
import kr.weitao.wechat.mp.api.WxaAPI;
import kr.weitao.wechat.mp.bean.wxa.Getwxacode;
import kr.weitao.wechat.mp.bean.wxa.Getwxacodeunlimit;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PublicManager;
import kr.weitao.wechat.open.schema.Wx_mini;
import kr.weitao.wechat.service.mp.MiniProgramService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Decoder;

@Service
public class MiniProgramServiceImpl
implements MiniProgramService {
    private static final Logger log = LogManager.getLogger(MiniProgramServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    PublicManager publicManager;
    @Autowired
    GetWechatInfo getWechatInfo;
    @Value(value="${oss.oss_domain}")
    String OSS_DOMAIN;
    @Autowired
    BlobClient blobClient;

    public DataResponse code2Session(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String mini_appid = data_obj.getString("mini_appid");
        String jscode = data_obj.getString("jscode");
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"mini_appid").is((Object)mini_appid));
        Wx_mini mini = (Wx_mini)this.mongoTemplate.findOne(query, Wx_mini.class);
        if (mini != null) {
            JSONObject object = MiniProgramApi.code2Session((String)mini_appid, (String)mini.getMini_secret(), (String)jscode);
            if (StringUtils.isNotNull((Object)object.getString("openid"))) {
                return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(object);
            }
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25").setData(object);
        }
        return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("appid\u4e0d\u5b58\u5728");
    }

    public DataResponse getAccessToken(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String mini_appid = data_obj.getString("mini_appid");
        String access_token = this.getAccessToken(mini_appid);
        if (StringUtils.isNull((Object)access_token)) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6token\u5931\u8d25");
        }
        JSONObject data = new JSONObject();
        data.put("access_token", (Object)access_token);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(data);
    }

    public DataResponse getWXACodeUnlimit(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String mini_appid = data_obj.getString("mini_appid");
        String scene_param = data_obj.getString("scene_param");
        String page = data_obj.getString("page");
        String is_hyaline = data_obj.getString("is_hyaline");
        String scene_id = scene_param;
        log.info("scene_id" + scene_id);
        String access_token = this.getAccessToken(mini_appid);
        if (StringUtils.isNull((Object)access_token)) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6token\u5931\u8d25");
        }
        Getwxacodeunlimit getwxacodeunlimit = new Getwxacodeunlimit();
        getwxacodeunlimit.setPage(page);
        getwxacodeunlimit.setScene(scene_id);
        getwxacodeunlimit.setAuto_color(Boolean.valueOf(true));
        if (StringUtils.isNotNull((Object)is_hyaline)) {
            getwxacodeunlimit.setIs_hyaline(Boolean.valueOf(false));
        } else {
            getwxacodeunlimit.setIs_hyaline(Boolean.valueOf(true));
        }
        log.info("--------" + getwxacodeunlimit);
        String qr_base64 = WxaAPI.getwxacodeunlimit((String)access_token, (Getwxacodeunlimit)getwxacodeunlimit);
        if (qr_base64 == null) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25");
        }
        JSONObject data = new JSONObject();
        data.put("qr_base64", (Object)qr_base64);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(data);
    }

    public DataResponse getWXACode(DataRequest request) {
        String access_token;
        DBObject object_scene;
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String mini_appid = data_obj.getString("mini_appid");
        JSONObject scene_param = data_obj.getJSONObject("scene_param");
        String page = data_obj.getString("page");
        String is_hyaline = data_obj.getString("is_hyaline");
        String scene_id = "";
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"mini_appid", (Object)mini_appid);
        query.put((Object)"page", (Object)page);
        for (String key : scene_param.keySet()) {
            query.put((Object)("scene_param." + key), scene_param.get((Object)key));
            scene_id = scene_id + key + "=" + scene_param.get((Object)key) + "&";
        }
        if (scene_id.endsWith("&")) {
            scene_id = scene_id.substring(0, scene_id.length() - 1);
        }
        if ((object_scene = this.mongoTemplate.getCollection("def_scene").findOne((DBObject)query)) != null) {
            if (StringUtils.isNotNull((Object)object_scene.get("scene_value"))) {
                JSONObject object = new JSONObject();
                object.put("qr_base64", object_scene.get("scene_value"));
                return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(object);
            }
        } else {
            ObjectId _id = new ObjectId();
            object_scene = new BasicDBObject();
            object_scene.put("_id", (Object)_id);
            object_scene.put("mini_appid", (Object)mini_appid);
            object_scene.put("page", (Object)page);
            object_scene.put("scene_param", (Object)scene_param);
            object_scene.put("created_date", (Object)TimeUtils.getCurrentTimeInString());
            this.mongoTemplate.getCollection("def_scene").insert(new DBObject[]{object_scene});
        }
        if (StringUtils.isNull((Object)(access_token = this.getAccessToken(mini_appid)))) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6token\u5931\u8d25");
        }
        Getwxacode getwxacode = new Getwxacode();
        getwxacode.setPath(page + "?" + scene_id);
        getwxacode.setAuto_color(Boolean.valueOf(true));
        if (StringUtils.isNotNull((Object)is_hyaline)) {
            getwxacode.setIs_hyaline(Boolean.valueOf(false));
        } else {
            getwxacode.setIs_hyaline(Boolean.valueOf(true));
        }
        String qr_base64 = WxaAPI.getwxacode((String)access_token, (Getwxacode)getwxacode);
        if (qr_base64 == null) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25");
        }
        BasicDBObject update = new BasicDBObject();
        update.put((Object)"scene_value", (Object)qr_base64);
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"$set", (Object)update);
        this.mongoTemplate.getCollection("def_scene").updateMulti((DBObject)query, (DBObject)basicDBObject);
        JSONObject data = new JSONObject();
        data.put("qr_base64", (Object)qr_base64);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(data);
    }

    public DataResponse getWXACodeImage(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String mini_appid = data_obj.getString("mini_appid");
        JSONObject scene_param = data_obj.getJSONObject("scene_param");
        String page = data_obj.getString("page");
        String scene_id = "";
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"mini_appid", (Object)mini_appid);
        query.put((Object)"page", (Object)page);
        for (String key : scene_param.keySet()) {
            query.put((Object)("scene_param." + key), scene_param.get((Object)key));
            scene_id = scene_id + key + "=" + scene_param.get((Object)key) + "&";
        }
        if (scene_id.endsWith("&")) {
            scene_id = scene_id.substring(0, scene_id.length() - 1);
        }
        DBObject object_scene = this.mongoTemplate.getCollection("def_scene").findOne((DBObject)query);
        BufferedImage bufferedImage = null;
        if (object_scene != null) {
            if (StringUtils.isNotNull((Object)object_scene.get("url"))) {
                JSONObject object = new JSONObject();
                object.put("url", object_scene.get("url"));
                return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(object);
            }
            if (StringUtils.isNotNull((Object)object_scene.get("scene_value"))) {
                String baseStr = object_scene.get("scene_value").toString();
                BASE64Decoder decoder = new BASE64Decoder();
                try {
                    byte[] b = decoder.decodeBuffer(baseStr);
                    for (int i = 0; i < b.length; ++i) {
                        if (b[i] >= 0) continue;
                        int n = i;
                        b[n] = (byte)(b[n] + 256);
                    }
                    bufferedImage = ImageIO.read(new ByteArrayInputStream(b));
                }
                catch (Exception b) {}
            }
        } else {
            ObjectId _id = new ObjectId();
            object_scene = new BasicDBObject();
            object_scene.put("_id", (Object)_id);
            object_scene.put("mini_appid", (Object)mini_appid);
            object_scene.put("page", (Object)page);
            object_scene.put("scene_param", (Object)scene_param);
            object_scene.put("created_date", (Object)TimeUtils.getCurrentTimeInString());
            this.mongoTemplate.getCollection("def_scene").insert(new DBObject[]{object_scene});
        }
        if (bufferedImage == null) {
            String access_token = this.getAccessToken(mini_appid);
            if (StringUtils.isNull((Object)access_token)) {
                return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6token\u5931\u8d25");
            }
            Getwxacode getwxacode = new Getwxacode();
            getwxacode.setPath(page + "?" + scene_id);
            getwxacode.setAuto_color(Boolean.valueOf(true));
            getwxacode.setIs_hyaline(Boolean.valueOf(true));
            bufferedImage = WxaAPI.getwxacodeImg((String)access_token, (Getwxacode)getwxacode);
        }
        if (bufferedImage == null) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25");
        }
        InputStream inputStream = QRCodeUtil.getImageStream(bufferedImage);
        String fileName = System.currentTimeMillis() + ".png";
        this.blobClient.passFileStrem("qrcode", mini_appid + "/" + fileName, inputStream);
        String url = "https://storage2tommy.blob.core.chinacloudapi.cn/qrcode/" + mini_appid + "/" + fileName;
        BasicDBObject update = new BasicDBObject();
        update.put((Object)"url", (Object)url);
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put((Object)"$set", (Object)update);
        this.mongoTemplate.getCollection("def_scene").updateMulti((DBObject)query, (DBObject)basicDBObject);
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(data);
    }

    public DataResponse decrypt(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String encrypted_data = data_obj.getString("encrypted_data");
        String iv = data_obj.getString("iv");
        String session_key = data_obj.getString("session_key");
        String decrypt = MiniProgramApi.decrypt((String)session_key, (String)iv, (String)encrypted_data);
        if (decrypt != null) {
            JSONObject data = new JSONObject();
            data.put("decrypt", (Object)decrypt);
            return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(data);
        }
        return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u4fe1\u606f\u89e3\u5bc6\u5931\u8d25");
    }

    public DataResponse getWXACodeUnlimitImage(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String mini_appid = data_obj.getString("mini_appid");
        String scene_param = data_obj.getString("scene_param");
        String page = data_obj.getString("page");
        String is_hyaline = data_obj.getString("is_hyaline");
        String scene_id = scene_param;
        log.info("data_obj---" + data_obj);
        String access_token = this.getAccessToken(mini_appid);
        if (StringUtils.isNull((Object)access_token)) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6token\u5931\u8d25");
        }
        Getwxacodeunlimit getwxacodeunlimit = new Getwxacodeunlimit();
        getwxacodeunlimit.setPage(page);
        getwxacodeunlimit.setScene(scene_id);
        if (StringUtils.isNotNull((Object)is_hyaline)) {
            getwxacodeunlimit.setIs_hyaline(Boolean.valueOf(false));
        } else {
            getwxacodeunlimit.setIs_hyaline(Boolean.valueOf(true));
        }
        getwxacodeunlimit.setAuto_color(Boolean.valueOf(true));
        log.info("--------" + JSON.toJSONString((Object)getwxacodeunlimit));
        BufferedImage bufferedImage = null;
        bufferedImage = WxaAPI.getwxacodeunlimitToImage((String)access_token, (Getwxacodeunlimit)getwxacodeunlimit);
        if (bufferedImage == null) {
            log.info("---null---");
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25");
        }
        log.info("---not null---");
        InputStream inputStream = QRCodeUtil.getImageStream((BufferedImage)bufferedImage);
        String fileName = System.currentTimeMillis() + ".png";
        log.info(fileName);
        this.blobClient.passFileStrem("qrcode", mini_appid + "/" + fileName, inputStream);
        String url = this.OSS_DOMAIN + "/" + "qrcode" + "/" + mini_appid + "/" + fileName;
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(data);
    }

    public DataResponse getliveinfo(DataRequest request) {
        JSONObject data = request.getData();
        String mini_appid = data.getString("mini_appid");
        if (!data.containsKey((Object)"page_size")) {
            data.put("limit", (Object)10);
        } else {
            data.put("limit", (Object)data.getInteger("page_size"));
        }
        if (!data.containsKey((Object)"page_num")) {
            data.put("start", (Object)0);
        } else {
            data.put("start", (Object)data.getInteger("page_num"));
        }
        data.remove((Object)"mini_appid");
        JSONObject object = MiniProgramApi.getliveinfo((String)this.getAccessToken(mini_appid), (JSONObject)data);
        return new DataResponse().setData(object).setStatus(Status.SUCCESS);
    }

    public DataResponse sendTemplateMessage(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String mini_appid = data_obj.getString("mini_appid");
        JSONObject data = data_obj.getJSONObject("data");
        String template_id = data_obj.getString("template_id");
        String openid = data_obj.getString("openid");
        String page = data_obj.getString("page");
        log.info("---\u53d1\u9001\u8ba2\u9605\u6d88\u606f-" + data_obj);
        String access_token = this.getAccessToken(mini_appid);
        if (StringUtils.isNull((Object)access_token)) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6token\u5931\u8d25");
        }
        JSONObject object = MiniProgramApi.sendSubscribeMessage((String)access_token, (String)template_id, (String)openid, (String)page, (JSONObject)data);
        BasicDBObject logSendTemplate = new BasicDBObject();
        logSendTemplate.put((Object)"mini_appid", (Object)mini_appid);
        logSendTemplate.put((Object)"template_id", (Object)template_id);
        logSendTemplate.put((Object)"openid", (Object)openid);
        logSendTemplate.put((Object)"page", (Object)page);
        logSendTemplate.put((Object)"data", (Object)data);
        logSendTemplate.put((Object)"created_date", (Object)TimeUtils.getCurrentTimeInString());
        logSendTemplate.put((Object)"errcode", (Object)object.getString("errcode"));
        logSendTemplate.put((Object)"errmsg", (Object)object.getString("errmsg"));
        this.mongoTemplate.getCollection("log_send_template").insert(new DBObject[]{logSendTemplate});
        if (object.getString("errcode").equals("0")) {
            return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(data);
        }
        return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg(object.getString("errmsg")).setData(object);
    }

    public String getAccessToken(String mini_appid) {
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"mini_appid").is((Object)mini_appid));
        Wx_mini mini = (Wx_mini)this.mongoTemplate.findOne(query, Wx_mini.class);
        if (mini != null) {
            try {
                long between_times = 0L;
                if (StringUtils.isNotNull((Object)mini.getExpires_in()) && mini.getExpires_in() > 0L) {
                    long expires_in = mini.getExpires_in();
                    Date date = TimeUtils.DATETIME_FORMAT_DATE.parse(mini.getRefresh_token_date());
                    between_times = System.currentTimeMillis() - date.getTime() - expires_in;
                }
                if (between_times == 0L || between_times > 300000L) {
                    JSONObject access_token_obj = MiniProgramApi.getAccessToken((String)mini_appid, (String)mini.getMini_secret());
                    if (StringUtils.isNotNull((Object)access_token_obj.getString("access_token"))) {
                        Update update = new Update();
                        update.set("access_token", (Object)access_token_obj.getString("access_token"));
                        update.set("expires_in", (Object)access_token_obj.getString("expires_in"));
                        update.set("refresh_token_date", (Object)TimeUtils.getCurrentTimeInString());
                        this.mongoTemplate.upsert(query, update, Wx_mini.class);
                        return access_token_obj.getString("access_token");
                    }
                    return null;
                }
                JSONObject data = new JSONObject();
                data.put("access_token", (Object)mini.getAccess_token());
                return mini.getAccess_token();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }
}

