/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.mp.impl;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.wechat.mp.api.MediaAPI;
import kr.weitao.wechat.mp.api.MessageAPI;
import kr.weitao.wechat.mp.bean.BaseResult;
import kr.weitao.wechat.mp.bean.media.Media;
import kr.weitao.wechat.mp.bean.media.MediaType;
import kr.weitao.wechat.mp.bean.message.MessageSendResult;
import kr.weitao.wechat.mp.bean.message.massmessage.Filter;
import kr.weitao.wechat.mp.bean.message.massmessage.MassImageMessage;
import kr.weitao.wechat.mp.bean.message.massmessage.MassMPnewsMessage;
import kr.weitao.wechat.mp.bean.message.massmessage.MassMessage;
import kr.weitao.wechat.mp.bean.message.massmessage.MassTextMessage;
import kr.weitao.wechat.mp.util.JsonUtil;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PublicManager;
import kr.weitao.wechat.service.mp.MessageService;
import kr.weitao.wechat.service.mp.MiniProgramService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LogManager.getLogger(MessageServiceImpl.class);
    @Autowired
    PublicManager publicManager;
    @Autowired
    GetWechatInfo getWechatInfo;
    @Autowired
    MiniProgramService miniProgramService;

    public DataResponse sendMessage(DataRequest dataRequest) {
        DataResponse dataResponse;
        String imageUrl;
        JSONObject data_jo = dataRequest.getData();
        log.info("--\u53d1\u9001\u6d88\u606fvip--" + data_jo);
        String public_appid = data_jo.getString("public_appid");
        String message_data = data_jo.getString("message_data");
        DataRequest dataRequest1 = new DataRequest();
        JSONObject data = new JSONObject();
        data.put("public_appid", (Object)public_appid);
        JSONObject message = JSONObject.parseObject((String)message_data);
        if ("image".equals(message.getString("msgtype"))) {
            JSONObject image = message.getJSONObject("image");
            imageUrl = image.getString("image_url");
            data.put("url", (Object)imageUrl);
            dataRequest1.setData(data);
            dataResponse = this.uploadTempMedia(dataRequest1);
            if (dataResponse.getStatus().equals((Object)Status.SUCCESS)) {
                image.put("media_id", (Object)dataResponse.getData().getString("media_id"));
            }
            message.put("image", (Object)image);
            message_data = message.toJSONString();
        } else if ("miniprogrampage".equals(message.getString("msgtype"))) {
            JSONObject miniprogrampage = message.getJSONObject("miniprogrampage");
            imageUrl = miniprogrampage.getString("image_url");
            data.put("url", (Object)imageUrl);
            dataRequest1.setData(data);
            dataResponse = this.uploadTempMedia(dataRequest1);
            if (dataResponse.getStatus().equals((Object)Status.SUCCESS)) {
                miniprogrampage.put("thumb_media_id", (Object)dataResponse.getData().getString("media_id"));
            }
            message.put("miniprogrampage", (Object)miniprogrampage);
            message_data = message.toJSONString();
        }
        String accessToken = this.miniProgramService.getAccessToken(public_appid);
        BaseResult baseResult = MessageAPI.messageCustomSend((String)accessToken, (String)message_data);
        dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        if (!baseResult.isSuccess()) {
            dataResponse.setMsg(baseResult.getErrmsg()).setStatus(Status.FAILED);
            return dataResponse;
        }
        dataResponse.setStatus(Status.SUCCESS).setMsg("success");
        return dataResponse;
    }

    public DataResponse mass(DataRequest dataRequest) {
        String media_id;
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String msg_type = data_jo.getString("msg_type");
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        this.publicManager.setPublic(publicInfo);
        MassTextMessage massMessage = null;
        if ("text".equals(msg_type)) {
            String content = data_jo.getString("content");
            massMessage = new MassTextMessage(content);
        } else if ("image".equals(msg_type)) {
            media_id = data_jo.getString("media_id");
            massMessage = new MassImageMessage(media_id);
        } else if ("news".equals(msg_type)) {
            media_id = data_jo.getString("media_id");
            massMessage = new MassMPnewsMessage(media_id);
        }
        if (massMessage == null) {
            dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u6d88\u606f\u7c7b\u578b\u4e0d\u5b58\u5728");
            return dataResponse;
        }
        MessageSendResult sendResult = null;
        if (StringUtils.isNotNull((Object)data_jo.get((Object)"openids"))) {
            HashSet openid_set = (HashSet)JsonUtil.parseObject((String)JsonUtil.toJSONString((Object)data_jo.get((Object)"openids")), HashSet.class);
            if (openid_set.size() < 2 || openid_set.size() > 10000) {
                dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u5fae\u4fe1\u7c89\u4e1d\u6700\u5c112\u4e2a\uff0c\u6700\u591a10000\u4e2a");
                return dataResponse;
            }
            massMessage.setTouser((Set)openid_set);
            sendResult = MessageAPI.messageMassSend((String)this.publicManager.getAccessToken(), (MassMessage)massMessage);
        } else if (StringUtils.isNotNull((Object)data_jo.get((Object)"is_to_all")) && data_jo.getBoolean("is_to_all").booleanValue()) {
            Filter filter = new Filter(true, null);
            massMessage.setFilter(filter);
            sendResult = MessageAPI.messageMassSendall((String)this.publicManager.getAccessToken(), (MassMessage)massMessage);
        } else {
            dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u5fae\u4fe1\u7c89\u4e1d\u4e0d\u53ef\u4e3a\u7a7a");
            return dataResponse;
        }
        if (!sendResult.isSuccess()) {
            dataResponse.setCode(sendResult.getErrcode()).setStatus(Status.FAILED).setMsg(sendResult.getErrmsg());
            return dataResponse;
        }
        JSONObject response_data = new JSONObject();
        response_data.put("msg_id", (Object)sendResult.getMsg_id());
        response_data.put("msg_data_id", (Object)sendResult.getMsg_data_id());
        dataResponse.setCode("0").setStatus(Status.SUCCESS).setMsg("success").setData(response_data);
        return dataResponse;
    }

    public DataResponse getMass(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String msg_id = data_jo.getString("msg_id");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        this.publicManager.setPublic(publicInfo);
        MessageSendResult sendResult = MessageAPI.messageMassGet((String)this.publicManager.getAccessToken(), (String)msg_id);
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        if (!sendResult.isSuccess()) {
            dataResponse.setCode(sendResult.getErrcode()).setStatus(Status.FAILED).setMsg(sendResult.getErrmsg());
            return dataResponse;
        }
        JSONObject response_data = new JSONObject();
        response_data.put("msg_status", (Object)sendResult.getMsg_status());
        dataResponse.setCode("0").setStatus(Status.SUCCESS).setMsg("success").setData(response_data);
        return dataResponse;
    }

    public DataResponse delMass(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String msg_id = data_jo.getString("msg_id");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        this.publicManager.setPublic(publicInfo);
        BaseResult baseResult = MessageAPI.messageMassDelete((String)this.publicManager.getAccessToken(), (String)msg_id);
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        if (!baseResult.isSuccess()) {
            dataResponse.setCode(baseResult.getErrcode()).setStatus(Status.FAILED).setMsg(baseResult.getErrmsg());
            return dataResponse;
        }
        dataResponse.setCode("0").setStatus(Status.SUCCESS).setMsg("success");
        return dataResponse;
    }

    public DataResponse uploadTempMedia(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String oss_url = data_jo.getString("url");
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        URL url = null;
        InputStream inputStream = null;
        try {
            url = new URL(oss_url);
            inputStream = url.openStream();
        }
        catch (Exception e) {
            log.error("uploadTempMedia error:" + e.getMessage());
            dataResponse.setStatus(Status.FAILED).setMsg(e.getMessage());
            return dataResponse;
        }
        String accessToken = this.miniProgramService.getAccessToken(public_appid);
        Media uploadResult = MediaAPI.mediaUpload((String)accessToken, (MediaType)MediaType.image, (InputStream)inputStream);
        JSONObject return_jo = new JSONObject();
        return_jo.put("media_id", (Object)uploadResult.getMedia_id());
        dataResponse.setStatus(Status.SUCCESS).setMsg("success").setData(return_jo);
        return dataResponse;
    }
}

