/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.mp.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kr.weitao.wechat.mp.api.MenuAPI;
import kr.weitao.wechat.mp.bean.BaseResult;
import kr.weitao.wechat.mp.bean.menu.Menu;
import kr.weitao.wechat.mp.bean.menu.MenuButtons;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PublicManager;
import kr.weitao.wechat.service.mp.MenuService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImpl
implements MenuService {
    private static final Logger log = LogManager.getLogger(MenuServiceImpl.class);
    @Autowired
    PublicManager publicManager;
    @Autowired
    GetWechatInfo getWechatInfo;

    public String publish(MenuButtons menu, String publicAppid) {
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(publicAppid);
        log.debug("----->publicInfo:" + publicAppid + "," + publicInfo.toString());
        this.publicManager.setPublic(publicInfo);
        BaseResult br = null;
        try {
            br = MenuAPI.menuCreate((String)this.publicManager.getAccessToken(), (MenuButtons)menu);
            log.debug("------br:" + br.isSuccess() + br.getErrcode());
        }
        catch (Exception e) {
            log.error("---publish error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        return JSON.toJSONString((Object)br);
    }

    public String getMenu(String publicAppid) {
        JSONObject publicjo = this.getWechatInfo.getPublicInfo(publicAppid);
        this.publicManager.setPublic(publicjo);
        Menu m = MenuAPI.menuGet((String)this.publicManager.getAccessToken());
        return JSON.toJSONString((Object)m);
    }
}

