/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.mp.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.wechat.mp.api.MaterialAPI;
import kr.weitao.wechat.mp.api.MediaAPI;
import kr.weitao.wechat.mp.bean.BaseResult;
import kr.weitao.wechat.mp.bean.material.Description;
import kr.weitao.wechat.mp.bean.material.MaterialBatchgetResult;
import kr.weitao.wechat.mp.bean.material.MaterialGetResult;
import kr.weitao.wechat.mp.bean.material.MaterialcountResult;
import kr.weitao.wechat.mp.bean.media.Media;
import kr.weitao.wechat.mp.bean.media.MediaType;
import kr.weitao.wechat.mp.bean.media.UploadimgResult;
import kr.weitao.wechat.mp.bean.message.Article;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PublicManager;
import kr.weitao.wechat.service.mp.MaterialService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class MaterialServiceImpl
implements MaterialService {
    private static final Logger log = LogManager.getLogger(MaterialServiceImpl.class);
    @Autowired
    PublicManager publicManager;
    @Autowired
    GetWechatInfo getWechatInfo;

    public DataResponse addImage(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        JSONObject content = data_jo.getJSONObject("content");
        String oss_url = content.getString("url");
        String title = content.getString("title");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        log.debug("----->publicInfo:" + public_appid + "," + publicInfo.toString());
        log.debug("----->data_jo:" + data_jo.toString());
        this.publicManager.setPublic(publicInfo);
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        HttpURLConnection conn = null;
        URL url = null;
        try {
            url = new URL(oss_url);
            conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            int picture_size = conn.getContentLength();
            if (picture_size > 0x200000) {
                conn.disconnect();
                dataResponse.setStatus(Status.FAILED).setMsg("\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa2M,\u8bf7\u68c0\u67e5\u56fe\u7247\u5927\u5c0f");
                return dataResponse;
            }
        }
        catch (Exception e) {
            if (conn != null) {
                conn.disconnect();
            }
            log.error("\u6587\u4ef6size error:" + e.getMessage());
            dataResponse.setStatus(Status.FAILED).setMsg(e.getMessage());
            return dataResponse;
        }
        Description description = new Description();
        log.debug("------->title1:" + title);
        description.setTitle(title);
        description.setIntroduction(title);
        log.debug("------->title2:" + description.getTitle());
        URI uri = URI.create(oss_url);
        Media media = MaterialAPI.add_material((String)this.publicManager.getAccessToken(), (MediaType)MediaType.image, (URI)uri, null);
        if (!"0".equals(media.getErrcode())) {
            dataResponse.setMsg(media.getErrmsg()).setStatus(Status.FAILED);
            return dataResponse;
        }
        String media_id = media.getMedia_id();
        String wx_url = media.getUrl();
        JSONObject return_jo = new JSONObject();
        return_jo.put("media_id", (Object)media_id);
        return_jo.put("url", (Object)wx_url);
        dataResponse.setStatus(Status.SUCCESS).setMsg("success").setData(return_jo);
        return dataResponse;
    }

    public DataResponse modNews(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        JSONArray contents = data_jo.getJSONArray("content");
        String media_id = data_jo.getString("media_id");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        this.publicManager.setPublic(publicInfo);
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        for (int index = 0; index < contents.size(); ++index) {
            JSONObject content_jo = contents.getJSONObject(index);
            Article article = (Article)JSON.parseObject((String)content_jo.toString(), Article.class);
            BaseResult baseResult = MaterialAPI.update_news((String)this.publicManager.getAccessToken(), (String)media_id, (int)index, (Article)article);
            if (baseResult.isSuccess()) continue;
            dataResponse.setStatus(Status.FAILED).setMsg(baseResult.getErrmsg());
            return dataResponse;
        }
        dataResponse.setStatus(Status.SUCCESS).setMsg("success");
        return dataResponse;
    }

    public DataResponse addNews(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        JSONArray contents = data_jo.getJSONArray("content");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        this.publicManager.setPublic(publicInfo);
        ArrayList<Object> list_news = new ArrayList<Object>();
        for (int k = 0; k < contents.size(); ++k) {
            JSONObject content_jo = contents.getJSONObject(k);
            list_news.add(JSON.parseObject((String)content_jo.toString(), Article.class));
        }
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        Media media = MaterialAPI.add_news((String)this.publicManager.getAccessToken(), list_news);
        if (!"0".equals(media.getErrcode())) {
            dataResponse.setMsg(media.getErrmsg()).setStatus(Status.FAILED);
            return dataResponse;
        }
        JSONObject return_jo = new JSONObject();
        return_jo.put("media_id", (Object)media.getMedia_id());
        dataResponse.setStatus(Status.SUCCESS).setMsg("success").setData(return_jo);
        return dataResponse;
    }

    public DataResponse getMaterialInfo(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String media_id = data_jo.getString("media_id");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        this.publicManager.setPublic(publicInfo);
        MaterialGetResult materialGetResult = MaterialAPI.get_material((String)this.publicManager.getAccessToken(), (String)media_id);
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        if (!"0".equals(materialGetResult.getErrcode())) {
            dataResponse.setMsg(materialGetResult.getErrmsg()).setStatus(Status.FAILED);
            return dataResponse;
        }
        dataResponse.setStatus(Status.SUCCESS).setMsg("success").setData(JSON.parseObject((String)JSON.toJSONString((Object)materialGetResult)));
        return dataResponse;
    }

    public DataResponse delMaterial(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String media_id = data_jo.getString("media_id");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        log.debug("----->getMaterialInfo:" + data_jo.toString());
        this.publicManager.setPublic(publicInfo);
        BaseResult baseResult = MaterialAPI.del_material((String)this.publicManager.getAccessToken(), (String)media_id);
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        if (!baseResult.isSuccess()) {
            dataResponse.setMsg(baseResult.getErrmsg()).setStatus(Status.FAILED);
            return dataResponse;
        }
        dataResponse.setStatus(Status.SUCCESS).setMsg("success");
        return dataResponse;
    }

    public DataResponse getMaterialCount(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String material_type = data_jo.getString("material_type");
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        boolean is_image = "image".equals(material_type);
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        log.debug("----->publicInfo:" + public_appid + "," + publicInfo.toString());
        this.publicManager.setPublic(publicInfo);
        MaterialcountResult materialcountResult = MaterialAPI.get_materialcount((String)this.publicManager.getAccessToken());
        if (!"0".equals(materialcountResult.getErrcode())) {
            dataResponse.setMsg(materialcountResult.getErrmsg()).setStatus(Status.FAILED);
            return dataResponse;
        }
        int count = is_image ? materialcountResult.getImage_count() : materialcountResult.getNews_count();
        if (count < 1) {
            dataResponse.setMsg("\u65e0\u8bb0\u5f55\u6570\u636e").setStatus(Status.FAILED);
            return dataResponse;
        }
        JSONObject response_jo = new JSONObject();
        response_jo.put("count", (Object)count);
        dataResponse.setStatus(Status.SUCCESS).setMsg("success").setData(response_jo);
        return dataResponse;
    }

    public DataResponse getBatchMaterial(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String material_type = data_jo.getString("material_type");
        int offset = data_jo.getInteger("offset");
        int count = data_jo.getInteger("count");
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        log.debug("----->publicInfo:" + public_appid + "," + publicInfo.toString());
        this.publicManager.setPublic(publicInfo);
        MaterialBatchgetResult batchgetResult = MaterialAPI.batchget_material((String)this.publicManager.getAccessToken(), (String)material_type, (int)offset, (int)count);
        if (!"0".equals(batchgetResult.getErrcode())) {
            dataResponse.setMsg(batchgetResult.getErrmsg()).setStatus(Status.FAILED);
            return dataResponse;
        }
        dataResponse.setStatus(Status.SUCCESS).setMsg("success").setData(JSON.parseObject((String)JSON.toJSONString((Object)batchgetResult)));
        return dataResponse;
    }

    public DataResponse addNewsImage(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String oss_url = data_jo.getString("url");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        log.debug("----->publicInfo:" + public_appid + "," + publicInfo.toString());
        log.debug("----->data_jo:" + data_jo.toString());
        this.publicManager.setPublic(publicInfo);
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        HttpURLConnection conn = null;
        URL url = null;
        try {
            url = new URL(oss_url);
            conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            int picture_size = conn.getContentLength();
            if (picture_size > 0x100000) {
                conn.disconnect();
                dataResponse.setStatus(Status.FAILED).setMsg("\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa1M,\u8bf7\u68c0\u67e5\u56fe\u7247\u5927\u5c0f");
                return dataResponse;
            }
        }
        catch (Exception e) {
            if (conn != null) {
                conn.disconnect();
            }
            log.error("\u6587\u4ef6size error:" + e.getMessage());
            dataResponse.setStatus(Status.FAILED).setMsg(e.getMessage());
            return dataResponse;
        }
        URI uri = URI.create(oss_url);
        UploadimgResult uploadimgResult = MediaAPI.mediaUploadimg((String)this.publicManager.getAccessToken(), (URI)uri);
        JSONObject return_jo = new JSONObject();
        return_jo.put("url", (Object)uploadimgResult.getUrl());
        dataResponse.setStatus(Status.SUCCESS).setMsg("success").setData(return_jo);
        return dataResponse;
    }
}

