/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.mp.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.wechat.mp.api.MallAPI;
import kr.weitao.wechat.mp.bean.BaseResult;
import kr.weitao.wechat.mp.bean.mall.Brand;
import kr.weitao.wechat.mp.bean.mall.Express;
import kr.weitao.wechat.mp.bean.mall.ExpressPackage;
import kr.weitao.wechat.mp.bean.mall.Order;
import kr.weitao.wechat.mp.bean.mall.OrderExtInfo;
import kr.weitao.wechat.mp.bean.mall.OrderItem;
import kr.weitao.wechat.mp.bean.mall.Page;
import kr.weitao.wechat.mp.bean.mall.Product;
import kr.weitao.wechat.mp.bean.mall.ProductAttr;
import kr.weitao.wechat.mp.bean.mall.Sku;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PublicManager;
import kr.weitao.wechat.service.mp.MallService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallServiceImpl
implements MallService {
    @Autowired
    PublicManager publicManager;
    @Autowired
    GetWechatInfo getWechatInfo;

    public DataResponse importProduct(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String mini_appid = data_obj.getString("mini_appid");
        JSONArray products = data_obj.getJSONArray("products");
        ArrayList<Product> product_list = new ArrayList<Product>();
        for (int i = 0; i < products.size(); ++i) {
            JSONObject product = products.getJSONObject(i);
            String product_id = product.getString("product_id");
            JSONArray image_url = product.getJSONArray("product_image_url");
            ArrayList<String> image_list = new ArrayList<String>();
            for (int j = 0; j < image_url.size(); ++j) {
                image_list.add(image_url.getJSONObject(j).getString("image_url"));
            }
            ArrayList<String> category_list = new ArrayList<String>();
            category_list.add(product.getString("class_name"));
            String status = product.getString("status");
            JSONArray skus = product.getJSONArray("skus");
            ArrayList<Sku> sku_list = new ArrayList<Sku>();
            for (int j = 0; j < skus.size(); ++j) {
                JSONObject sku = skus.getJSONObject(j);
                int stock = sku.getInteger("stock");
                if (stock <= 0) {
                    status = "3";
                }
                ArrayList<ProductAttr> sku_attr_list = new ArrayList<ProductAttr>();
                JSONArray spec_array = sku.getJSONArray("spec_array");
                for (int k = 0; k < spec_array.size(); ++k) {
                    ProductAttr attr = new ProductAttr();
                    attr.setName(spec_array.getJSONObject(k).getString("spec_name"));
                    attr.setValue(spec_array.getJSONObject(k).getString("spec_item_name"));
                    sku_attr_list.add(attr);
                }
                Sku s = new Sku();
                s.setSku_id(sku.getString("code"));
                s.setPrice(sku.getString("price"));
                s.setStatus(status);
                s.setSku_attr_list(sku_attr_list);
                sku_list.add(s);
            }
            Product p = new Product();
            p.setItem_code(product_id);
            p.setTitle(product.getString("product_name"));
            p.setImage_list(image_list);
            p.setDesc(product.getString("product_description"));
            p.setSrc_wxapp_path("pages/product/detail?product_id=" + product_id);
            p.setCategory_list(category_list);
            p.setSku_list(sku_list);
            product_list.add(p);
        }
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(mini_appid);
        this.publicManager.setPublic(publicInfo);
        String access_token = this.publicManager.getAccessToken();
        BaseResult result = MallAPI.importProduct((String)access_token, product_list);
        if (result.isSuccess()) {
            return dataResponse.setStatus(Status.SUCCESS).setCode("0");
        }
        return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg(result.getErrcode() + ":" + result.getErrmsg());
    }

    public DataResponse importOrder(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String mini_appid = data_obj.getString("mini_appid");
        String is_history = data_obj.getString("is_history");
        JSONArray orders = data_obj.getJSONArray("orders");
        ArrayList<Order> order_list = new ArrayList<Order>();
        try {
            for (int i = 0; i < orders.size(); ++i) {
                JSONObject order = orders.getJSONObject(i);
                String order_no = order.getString("order_no");
                String order_id = order.getString("order_id");
                String created_date = order.getString("created_date");
                String pay_date = order.getString("pay_date");
                double amount_pay = order.getDouble("order_amount_pay");
                String transaction_id = order.getString("transaction_id");
                String pay_status = order.getString("pay_status");
                String order_status = order.getString("order_status");
                int status = 0;
                if (pay_status.equals("1")) {
                    status = 3;
                    if (order_status.equals("1")) {
                        status = 4;
                    }
                } else if (pay_status.equals("3")) {
                    status = 5;
                }
                double discount_amount = order.getDouble("discount_amount");
                String open_id = order.getJSONObject("order_vip").getString("open_id");
                JSONArray productList = order.getJSONArray("productList");
                ArrayList<OrderItem> sku_list = new ArrayList<OrderItem>();
                for (int j = 0; j < productList.size(); ++j) {
                    JSONObject sku = productList.getJSONObject(j);
                    String product_id = sku.getString("product_id");
                    double product_amount = sku.getDouble("product_amount") * 100.0;
                    double product_price = sku.getDouble("product_price") * 100.0;
                    int product_num = sku.getInteger("product_num");
                    int unit_price = (int)Math.round(product_amount / (double)product_num);
                    OrderItem s = new OrderItem();
                    s.setItem_code(product_id);
                    s.setSku_id(sku.getString("sku_id"));
                    s.setAmount(product_num);
                    s.setTotal_fee((int)product_amount);
                    JSONArray image_url = sku.getJSONArray("product_image_url");
                    String thumb_url = "";
                    int k = 0;
                    if (k < image_url.size()) {
                        thumb_url = image_url.getJSONObject(k).getString("image_url");
                    }
                    s.setThumb_url(thumb_url);
                    s.setTitle(sku.getString("product_name"));
                    s.setUnit_price(unit_price);
                    s.setOriginal_price((int)product_price);
                    ArrayList<String> category_list = new ArrayList<String>();
                    category_list.add(sku.getString("class_name"));
                    s.setCategory_list(category_list);
                    Page item_detail_page = new Page();
                    item_detail_page.setPath("pages/product/detail?product_id=" + product_id);
                    s.setItem_detail_page(item_detail_page);
                    sku_list.add(s);
                }
                JSONObject product_info = new JSONObject();
                product_info.put("item_list", sku_list);
                OrderExtInfo ext_info = new OrderExtInfo();
                ext_info.setProduct_info(product_info);
                double order_freight = order.getDouble("order_freight");
                JSONArray logistics_list = order.getJSONArray("logisticsList");
                Express express = this.disposeExpressInfo(logistics_list, order_freight);
                ext_info.setExpress_info(express);
                JSONObject promotion_info = new JSONObject();
                promotion_info.put("discount_fee", (Object)((int)discount_amount * 100));
                ext_info.setPromotion_info(promotion_info);
                Brand brand = new Brand();
                Page contact_detail_page = new Page();
                contact_detail_page.setKf_type(1);
                brand.setContact_detail_page(contact_detail_page);
                ext_info.setBrand_info(brand);
                ext_info.setPayment_method(1);
                ext_info.setUser_open_id(open_id);
                Page order_detail_page = new Page();
                order_detail_page.setPath("/pages/order_details?id=" + order_id);
                ext_info.setOrder_detail_page(order_detail_page);
                Order o = new Order();
                o.setOrder_id(order_no);
                o.setCreate_time(TimeUtils.DATETIME_FORMAT_DATE.parse(created_date).getTime());
                o.setPay_finish_time(TimeUtils.DATETIME_FORMAT_DATE.parse(pay_date).getTime());
                o.setFee((int)amount_pay * 100);
                o.setTrans_id(transaction_id);
                o.setStatus(status);
                o.setExt_info(ext_info);
                order_list.add(o);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(mini_appid);
        this.publicManager.setPublic(publicInfo);
        String access_token = this.publicManager.getAccessToken();
        BaseResult result = MallAPI.addOrder((String)access_token, (String)is_history, order_list);
        if (result.isSuccess()) {
            return dataResponse.setStatus(Status.SUCCESS).setCode("0");
        }
        return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg(result.getErrcode() + ":" + result.getErrmsg());
    }

    public DataResponse updateOrder(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String mini_appid = data_obj.getString("mini_appid");
        String is_history = data_obj.getString("is_history");
        JSONArray orders = data_obj.getJSONArray("orders");
        ArrayList<Order> order_list = new ArrayList<Order>();
        try {
            for (int i = 0; i < orders.size(); ++i) {
                JSONObject order = orders.getJSONObject(i);
                String order_no = order.getString("order_no");
                String order_id = order.getString("order_id");
                String pay_status = order.getString("pay_status");
                String order_status = order.getString("order_status");
                int status = 0;
                if (pay_status.equals("1")) {
                    status = 3;
                    if (order_status.equals("1")) {
                        status = 4;
                    }
                } else if (pay_status.equals("3")) {
                    status = 5;
                }
                OrderExtInfo ext_info = new OrderExtInfo();
                double order_freight = order.getDouble("order_freight");
                JSONArray logistics_list = order.getJSONArray("logisticsList");
                Express express = this.disposeExpressInfo(logistics_list, order_freight);
                ext_info.setExpress_info(express);
                String open_id = order.getJSONObject("order_vip").getString("open_id");
                ext_info.setUser_open_id(open_id);
                Page order_detail_page = new Page();
                order_detail_page.setPath("/pages/order_details?id=" + order_id);
                ext_info.setOrder_detail_page(order_detail_page);
                Order o = new Order();
                o.setOrder_id(order_no);
                o.setStatus(status);
                o.setExt_info(ext_info);
                order_list.add(o);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(mini_appid);
        this.publicManager.setPublic(publicInfo);
        String access_token = this.publicManager.getAccessToken();
        BaseResult result = MallAPI.updateOrder((String)access_token, (String)is_history, order_list);
        if (result.isSuccess()) {
            return dataResponse.setStatus(Status.SUCCESS).setCode("0");
        }
        return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg(result.getErrcode() + ":" + result.getErrmsg());
    }

    public DataResponse deleteOrder(DataRequest request) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data_obj = request.getData();
        String mini_appid = data_obj.getString("mini_appid");
        String order_no = data_obj.getString("order_no");
        String open_id = data_obj.getString("open_id");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(mini_appid);
        this.publicManager.setPublic(publicInfo);
        String access_token = this.publicManager.getAccessToken();
        BaseResult result = MallAPI.deleteOrder((String)access_token, (String)open_id, (String)order_no);
        if (result.isSuccess()) {
            return dataResponse.setStatus(Status.SUCCESS).setCode("0");
        }
        return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg(result.getErrcode() + ":" + result.getErrmsg());
    }

    private Express disposeExpressInfo(JSONArray logisticsList, double order_freight) throws Exception {
        Express express = new Express();
        express.setPrice((int)order_freight * 100);
        ArrayList<ExpressPackage> express_package_info_list = new ArrayList<ExpressPackage>();
        for (int j = 0; j < logisticsList.size(); ++j) {
            JSONObject logistic = logisticsList.getJSONObject(j);
            String logistics_time = logistic.getString("logistics_time");
            JSONArray express_goods_info_list = new JSONArray();
            JSONArray product_list = logistic.getJSONArray("product_list");
            for (int k = 0; k < product_list.size(); ++k) {
                JSONObject express_goods_info = new JSONObject();
                express_goods_info.put("item_code", (Object)product_list.getJSONObject(k).getString("product_id"));
                String sku_id = product_list.getJSONObject(k).getString("product_id");
                if (StringUtils.isNotNull((Object)product_list.getJSONObject(k).getString("sku_id"))) {
                    sku_id = product_list.getJSONObject(k).getString("sku_id");
                }
                express_goods_info.put("sku_id", (Object)sku_id);
                express_goods_info_list.add((Object)express_goods_info);
            }
            ExpressPackage e_package = new ExpressPackage();
            e_package.setExpress_company_id(logistic.getInteger("wx_company_id").intValue());
            e_package.setExpress_company_name(logistic.getString("wx_company_name"));
            e_package.setExpress_code(logistic.getString("logistics_code"));
            e_package.setShip_time(TimeUtils.DATETIME_FORMAT_DATE.parse(logistics_time).getTime());
            e_package.setExpress_goods_info_list(express_goods_info_list);
            express_package_info_list.add(e_package);
        }
        express.setExpress_package_info_list(express_package_info_list);
        return express;
    }
}

