/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.mp.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.wechat.mp.api.SnsAPI;
import kr.weitao.wechat.mp.util.SignatureUtil;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PublicManager;
import kr.weitao.wechat.service.mp.JssdkService;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JssdkServiceImpl
implements JssdkService {
    private static final Logger log = LogManager.getLogger(JssdkServiceImpl.class);
    @Autowired
    PublicManager publicManager;
    @Autowired
    GetWechatInfo getWechatInfo;
    @Value(value="${component.appid}")
    String component_appid;

    public DataResponse get(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String url = data_jo.getString("url");
        String state = data_jo.getString("state");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        this.publicManager.setPublic(publicInfo);
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String randomstr = RandomStringUtils.randomAlphanumeric((int)16);
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("timestamp", timestamp);
        mp.put("noncestr", randomstr);
        mp.put("jsapi_ticket", this.publicManager.getJssdkAccessToken());
        mp.put("url", url);
        SignatureUtil su = new SignatureUtil();
        Map middlemp = su.doSort(mp, false);
        Object value = null;
        StringBuffer sb = new StringBuffer();
        for (Object key : middlemp.keySet()) {
            value = mp.get(key);
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key + "=" + value);
        }
        log.debug("signstring->" + sb.toString());
        String sign = DigestUtils.sha1Hex((String)sb.toString());
        log.debug("sign->" + sign);
        String auth_url = null;
        JSONObject signjo = new JSONObject();
        if (StringUtils.isNotNull((Object)url)) {
            auth_url = SnsAPI.connectOauth2Authorize((String)public_appid, (String)url, (boolean)true, (String)state, (String)this.component_appid);
        }
        try {
            signjo.put("auth_url", auth_url);
            signjo.put("public_appid", (Object)public_appid);
            signjo.put("signature", (Object)sign);
            signjo.put("timestamp", (Object)timestamp);
            signjo.put("noncestr", (Object)randomstr);
            log.info("signjo;" + signjo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId()).setCode("0").setMsg("success").setData(signjo);
        return dataResponse;
    }
}

