/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.mp.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.wechat.mp.api.SnsAPI;
import kr.weitao.wechat.mp.api.UserAPI;
import kr.weitao.wechat.mp.bean.sns.SnsToken;
import kr.weitao.wechat.mp.bean.user.FollowResult;
import kr.weitao.wechat.mp.bean.user.User;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PlatformManager;
import kr.weitao.wechat.open.PublicManager;
import kr.weitao.wechat.service.mp.FansService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FansServiceImpl
implements FansService {
    private static final Logger log = LogManager.getLogger(FansServiceImpl.class);
    @Autowired
    PublicManager publicManager;
    @Autowired
    PlatformManager platformManager;
    @Autowired
    GetWechatInfo getWechatInfo;

    public DataResponse getFansInfo(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String openid = data_jo.getString("openid");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        this.publicManager.setPublic(publicInfo);
        User user = UserAPI.userInfo((String)this.publicManager.getAccessToken(), (String)openid);
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        if (!user.isSuccess()) {
            dataResponse.setStatus(Status.FAILED).setMsg(user.getErrmsg());
            return dataResponse;
        }
        dataResponse.setStatus(Status.SUCCESS).setMsg(user.getErrmsg()).setData(JSON.parseObject((String)JSON.toJSONString((Object)user)));
        return dataResponse;
    }

    public DataResponse getFansList(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String public_appid = data_jo.getString("public_appid");
        String next_openid = data_jo.getString("next_openid");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        this.publicManager.setPublic(publicInfo);
        FollowResult user = UserAPI.userGet((String)this.publicManager.getAccessToken(), (String)next_openid);
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        if (!user.isSuccess()) {
            dataResponse.setStatus(Status.FAILED).setMsg(user.getErrmsg());
            return dataResponse;
        }
        dataResponse.setStatus(Status.SUCCESS).setMsg(user.getErrmsg()).setData(JSON.parseObject((String)JSON.toJSONString((Object)user)));
        return dataResponse;
    }

    public DataResponse getWebAuthorize(DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        log.debug("---->data_jo:" + data_jo);
        String public_appid = data_jo.getString("appid");
        String component_appid = data_jo.getString("open_appid");
        String code = data_jo.getString("code");
        String component_access_token = data_jo.getString("component_access_token");
        log.debug("------>open_appid:" + component_appid);
        JSONObject platJo = this.getWechatInfo.getOpenInfo(component_appid);
        this.platformManager.setDef_wx_platform(platJo);
        SnsToken snsToken = SnsAPI.oauth2ComponentAccessToken((String)public_appid, (String)code, (String)component_appid, (String)this.platformManager.getAccessToken());
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        try {
            log.debug(JSON.toJSONString((Object)snsToken));
        }
        catch (Exception e) {
            log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (!snsToken.isSuccess()) {
            dataResponse.setStatus(Status.FAILED).setMsg(snsToken.getErrmsg());
            return dataResponse;
        }
        JSONObject return_data = new JSONObject();
        return_data.put("scope", (Object)snsToken.getScope());
        return_data.put("openid", (Object)snsToken.getOpenid());
        return_data.put("access_token", (Object)snsToken.getAccess_token());
        return_data.put("unionid", (Object)snsToken.getUnionid());
        JSONObject result_data = new JSONObject();
        result_data.put("message", (Object)return_data);
        dataResponse.setStatus(Status.SUCCESS).setMsg(snsToken.getErrmsg()).setData(result_data);
        return dataResponse;
    }

    public DataResponse scopeInfo(DataRequest dataRequest) {
        JSONObject request_data = dataRequest.getData();
        String access_token = request_data.getString("access_token");
        String openid = request_data.getString("openid");
        log.debug("----->scopeInfo:" + dataRequest);
        User user = SnsAPI.userinfo((String)access_token, (String)openid, (String)"zh_CN");
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId());
        if (!user.isSuccess()) {
            dataResponse.setStatus(Status.FAILED).setMsg(user.getErrmsg());
            return dataResponse;
        }
        dataResponse.setStatus(Status.SUCCESS).setMsg(user.getErrmsg()).setData(JSON.parseObject((String)JSON.toJSONString((Object)user)));
        return dataResponse;
    }
}

