/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.enterPriseWx.impl;

import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import kr.weitao.business.EnterPriseWechatDirectUrlEnum;
import kr.weitao.business.EnterpriseWechatUrlEnum;
import kr.weitao.common.util.HttpClientUtils;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.wechat.service.enterPriseWx.EnterPriseWechatService;
import kr.weitao.wechat.service.wx.WxService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class EnterPriseWechatServiceImpl
implements EnterPriseWechatService {
    private static final Logger log = LoggerFactory.getLogger(EnterPriseWechatServiceImpl.class);
    @Value(value="${work.weixin.baseUrl}")
    private String baseUrl;
    @Autowired
    private WxService wxService;
    @Value(value="${work.weixin.oauthUrl}")
    private String oauthUrl;
    @Value(value="${spring.profiles.active}")
    private String active;
    private static final String SCOPE = "snsapi_base";
    @Autowired
    MongoTemplate mongoTemplate;

    public DataResponse enterPriseBackgroundCommonMethod(DataRequest request) {
        JSONObject data = request.getData();
        String url = "";
        if (StringUtils.isNotNull((Object)data.getString("enum"))) {
            String name = data.getString("enum");
            EnterpriseWechatUrlEnum enterpriseWechatUrlEnum = EnterpriseWechatUrlEnum.valueOf((String)name);
            data.put("url", (Object)enterpriseWechatUrlEnum.getUrl());
            data.put("requestMethod", (Object)enterpriseWechatUrlEnum.getRequestMethod());
            data.put("scene", (Object)enterpriseWechatUrlEnum.getScene());
        }
        DataResponse backResponse = new DataResponse();
        DataResponse tokenResponse = this.wxService.getEnterPriceWechatToken(request);
        url = data.getString("url");
        String requestMethod = data.getString("requestMethod");
        JSONObject params = data.getJSONObject("params");
        if (!"0".equals(tokenResponse.getCode())) {
            return tokenResponse;
        }
        String token = tokenResponse.getData().getString("token");
        String s = "";
        try {
            StringBuilder requestUrl = new StringBuilder(this.baseUrl);
            requestUrl.append(url).append("?access_token=").append(token);
            if (StringUtils.isNotNull((Object)params) && "get".equals(requestMethod)) {
                for (String param : params.keySet()) {
                    if (!StringUtils.isNotNull((Object)params.getString(param))) continue;
                    requestUrl.append("&").append(param).append("=").append(params.get((Object)param));
                }
                s = HttpClientUtils.executeGet((String)requestUrl.toString(), null);
            } else if ("post".equals(requestMethod)) {
                s = HttpClientUtils.executePost((String)requestUrl.toString(), (String)data.toJSONString(), null);
            }
            log.info("\u4f01\u4e1a\u5fae\u4fe1\u8bf7\u6c42\u5730\u5740\u548c\u53c2\u6570:{}", (Object)requestUrl);
            if (StringUtils.isNull((Object)s)) {
                backResponse.setMsg("\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1\u7ec4\u7ec7\u7ed3\u6784\u8fd4\u56de\u4e3a\u7a7a\u3002");
                return backResponse;
            }
            JSONObject responseObj = JSONObject.parseObject((String)s);
            if (!"0".equals(responseObj.getString("errcode"))) {
                backResponse.setMsg(responseObj.getString("errmsg"));
                log.error("\u4f01\u4e1a\u5fae\u4fe1\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38:{}", (Object)responseObj.getString("errmsg"));
                return backResponse;
            }
            backResponse.setData(responseObj);
            backResponse.setCode("0").setStatus(Status.SUCCESS).setMsg("\u8bf7\u6c42\u6210\u529f");
            return backResponse;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u5f02\u5e38\u5931\u8d25:{}", (Object)e.getLocalizedMessage());
            return backResponse;
        }
    }

    public DataResponse getRedirectUrlCommon(DataRequest request) {
        DataResponse response = new DataResponse();
        JSONObject data = request.getData();
        String type = data.getString("type");
        if (StringUtils.isNull((Object)type)) {
            response.setMsg("\u91cd\u5b9a\u5411\u7c7b\u578b\u4e3a\u7a7a");
            return response;
        }
        String corp_code = data.getString("corp_code");
        BasicDBObject query = new BasicDBObject();
        query.put("is_active", (Object)"Y");
        query.put("corp_code", (Object)corp_code);
        query.put("scene_type", (Object)"applet");
        DBObject applet = this.mongoTemplate.getCollection("def_enterprise_wechat").findOne((DBObject)query);
        if (StringUtils.isNull((Object)applet)) {
            response.setMsg("\u672a\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f");
            return response;
        }
        String appId = applet.get("corpId") != null ? applet.get("corpId").toString() : "";
        StringBuilder url = new StringBuilder(this.oauthUrl);
        if ("C10041".equals(corp_code)) {
            type = "KPI_REDIRECT_URL".equals(type) ? "KPI_REDIRECT_CK_URL" : "DELIVERY_CK_URL";
            url.append("?appid=").append(appId).append("&redirect_uri=").append(EnterPriseWechatDirectUrlEnum.valueOf((String)type).getUrl(this.active)).append("&response_type=code&scope=").append(SCOPE).append("&state=PVH#wechat_redirect");
        } else if ("C10042".equals(corp_code)) {
            type = "KPI_REDIRECT_URL".equals(type) ? "KPI_REDIRECT_TH_URL" : "DELIVERY_TH_URL";
            url.append("?appid=").append(appId).append("&redirect_uri=").append(EnterPriseWechatDirectUrlEnum.valueOf((String)type).getUrl(this.active)).append("&response_type=code&scope=").append(SCOPE).append("&state=PVH#wechat_redirect");
        }
        JSONObject backData = new JSONObject();
        backData.put("redirect_url", (Object)url.toString());
        response.setCode("0");
        response.setStatus(Status.SUCCESS);
        response.setData(backData);
        return response;
    }

    public DataResponse getH5UserId(DataRequest request) {
        JSONObject data = request.getData();
        String code = data.getString("code");
        String scene = data.getString("scene");
        DataResponse response = new DataResponse();
        if (StringUtils.isNull((Object)code)) {
            response.setMsg("\u7528\u6237code\u4e0d\u80fd\u4e3a\u7a7a");
            return response;
        }
        if (StringUtils.isNull((Object)scene)) {
            response.setMsg("\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a");
            return response;
        }
        DataResponse enterPriceWechatToken = this.wxService.getEnterPriceWechatToken(request);
        if (!"0".equals(enterPriceWechatToken.getCode())) {
            return enterPriceWechatToken;
        }
        JSONObject tokenData = enterPriceWechatToken.getData();
        String token = tokenData.getString("token");
        String url = this.baseUrl + "/user/getuserinfo?access_token=" + token + "&code=" + code;
        String s = HttpClientUtils.executeGet((String)url, null);
        log.info("H5\u8bf7\u6c42\u4f01\u4e1a\u5fae\u4fe1\u83b7\u53d6user_id\u8fd4\u56de:{}", (Object)s);
        if (StringUtils.isNull((Object)s)) {
            log.error("\u4f01\u4e1a\u5fae\u4fe1\u83b7\u53d6\u7528\u6237id\u8fd4\u56de\u4e3a\u7a7a");
            response.setMsg("\u4f01\u4e1a\u5fae\u4fe1\u83b7\u53d6\u7528\u6237id\u8fd4\u56de\u4e3a\u7a7a");
            return response;
        }
        JSONObject backData = JSONObject.parseObject((String)s);
        if (0 != backData.getInteger("errcode")) {
            response.setMsg(backData.getString("errmsg"));
            return response;
        }
        response.setData(JSONObject.parseObject((String)s));
        response.setCode("0");
        response.setStatus(Status.SUCCESS);
        response.setMsg("\u8bf7\u6c42\u6210\u529f");
        return response;
    }
}

