/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.authorize.impl;

import com.alibaba.fastjson.JSONObject;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.wechat.mp.bean.component.ComponentReceiveXML;
import kr.weitao.wechat.mp.util.XMLConverUtil;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PlatformManager;
import kr.weitao.wechat.service.authorize.WechatOpenAuthorizeType;
import kr.weitao.wechat.service.authorize.WechatOpenAuthorizer;
import kr.weitao.wechat.service.authorize.WxAuthorize;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxAuthorizeImpl
implements WxAuthorize {
    private static final Logger log = LogManager.getLogger(WxAuthorizeImpl.class);
    @Autowired
    PlatformManager platformManager;
    @Autowired
    GetWechatInfo getWechatInfo;

    public String authorize(String param) {
        log.debug("data:" + param);
        if (StringUtils.isNull((Object)param)) {
            log.error("open event param is null");
            return "success";
        }
        ComponentReceiveXML authorizeinfo = (ComponentReceiveXML)XMLConverUtil.convertToObject(ComponentReceiveXML.class, (String)param);
        if (authorizeinfo == null) {
            log.error("not init ComponentReceiveXML by data:" + param);
            return "success";
        }
        WechatOpenAuthorizeType oat = WechatOpenAuthorizeType.getByCode((String)authorizeinfo.getInfoType());
        if (oat == null || StringUtils.isNull((Object)oat.getBeanName())) {
            log.error("not find WechatOpenAuthorizeType by code:" + authorizeinfo.getInfoType());
            return "success";
        }
        String dispaseBeanName = oat.getBeanName();
        WechatOpenAuthorizer wop = (WechatOpenAuthorizer)SpringUtils.getBean((String)dispaseBeanName);
        if (wop == null) {
            log.error("can not create instance by className:" + dispaseBeanName);
            return "success";
        }
        wop.dispose(authorizeinfo);
        return "success";
    }

    public String getPreAuthorizeCode(String openAppid) {
        JSONObject openInfo = this.getWechatInfo.getOpenInfo(openAppid);
        this.platformManager.setDef_wx_platform(openInfo);
        return this.platformManager.getPreAuhtorizeCode();
    }
}

