/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.authorize.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.starter.util.mongodb.MongodbClient;
import kr.weitao.wechat.service.authorize.WeixinAuthorizeUrl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class WeixinPayAuthorizeUrl
implements WeixinAuthorizeUrl {
    private static final Logger log = LogManager.getLogger(WeixinPayAuthorizeUrl.class);
    @Value(value="${component.appid}")
    String component_appid;
    @Value(value="${weixin.server.pay.domain}")
    String server_doamin;
    @Autowired
    MongoTemplate mongo_template;

    public JSONObject getUrl(JSONObject param) {
        JSONObject activity;
        if (param == null || param.isEmpty()) {
            log.error("order info can not be null");
            throw new CommonException("\u8ba2\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject post_patam = param.getJSONObject("post_param");
        String order_id = post_patam.getString("order_id");
        if (StringUtils.isNull((Object)order_id)) {
            log.error("order_id can not be null");
            throw new CommonException("\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = post_patam.getString("url");
        String state = StringUtils.valueOf((Object)post_patam.getString("state"), (String)"wechat");
        String scope = StringUtils.valueOf((Object)post_patam.getString("scope"), (String)"snsapi_base");
        BasicDBObject order_query = new BasicDBObject("order_id", (Object)order_id);
        DBObject order_db = null;
        BasicDBObject show_key = new BasicDBObject();
        show_key.put((Object)"productList", (Object)"1");
        show_key.put((Object)"activity_id", (Object)"1");
        try {
            order_db = this.mongo_template.getCollection("def_order").findOne((DBObject)order_query, (DBObject)show_key);
        }
        catch (Exception e) {
            log.error("get order by:" + order_query + " error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        JSONObject order_jo = null;
        if (order_db == null) {
            log.error("not find order by:" + order_query);
            throw new CommonException("\u8ba2\u5355\u4fe1\u606f\u6709\u8bef");
        }
        try {
            order_jo = JSONObject.parseObject((String)JSON.toJSONString((Object)order_db.toMap()));
        }
        catch (Exception e) {
            log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (order_jo == null || order_jo.isEmpty()) {
            log.error("order info is null");
            throw new CommonException("\u8ba2\u5355\u4fe1\u606f\u6709\u8bef");
        }
        JSONArray product_list = order_jo.getJSONArray("productList");
        String activity_id = order_jo.getString("activity_id");
        if (product_list == null || product_list.isEmpty()) {
            log.error("order product can not be null");
            throw new CommonException("\u8ba2\u5355\u5546\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject product_item = product_list.getJSONObject(0);
        String corp_id = product_item.getString("corp_code");
        String user_id = product_item.getString("creator_id");
        if (StringUtils.isNull((Object)corp_id) && StringUtils.isNull((Object)user_id)) {
            log.error("corp and user_id can not be null");
            throw new CommonException("\u8ba2\u5355\u4fe1\u606f\u6709\u8bef");
        }
        BasicDBObject payment_account_query = new BasicDBObject();
        if (StringUtils.isNotNull((Object)corp_id)) {
            payment_account_query.put((Object)"corp_id", (Object)corp_id);
        } else {
            payment_account_query.put((Object)"creator_id", (Object)user_id);
        }
        JSONObject payment_account = null;
        try {
            payment_account = this.getMongodbClient().findOne("def_payment_account", payment_account_query);
        }
        catch (Exception e) {
            log.error("get payment account by query:" + payment_account_query + " error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("\u652f\u4ed8\u4fe1\u606f\u7ef4\u62a4\u6709\u8bef");
        }
        if (payment_account == null || payment_account.isEmpty()) {
            log.error("not find payment account");
            throw new CommonException("\u8bf7\u7ef4\u62a4\u652f\u4ed8\u4fe1\u606f");
        }
        String public_appid = payment_account.getString("sub_appid");
        if (StringUtils.isNull((Object)public_appid)) {
            public_appid = payment_account.getString("appid");
        }
        StringBuffer auth_url = new StringBuffer();
        StringBuffer redirect_url = new StringBuffer(this.server_doamin);
        redirect_url.append(url);
        if (url.indexOf("?") > -1) {
            redirect_url.append("&order_id=").append(order_id);
        } else {
            redirect_url.append("?order_id=").append(order_id);
        }
        if (StringUtils.isNotNull((Object)activity_id) && StringUtils.isNotNull((Object)(activity = this.getMongodbClient().findOne("def_activity", new BasicDBObject("_id", (Object)new ObjectId(activity_id)))))) {
            redirect_url.append("&activity_type=").append(activity.getString("activity_type"));
        }
        String encoder_url = null;
        try {
            encoder_url = URLEncoder.encode(redirect_url.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("encode error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("\u4e0b\u5355\u5931\u8d25");
        }
        auth_url.append("https://open.weixin.qq.com/connect/oauth2/authorize?appid=").append(public_appid).append("&redirect_uri=").append(encoder_url).append("&response_type=code&scope=").append(scope).append("&state=").append(state).append("&component_appid=").append(this.component_appid).append("#wechat_redirect");
        JSONObject result_jo = new JSONObject();
        result_jo.put("authorize_url", (Object)auth_url.toString());
        JSONObject result_data = new JSONObject();
        result_data.put("message", (Object)result_jo);
        return result_data;
    }

    private MongodbClient getMongodbClient() {
        return (MongodbClient)SpringUtils.getBean(MongodbClient.class);
    }
}

