/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.authorize.impl;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.wechat.service.authorize.WeixinAuthorizeUrl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GetOrderVipOpenidAuthorizeUrl
implements WeixinAuthorizeUrl {
    private static final Logger log = LogManager.getLogger(GetOrderVipOpenidAuthorizeUrl.class);
    @Value(value="${component.appid}")
    String component_appid;
    @Value(value="${weixin.server.pay.domain}")
    String server_doamin;
    @Value(value="${public.appid}")
    String public_appid;

    public JSONObject getUrl(JSONObject param) {
        if (param == null || param.isEmpty()) {
            log.error("order info can not be null");
            throw new CommonException("\u8ba2\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject post_patam = param.getJSONObject("post_param");
        String redirectUrl = post_patam.getString("redirect_url");
        String app_id = StringUtils.valueOf((Object)post_patam.getString("app_id"), (String)this.public_appid);
        String state = StringUtils.valueOf((Object)post_patam.getString("state"), (String)"wechat");
        String scope = StringUtils.valueOf((Object)post_patam.getString("scope"), (String)"snsapi_base");
        StringBuffer auth_url = new StringBuffer();
        StringBuffer redirect_url = new StringBuffer(this.server_doamin);
        redirect_url.append(redirectUrl);
        String encoder_url = null;
        try {
            encoder_url = URLEncoder.encode(redirect_url.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("encode error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("\u4e0b\u5355\u5931\u8d25");
        }
        auth_url.append("https://open.weixin.qq.com/connect/oauth2/authorize?appid=").append(app_id).append("&redirect_uri=").append(encoder_url).append("&response_type=code&scope=").append(scope).append("&state=").append(state).append("&component_appid=").append(this.component_appid).append("#wechat_redirect");
        log.info("---auth_url---" + auth_url);
        JSONObject result_jo = new JSONObject();
        result_jo.put("authorize_url", (Object)auth_url.toString());
        return result_jo;
    }
}

