/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.service.authorize.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.wechat.mp.bean.component.ApiGetAuthorizerInfoResult;
import kr.weitao.wechat.mp.bean.component.ApiQueryAuthResult;
import kr.weitao.wechat.mp.bean.component.ComponentReceiveXML;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PlatformManager;
import kr.weitao.wechat.open.PublicManager;
import kr.weitao.wechat.service.authorize.WechatOpenAuthorizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthorizeEvent
implements WechatOpenAuthorizer {
    private static final Logger log = LogManager.getLogger(AuthorizeEvent.class);
    @Autowired
    GetWechatInfo getWechatInfo;
    @Autowired
    PlatformManager platformManager;
    @Autowired
    PublicManager publicManager;

    public void dispose(ComponentReceiveXML eventInfo, String def_corp_id, String userId) {
        if (eventInfo == null || StringUtils.isNull((Object)eventInfo.getAppId())) {
            log.error("ComponentReceiveXML or appid is null");
            throw new CommonException("-20", "\u6388\u6743\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject openjo = this.getWechatInfo.getOpenInfo(eventInfo.getAppId());
        this.platformManager.setDef_wx_platform(openjo);
        ApiQueryAuthResult publicAuthorizeInfo = this.platformManager.getPublicAuthorize(eventInfo.getAuthorizationCode());
        if (!publicAuthorizeInfo.isSuccess()) {
            log.error("get PublicAuthorize error:" + publicAuthorizeInfo.getErrmsg());
            throw new CommonException(publicAuthorizeInfo.getErrcode(), publicAuthorizeInfo.getErrmsg());
        }
        log.debug("publicinfo:" + JSON.toJSONString((Object)publicAuthorizeInfo));
        long currentTime = System.currentTimeMillis();
        currentTime += (long)((publicAuthorizeInfo.getAuthorization_info().getExpires_in() - 300) * 1000);
        JSONObject publicJo = null;
        try {
            publicJo = this.getWechatInfo.getPublicInfo(publicAuthorizeInfo.getAuthorization_info().getAuthorizer_appid());
        }
        catch (Exception e) {
            log.error("find public info error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (publicJo == null || publicJo.isEmpty()) {
            try {
                this.getWechatInfo.insertPublic(publicAuthorizeInfo, this.platformManager.getAppid(), userId, def_corp_id, currentTime);
            }
            catch (Exception e) {
                log.error("create public error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("-20", "\u521b\u5efa\u516c\u4f17\u53f7\u4fe1\u606f\u9519\u8bef");
            }
            publicJo = this.getWechatInfo.getPublicInfo(publicAuthorizeInfo.getAuthorization_info().getAuthorizer_appid());
            if (publicJo == null || publicJo.isEmpty()) {
                log.error("not find public");
                throw new CommonException("-20", "\u521b\u5efa\u516c\u4f17\u53f7\u4fe1\u606f\u9519\u8bef");
            }
            this.publicManager.setPublic(publicJo);
        } else {
            this.publicManager.setPublic(publicJo);
            this.publicManager.updatePublicInfo(publicAuthorizeInfo, userId, currentTime);
        }
        ApiGetAuthorizerInfoResult publicInfo = this.platformManager.getPublicInfo(publicAuthorizeInfo.getAuthorization_info().getAuthorizer_appid());
        this.publicManager.updatePublicInfo(publicInfo);
    }

    public void dispose(ComponentReceiveXML eventInfo) {
        this.dispose(eventInfo, null, null);
    }
}

