/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.open;

import com.alibaba.fastjson.JSONObject;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.wechat.mp.api.ComponentAPI;
import kr.weitao.wechat.mp.api.TicketAPI;
import kr.weitao.wechat.mp.bean.component.ApiGetAuthorizerInfoResult;
import kr.weitao.wechat.mp.bean.component.ApiQueryAuthResult;
import kr.weitao.wechat.mp.bean.component.AuthorizerAccessToken;
import kr.weitao.wechat.mp.bean.ticket.Ticket;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PlatformManager;
import kr.weitao.wechat.open.schema.Wx_Public;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PublicManager {
    private static final Logger log = LogManager.getLogger(PublicManager.class);
    private Wx_Public def_wx_public;
    private PlatformManager platformManager;
    @Autowired
    private GetWechatInfo getWechatInfo;

    public Wx_Public getPublic() {
        if (this.def_wx_public == null) {
            log.error("getpublc public info is null");
            throw new CommonException("-20", "\u516c\u4f17\u53f7\u4fe1\u606f\u4e3a\u7a7a");
        }
        return this.def_wx_public;
    }

    public void setPublic(Wx_Public publicInfo) {
        this.def_wx_public = publicInfo;
    }

    public void setPublic(String publicInfo) {
        this.def_wx_public = (Wx_Public)JSONObject.parseObject((String)publicInfo, Wx_Public.class);
        String openAppid = this.def_wx_public.getPlatform_appid();
        this.platformManager = (PlatformManager)SpringUtils.getBean(PlatformManager.class);
        this.platformManager.setDef_wx_platform(this.getWechatInfo.getOpenInfo(openAppid));
    }

    public void setPublic(JSONObject publicInfo) {
        this.setPublic(publicInfo.toJSONString());
    }

    public void setPlatformManager(PlatformManager platformManager) {
        this.platformManager = platformManager;
    }

    public void updatePublicInfo(ApiGetAuthorizerInfoResult publicInfo) {
        this.getWechatInfo.updatePulic(publicInfo);
    }

    public void updatePublicInfo(ApiQueryAuthResult authorize, String userId, long aatTime) {
        this.getWechatInfo.updatePublic(authorize, userId, aatTime);
        this.getWechatInfo.refershPublicInfo(authorize.getAuthorization_info().getAuthorizer_appid());
    }

    public String getAccessToken() {
        if (StringUtils.isNull((Object)this.getPublic().getAuthorizer_access_token()) || StringUtils.isNull((Object)this.getPublic().getAuthorizer_refresh_token())) {
            log.error("public accesstoken or refaccesstoken is null");
            throw new CommonException("-10", "\u516c\u4f17\u53f7\u672a\u6388\u6743\uff0c\u8bf7\u91cd\u65b0\u6388\u6743");
        }
        if (System.currentTimeMillis() > this.getPublic().getAattime()) {
            AuthorizerAccessToken aat = ComponentAPI.api_authorizer_token((String)this.platformManager.getAccessToken(), (String)this.platformManager.getAppid(), (String)this.getPublic().getAppid(), (String)this.getPublic().getAuthorizer_refresh_token());
            long currentTime = System.currentTimeMillis();
            this.getWechatInfo.updatePublicAccessToken(aat, this.getPublic().getAppid(), currentTime += (long)((aat.getExpires_in() - 300) * 1000));
            this.getWechatInfo.refershPublicInfo(this.getPublic().getAppid());
            this.getPublic().setAuthorizer_refresh_token(aat.getAuthorizer_refresh_token());
            this.getPublic().setAuthorizer_access_token(aat.getAuthorizer_access_token());
            this.getPublic().setAattime(currentTime);
        }
        return this.getPublic().getAuthorizer_access_token();
    }

    public String getJssdkAccessToken() {
        String jssdk_access_token = null;
        if (StringUtils.isNull((Object)this.def_wx_public.getJssdk_access_token()) || this.def_wx_public.getJattime() < System.currentTimeMillis()) {
            String authorizer_access_token = this.getAccessToken();
            if (StringUtils.isNull((Object)authorizer_access_token)) {
                log.error("WxPublicControl getJssdk_access_token \u83b7\u53d6authorizer_access_token\u5931\u8d25");
                return null;
            }
            Ticket ticket = TicketAPI.ticketGetticket((String)authorizer_access_token, (String)"jsapi");
            if (!ticket.isSuccess()) {
                log.error("\u8bf7\u6c42\u83b7\u5f97jsapi_ticket \u6709\u6548\u671f7200\u79d2\uff0c\u5f00\u53d1\u8005\u5fc5\u987b\u5728\u81ea\u5df1\u7684\u670d\u52a1\u5168\u5c40\u7f13\u5b58jsapi_ticket");
                return null;
            }
            long currentTime = System.currentTimeMillis();
            this.getWechatInfo.updatePublicJssdkAccessToken(ticket, this.getPublic().getAppid(), currentTime += (long)((ticket.getExpires_in() - 300) * 1000));
            this.getWechatInfo.refershPublicInfo(this.getPublic().getAppid());
            this.getPublic().setJssdk_access_token(ticket.getTicket());
            this.getPublic().setCattime(currentTime);
            jssdk_access_token = this.getPublic().getJssdk_access_token();
        } else {
            jssdk_access_token = this.getPublic().getJssdk_access_token();
        }
        log.debug("--------jssdk_ticket:" + jssdk_access_token);
        return jssdk_access_token;
    }
}

