/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.open;

import com.alibaba.fastjson.JSONObject;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.wechat.mp.api.ComponentAPI;
import kr.weitao.wechat.mp.bean.component.ApiGetAuthorizerInfoResult;
import kr.weitao.wechat.mp.bean.component.ApiQueryAuthResult;
import kr.weitao.wechat.mp.bean.component.ComponentAccessToken;
import kr.weitao.wechat.mp.bean.component.ComponentReceiveXML;
import kr.weitao.wechat.mp.bean.component.PreAuthCode;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.schema.Wx_Platform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PlatformManager {
    private static final Logger log = LogManager.getLogger(PlatformManager.class);
    private Wx_Platform wx_platform;
    @Autowired
    private GetWechatInfo getWechatInfo;

    private Wx_Platform getOpen() {
        if (this.wx_platform == null) {
            log.error("getopen open info is null");
            throw new CommonException("-20", "\u5e73\u53f0\u4fe1\u606f\u4e3a\u7a7a");
        }
        return this.wx_platform;
    }

    public void setDef_wx_platform(Wx_Platform platform) {
        this.wx_platform = platform;
    }

    public void setDef_wx_platform(JSONObject platform) {
        this.wx_platform = (Wx_Platform)JSONObject.parseObject((String)platform.toJSONString(), Wx_Platform.class);
    }

    public void setDef_wx_platform(String platform) {
        this.setDef_wx_platform(JSONObject.parseObject((String)platform));
    }

    public String getAccessToken() {
        if (StringUtils.isNull((Object)this.getOpen().getCattime()) || System.currentTimeMillis() > this.getOpen().getCattime()) {
            ComponentAccessToken cat = ComponentAPI.api_component_token((String)this.getOpen().getAppid(), (String)this.getOpen().getAppsecret(), (String)this.getOpen().getComponent_verify_ticket());
            long currentTime = System.currentTimeMillis();
            this.getWechatInfo.refershOpenInfo(this.getAppid());
            this.getWechatInfo.updateOpenAccessToken(cat, this.getOpen().getAppid(), currentTime += (long)((cat.getExpires_in() - 300) * 1000));
            this.getOpen().setComponent_access_token(cat.getComponent_access_token());
            this.getOpen().setCattime(currentTime);
        }
        return this.getOpen().getComponent_access_token();
    }

    public String getAppid() {
        return this.getOpen().getAppid();
    }

    public String getPreAuhtorizeCode() {
        log.info("current:" + System.currentTimeMillis() + ",pattime:" + this.getOpen().getPattime());
        PreAuthCode pac = ComponentAPI.api_create_preauthcode((String)this.getAccessToken(), (String)this.getAppid());
        if (pac == null) {
            log.error("get platform precode error result is null");
            throw new CommonException("-10", "\u83b7\u53d6\u6388\u6743\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5");
        }
        if (!pac.isSuccess()) {
            log.error("get platform precode error:" + pac.getErrmsg());
            throw new CommonException("-10", StringUtils.valueOf((Object)pac.getErrmsg(), (String)"\u83b7\u53d6\u6388\u6743\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5"));
        }
        long currentTime = System.currentTimeMillis();
        this.getWechatInfo.updatePreAuthorizeCode(pac.getPre_auth_code(), this.getAppid(), currentTime += (long)((pac.getExpires_in() - 300) * 1000));
        this.getWechatInfo.refershOpenInfo(this.getAppid());
        this.getOpen().setPre_authorized_token(pac.getPre_auth_code());
        this.getOpen().setPattime(currentTime);
        return this.getOpen().getPre_authorized_token();
    }

    public String getToken() {
        return this.getOpen().getToken();
    }

    public String getNewEncodingAeskey() {
        return this.getOpen().getNew_encoding_aeskey();
    }

    public String getOldEncodingAeskey() {
        return this.getOpen().getOld_encoding_aeskey();
    }

    public ApiQueryAuthResult getPublicAuthorize(String authorizeCode) {
        return ComponentAPI.api_query_auth((String)this.getAccessToken(), (String)this.getOpen().getAppid(), (String)authorizeCode);
    }

    public ApiGetAuthorizerInfoResult getPublicInfo(String publicAppid) {
        return ComponentAPI.api_get_authorizer_info((String)this.getAccessToken(), (String)this.getOpen().getAppid(), (String)publicAppid);
    }

    public void updateTicket(ComponentReceiveXML eventInfo) {
        this.getWechatInfo.updateOpenTicket(eventInfo);
    }
}

