/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.open;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.starter.util.mongodb.MongodbClient;
import kr.weitao.starter.util.oss.OssClient;
import kr.weitao.starter.util.redis.RedisClient;
import kr.weitao.wechat.mp.bean.component.ApiGetAuthorizerInfoResult;
import kr.weitao.wechat.mp.bean.component.ApiQueryAuthResult;
import kr.weitao.wechat.mp.bean.component.AuthorizerAccessToken;
import kr.weitao.wechat.mp.bean.component.ComponentAccessToken;
import kr.weitao.wechat.mp.bean.component.ComponentReceiveXML;
import kr.weitao.wechat.mp.bean.ticket.Ticket;
import kr.weitao.wechat.open.schema.Wx_Public;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GetWechatInfo {
    private static final Logger log = LogManager.getLogger(GetWechatInfo.class);
    @Autowired
    RedisClient redisClient;
    @Autowired
    OssClient ossClient;
    @Value(value="${image.dir.baio.public.qrcode}")
    String ossPublicQrcodeDir;

    public MongodbClient getMongodbClient() {
        return (MongodbClient)SpringUtils.getBean(MongodbClient.class);
    }

    public JSONObject getOpenInfo(String openAppid) {
        JSONObject openInfo = null;
        if (StringUtils.isNull((Object)openAppid)) {
            log.error("open appid can not be null");
            throw new CommonException("-1", "\u5f00\u653e\u5e73\u53f0APPID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            openInfo = JSONObject.parseObject((String)this.redisClient.getValueOps().getValueString("wechat-open-appid-" + openAppid));
        }
        catch (Exception e) {
            log.error("get redis error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (openInfo == null || openInfo.isEmpty()) {
            BasicDBObject query = new BasicDBObject("appid", (Object)openAppid);
            openInfo = this.getMongodbClient().findOne("def_wechat_open", query);
            if (openInfo == null || openInfo.isEmpty()) {
                log.error("not find openinfo by openAppid:" + openAppid);
                return openInfo;
            }
            this.redisClient.getValueOps().setValueString("wechat-open-appid-" + openAppid, openInfo.toJSONString());
        }
        if (openInfo == null || openInfo.isEmpty()) {
            log.error("not find platform");
            throw new CommonException("-20", "\u8bf7\u7f13\u5b58\u597d\u5e73\u53f0\u4fe1\u606f\u540e\u518d\u8bd5");
        }
        return openInfo;
    }

    public JSONObject getPublicInfo(String publicAppid) {
        JSONObject publicInfo = null;
        if (StringUtils.isNull((Object)publicAppid)) {
            log.error("public appid can not be null");
            throw new CommonException("-1", "\u516c\u4f17\u53f7APPID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            publicInfo = JSONObject.parseObject((String)this.redisClient.getValueOps().getValueString("wechat-public-appid-" + publicAppid));
        }
        catch (Exception e) {
            log.error("get redis error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (publicInfo == null || publicInfo.isEmpty()) {
            BasicDBObject query = new BasicDBObject("appid", (Object)publicAppid);
            publicInfo = this.getMongodbClient().findOne("def_wechat_public", query);
            if (publicInfo == null || publicInfo.isEmpty()) {
                log.error("not find openinfo by openAppid:" + publicAppid);
                return publicInfo;
            }
            try {
                this.redisClient.getValueOps().setValueString("wechat-public-appid-" + publicAppid, publicInfo.toJSONString());
            }
            catch (Exception e) {
                log.error("set error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (publicInfo == null || publicInfo.isEmpty()) {
            log.error("not find by appid:" + publicAppid);
            throw new CommonException("-10", "\u8bf7\u5148\u516c\u4f17\u53f7\u6388\u6743");
        }
        return publicInfo;
    }

    public void updateOpenTicket(ComponentReceiveXML openInfo) {
        if (openInfo == null) {
            log.error("ComponentReceiveXML is null");
            throw new CommonException("-1", "\u66f4\u65b0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BasicDBObject update_query = new BasicDBObject("appid", (Object)openInfo.getAppId());
        BasicDBObject update_item = new BasicDBObject("component_verify_ticket", (Object)openInfo.getComponentVerifyTicket());
        update_item.put((Object)"modified_date", (Object)TimeUtils.getTime((long)System.currentTimeMillis()));
        this.getMongodbClient().updates("def_wechat_open", update_query, update_item);
        JSONObject opinInfojo = this.getOpenInfo(openInfo.getAppId());
        if (opinInfojo == null || opinInfojo.isEmpty()) {
            log.error("not find opinInfojo by openappid:" + openInfo.getAppId());
            throw new CommonException("-1", "\u5e73\u53f0\u4fe1\u606f\u672a\u7ef4\u62a4");
        }
        opinInfojo.put("component_verify_ticket", (Object)openInfo.getComponentVerifyTicket());
        this.redisClient.getValueOps().setValueString("wechat-open-appid-" + openInfo.getAppId(), opinInfojo.toJSONString());
    }

    public void updateOpenAccessToken(ComponentAccessToken cat, String openAppid, long catTime) {
        if (StringUtils.isNull((Object)openAppid)) {
            log.error("open appid can not be null");
            throw new CommonException("-1", "\u5f00\u653e\u5e73\u53f0APPID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (cat == null) {
            log.error("componentaccesstoken can not be null");
            throw new CommonException("-1", "\u66f4\u65b0\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BasicDBObject update_query = new BasicDBObject("appid", (Object)openAppid);
        BasicDBObject update_item = new BasicDBObject("component_access_token", (Object)cat.getComponent_access_token());
        update_item.put((Object)"cattime", (Object)catTime);
        this.getMongodbClient().updates("def_wechat_open", update_query, update_item);
        JSONObject openInfo = this.getOpenInfo(openAppid);
        if (openInfo == null || openInfo.isEmpty()) {
            log.error("not find opinInfojo by openappid:" + openAppid);
            throw new CommonException("-1", "\u5e73\u53f0\u4fe1\u606f\u672a\u7ef4\u62a4");
        }
        openInfo.put("component_access_token", (Object)cat.getComponent_access_token());
        openInfo.put("cattime", (Object)catTime);
        this.redisClient.getValueOps().setValueString("wechat-open-appid-" + openAppid, openInfo.toJSONString());
    }

    public void insertPublic(ApiQueryAuthResult authorize, String openAppid, String userId, String def_corp_id, long aatTime) {
        String current_date = TimeUtils.getTime((long)System.currentTimeMillis());
        Wx_Public wechat_public = new Wx_Public();
        wechat_public.set_id((Object)new ObjectId());
        wechat_public.setCreator_id(userId);
        wechat_public.setCreated_date(current_date);
        wechat_public.setModifier_id(userId);
        wechat_public.setCreated_date(current_date);
        wechat_public.setAppid(authorize.getAuthorization_info().getAuthorizer_appid());
        wechat_public.setFunction_info(JSON.toJSONString((Object)authorize.getAuthorization_info().getFunc_info()));
        wechat_public.setAuthorizer_refresh_token(authorize.getAuthorization_info().getAuthorizer_refresh_token());
        wechat_public.setAuthorizer_access_token(JSON.toJSONString((Object)authorize.getAuthorization_info().getAuthorizer_access_token()));
        wechat_public.setAattime(aatTime);
        wechat_public.setPlatform_appid(openAppid);
        this.getMongodbClient().getMongoTemplate().save((Object)wechat_public);
    }

    public void updatePublic(ApiQueryAuthResult authorize, String userId, long aatTime) {
        BasicDBObject update_query = new BasicDBObject("appid", (Object)authorize.getAuthorization_info().getAuthorizer_appid());
        BasicDBObject update_item = new BasicDBObject();
        update_item.put((Object)"authorizer_access_token", (Object)authorize.getAuthorization_info().getAuthorizer_access_token());
        update_item.put((Object)"authorizer_refresh_token", (Object)authorize.getAuthorization_info().getAuthorizer_refresh_token());
        update_item.put((Object)"aattime", (Object)aatTime);
        this.getMongodbClient().updates("def_wechat_public", update_query, update_item);
    }

    public void updatePulic(ApiGetAuthorizerInfoResult publicInfo) {
        String qrcode_url = publicInfo.getAuthorizer_info().getQrcode_url();
        String ossKey = "PUB-" + publicInfo.getAuthorization_info().getAuthorizer_appid();
        boolean isOssSuccess = this.ossClient.passURL(qrcode_url, this.ossPublicQrcodeDir, ossKey);
        String oss_url = null;
        oss_url = isOssSuccess ? this.ossClient.getImgUrl(ossKey, this.ossPublicQrcodeDir) : qrcode_url;
        BasicDBObject update_item = new BasicDBObject();
        update_item.put((Object)"nick_name", (Object)publicInfo.getAuthorizer_info().getNick_name());
        update_item.put((Object)"alias", (Object)publicInfo.getAuthorizer_info().getAlias());
        update_item.put((Object)"head_img", (Object)publicInfo.getAuthorizer_info().getHead_img());
        update_item.put((Object)"qrcode_url", (Object)oss_url);
        update_item.put((Object)"user_name", (Object)publicInfo.getAuthorizer_info().getUser_name());
        update_item.put((Object)"principal_name", (Object)publicInfo.getAuthorizer_info().getPrincipal_name());
        update_item.put((Object)"service_type_info", (Object)publicInfo.getAuthorizer_info().getService_type_info().getId());
        update_item.put((Object)"verify_type_info", (Object)publicInfo.getAuthorizer_info().getVerify_type_info().getId());
        update_item.put((Object)"business_info", (Object)JSON.toJSONString((Object)publicInfo.getAuthorizer_info().getBusiness_info()));
        update_item.put((Object)"func_info", (Object)JSON.toJSONString((Object)publicInfo.getAuthorization_info().getFunc_info()));
        BasicDBObject update_query = new BasicDBObject("appid", (Object)publicInfo.getAuthorization_info().getAuthorizer_appid());
        this.getMongodbClient().updates("def_wechat_public", update_query, update_item);
    }

    public void updatePreAuthorizeCode(String preAuthorizeCode, String openAppid, long patTime) {
        BasicDBObject update_query = new BasicDBObject("appid", (Object)openAppid);
        BasicDBObject update_item = new BasicDBObject();
        update_item.put((Object)"pre_authorized_token", (Object)preAuthorizeCode);
        update_item.put((Object)"pattime", (Object)patTime);
        this.getMongodbClient().updates("def_wechat_open", update_query, update_item);
    }

    public void unAuthorizePublic(String publicAppid) {
        BasicDBObject update_query = new BasicDBObject("appid", (Object)publicAppid);
        BasicDBObject update_item = new BasicDBObject();
        update_item.put((Object)"is_authorize", (Object)"N");
        update_item.put((Object)"unauthorize_date", (Object)TimeUtils.getTime((long)System.currentTimeMillis()));
        this.getMongodbClient().updates("def_wechat_public", update_query, update_item);
    }

    public void updatePublicAccessToken(AuthorizerAccessToken aat, String publicAppid, long aatTime) {
        BasicDBObject update_query = new BasicDBObject("appid", (Object)publicAppid);
        BasicDBObject update_item = new BasicDBObject("authorizer_refresh_token", (Object)aat.getAuthorizer_refresh_token());
        update_item.put((Object)"authorizer_access_token", (Object)aat.getAuthorizer_access_token());
        update_item.put((Object)"aattime", (Object)aatTime);
        this.getMongodbClient().updates("def_wechat_public", update_query, update_item);
    }

    public void refershOpenInfo(String openAppid) {
        BasicDBObject query = new BasicDBObject("appid", (Object)openAppid);
        JSONObject openInfo = this.getMongodbClient().findOne("def_wechat_open", query);
        this.redisClient.getValueOps().setValueString("wechat-open-appid-" + openAppid, openInfo.toJSONString());
    }

    public void refershPublicInfo(String publicAppid) {
        BasicDBObject query = new BasicDBObject("appid", (Object)publicAppid);
        JSONObject publicInfo = this.getMongodbClient().findOne("def_wechat_public", query);
        log.debug("------>redis set:" + publicInfo.toString());
        this.redisClient.getValueOps().setValueString("wechat-public-appid-" + publicAppid, publicInfo.toJSONString());
    }

    public void updatePublicJssdkAccessToken(Ticket ticket, String publicAppid, long catTime) {
        BasicDBObject update_query = new BasicDBObject("appid", (Object)publicAppid);
        BasicDBObject update_item = new BasicDBObject("jssdk_access_token", (Object)ticket.getTicket());
        update_item.put((Object)"jattime", (Object)catTime);
        this.getMongodbClient().updates("def_wechat_public", update_query, update_item);
    }
}

