/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.mp.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kr.weitao.wechat.mp.bean.pay.PayJsRequest;
import kr.weitao.wechat.mp.bean.pay.PayNativeReply;
import kr.weitao.wechat.mp.bean.pay.PayNativeRequest;
import kr.weitao.wechat.mp.bean.pay.PayPackage;
import kr.weitao.wechat.mp.bean.paymch.MchPayApp;
import kr.weitao.wechat.mp.bean.paymch.MchPayNativeReply;
import kr.weitao.wechat.mp.bean.paymch.PapayEntrustweb;
import kr.weitao.wechat.mp.util.JsonUtil;
import kr.weitao.wechat.mp.util.MapUtil;
import kr.weitao.wechat.mp.util.SignatureUtil;
import kr.weitao.wechat.mp.util.XMLConverUtil;

public class PayUtil {
    public static String generatePayJsRequestJson(PayPackage payPackage, String appId, String paternerKey, String paySignkey) {
        Map mapP = MapUtil.objectToMap((Object)payPackage, (String[])new String[0]);
        String package_ = SignatureUtil.generatePackage((Map)mapP, (String)paternerKey);
        PayJsRequest payJsRequest = new PayJsRequest();
        payJsRequest.setAppId(appId);
        payJsRequest.setNonceStr(UUID.randomUUID().toString());
        payJsRequest.setPackage_(package_);
        payJsRequest.setSignType("sha1");
        payJsRequest.setTimeStamp(System.currentTimeMillis() / 1000L + "");
        Map mapS = MapUtil.objectToMap((Object)payJsRequest, (String[])new String[]{"signType", "paySign"});
        String paySign = SignatureUtil.generatePaySign((Map)mapS, (String)paySignkey);
        payJsRequest.setPaySign(paySign);
        return JsonUtil.toJSONString((Object)payJsRequest);
    }

    public static String generatePayNativeRequestURL(String appid, String productid, String paySignkey) {
        PayNativeRequest payNativeRequest = new PayNativeRequest();
        payNativeRequest.setAppid(appid);
        payNativeRequest.setNoncestr(UUID.randomUUID().toString());
        payNativeRequest.setProductid(productid);
        payNativeRequest.setTimestamp(System.currentTimeMillis() / 1000L + "");
        Map mapS = MapUtil.objectToMap((Object)payNativeRequest, (String[])new String[]{"sign"});
        String sign = SignatureUtil.generatePaySign((Map)mapS, (String)paySignkey);
        payNativeRequest.setSign(sign);
        Map map = MapUtil.objectToMap((Object)payNativeRequest, (String[])new String[0]);
        return "weixin://wxpay/bizpayurl?" + MapUtil.mapJoin((Map)map, (boolean)false, (boolean)false);
    }

    public static String generatePayNativeReplyXML(PayPackage payPackage, String appId, String retCode, String retErrMsg, String paternerKey) {
        PayNativeReply payNativeReply = new PayNativeReply();
        payNativeReply.setAppid(appId);
        payNativeReply.setNoncestr(UUID.randomUUID().toString());
        payNativeReply.setRetcode(retCode);
        payNativeReply.setReterrmsg(retErrMsg);
        payNativeReply.setTimestamp(System.currentTimeMillis() + "");
        String package_ = SignatureUtil.generatePackage((Map)MapUtil.objectToMap((Object)payPackage, (String[])new String[0]), (String)paternerKey);
        payNativeReply.setPackage_(package_);
        payNativeReply.setSignmethod("sha1");
        String appSignature = SignatureUtil.generatePackage((Map)MapUtil.objectToMap((Object)payNativeReply, (String[])new String[]{"appsignature", "signmethod"}), (String)paternerKey);
        payNativeReply.setAppsignature(appSignature);
        return XMLConverUtil.convertToXML((Object)payNativeReply);
    }

    public static String generateMchPayJsRequestJson(String prepay_id, String appId, String key) {
        String package_ = "prepay_id=" + prepay_id;
        PayJsRequest payJsRequest = new PayJsRequest();
        payJsRequest.setAppId(appId);
        payJsRequest.setNonceStr(UUID.randomUUID().toString().replace("-", ""));
        payJsRequest.setPackage_(package_);
        payJsRequest.setSignType("MD5");
        payJsRequest.setTimeStamp(System.currentTimeMillis() / 1000L + "");
        Map mapS = MapUtil.objectToMap((Object)payJsRequest, (String[])new String[0]);
        String paySign = SignatureUtil.generateSign((Map)mapS, (String)key);
        payJsRequest.setPaySign(paySign);
        return JsonUtil.toJSONString((Object)payJsRequest);
    }

    public static String generateMchPayNativeRequestURL(String appid, String mch_id, String productid, String key) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("appid", appid);
        map.put("mch_id", mch_id);
        map.put("time_stamp", System.currentTimeMillis() / 1000L + "");
        map.put("nonce_str", UUID.randomUUID().toString().replace("-", ""));
        map.put("product_id", productid);
        String sign = SignatureUtil.generateSign(map, (String)key);
        map.put("sign", sign);
        return "weixin://wxpay/bizpayurl?" + MapUtil.mapJoin(map, (boolean)false, (boolean)false);
    }

    public static String generateMchPayNativeReplyXML(MchPayNativeReply mchPayNativeReply, String key) {
        Map map = MapUtil.objectToMap((Object)mchPayNativeReply, (String[])new String[0]);
        String sign = SignatureUtil.generateSign((Map)map, (String)key);
        mchPayNativeReply.setSign(sign);
        return XMLConverUtil.convertToXML((Object)mchPayNativeReply);
    }

    public static MchPayApp generateMchAppData(String prepay_id, String appId, String partnerid, String key) {
        LinkedHashMap<String, String> wx_map = new LinkedHashMap<String, String>();
        wx_map.put("appid", appId);
        wx_map.put("partnerid", partnerid);
        wx_map.put("prepayid", prepay_id);
        wx_map.put("package", "Sign=WXPay");
        wx_map.put("noncestr", UUID.randomUUID().toString().replace("-", ""));
        wx_map.put("timestamp", System.currentTimeMillis() / 1000L + "");
        String sign = SignatureUtil.generateSign(wx_map, (String)key);
        MchPayApp mchPayApp = new MchPayApp();
        mchPayApp.setAppid(appId);
        mchPayApp.setPartnerid(partnerid);
        mchPayApp.setPrepayid(prepay_id);
        mchPayApp.setPackage_((String)wx_map.get("package"));
        mchPayApp.setNoncestr((String)wx_map.get("noncestr"));
        mchPayApp.setTimestamp((String)wx_map.get("timestamp"));
        mchPayApp.setSign(sign);
        return mchPayApp;
    }

    public static String generatePapayEntrustwebURL(PapayEntrustweb papayEntrustweb, String key) {
        Map map = MapUtil.objectToMap((Object)papayEntrustweb, (String[])new String[0]);
        String sign = SignatureUtil.generateSign((Map)map, (String)key);
        map.put("sign", sign);
        String params = MapUtil.mapJoin((Map)map, (boolean)false, (boolean)true);
        return "https://api.mch.weixin.qq.com/papay/entrustweb?" + params;
    }
}

