/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.mp.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class OKHttpUtil {
    private static final Logger log = LogManager.getLogger(OKHttpUtil.class);
    private final OkHttpClient CLIENT = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType FORM = MediaType.parse((String)"application/x-www-form-urlencoded");

    public JSONObject jsonPost(JSONObject param, String requestUrl) {
        String s = param.toJSONString();
        Request req = new Request.Builder().url(requestUrl).post(RequestBody.create((MediaType)JSON, (String)s)).build();
        Response httpresponse = null;
        String res = "";
        Stopwatch started = Stopwatch.createStarted();
        try {
            httpresponse = this.CLIENT.newCall(req).execute();
            res = httpresponse.body().string();
        }
        catch (Exception e) {
            log.error("---- \u8bf7\u6c42\u5931\u8d25!", (Throwable)e);
        }
        long elapsed = started.elapsed(TimeUnit.MILLISECONDS);
        log.info("---| url:" + requestUrl + ",   param:" + param + ",   string response:" + res + ",   \u8017\u65f6:" + elapsed);
        JSONObject result = null;
        if (Objects.nonNull(httpresponse) && httpresponse.isSuccessful()) {
            try {
                result = JSONObject.parseObject((String)res);
            }
            catch (Exception e) {
                log.info("--- \u83b7\u53d6\u8fd4\u56de\u503c\u5931\u8d25", (Throwable)e);
            }
        }
        return result;
    }

    public JSONObject get(String url) {
        long start = System.currentTimeMillis();
        Request req = new Request.Builder().url(url).build();
        Response resp = null;
        String res = "";
        try {
            resp = this.CLIENT.newCall(req).execute();
            res = resp.body().string();
        }
        catch (Exception e) {
            log.error("---- \u8bf7\u6c42\u5931\u8d25!", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        log.info("---| get url:" + url + "     response:" + res + "   \u8017\u65f6:" + (end - start));
        JSONObject result = null;
        if (Objects.nonNull(resp) && resp.isSuccessful()) {
            try {
                result = JSONObject.parseObject((String)res);
            }
            catch (Exception e) {
                log.info("--- \u83b7\u53d6\u8fd4\u56de\u503c\u5931\u8d25", (Throwable)e);
            }
        }
        return result;
    }

    public JSONObject formPost(JSONObject param, String reqeustUrl) {
        FormBody.Builder builder = new FormBody.Builder();
        builder.add("jsonObject", param.toString());
        FormBody body = builder.build();
        Request req = new Request.Builder().url(reqeustUrl).post((RequestBody)body).build();
        Response httpresponse = null;
        String res = "";
        Stopwatch started = Stopwatch.createStarted();
        try {
            httpresponse = this.CLIENT.newCall(req).execute();
            res = httpresponse.body().string();
        }
        catch (Exception e) {
            log.error("---- \u8bf7\u6c42\u5931\u8d25!", (Throwable)e);
        }
        long elapsed = started.elapsed(TimeUnit.MILLISECONDS);
        log.info("---| url:{},param:{},\u8017\u65f6:{}", (Object)reqeustUrl, (Object)param, (Object)elapsed);
        JSONObject result = null;
        if (Objects.nonNull(httpresponse) && httpresponse.isSuccessful()) {
            try {
                result = JSONObject.parseObject((String)res);
            }
            catch (Exception e) {
                log.info("--- \u83b7\u53d6\u8fd4\u56de\u503c\u5931\u8d25", (Throwable)e);
            }
        }
        return result;
    }
}

