/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.mp.example;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kr.weitao.common.exception.AesException;
import kr.weitao.common.util.wxencrypt.WXBizMsgCrypt;
import kr.weitao.wechat.mp.bean.message.EventMessage;
import kr.weitao.wechat.mp.bean.xmlmessage.XMLTextMessage;
import kr.weitao.wechat.mp.support.ExpireKey;
import kr.weitao.wechat.mp.support.expirekey.DefaultExpireKey;
import kr.weitao.wechat.mp.util.SignatureUtil;
import kr.weitao.wechat.mp.util.StreamUtils;
import kr.weitao.wechat.mp.util.XMLConverUtil;

public class ReceiveServlet2
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static ExpireKey expireKey = new DefaultExpireKey();
    private String appId = "";
    private String token = "test";
    private String encodingToken = "";
    private String encodingAesKey = "";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream inputStream = request.getInputStream();
        ServletOutputStream outputStream = response.getOutputStream();
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        String encrypt_type = request.getParameter("encrypt_type");
        String msg_signature = request.getParameter("msg_signature");
        WXBizMsgCrypt wxBizMsgCrypt = null;
        boolean isAes = "aes".equals(encrypt_type);
        if (isAes) {
            try {
                wxBizMsgCrypt = new WXBizMsgCrypt(this.encodingToken, this.encodingAesKey, this.appId);
            }
            catch (AesException e) {
                e.printStackTrace();
            }
        }
        if (wxBizMsgCrypt == null) {
            return;
        }
        if (isAes && echostr != null) {
            try {
                echostr = URLDecoder.decode(echostr, "utf-8");
                String echostr_decrypt = wxBizMsgCrypt.verifyUrl(msg_signature, timestamp, nonce, echostr);
                this.outputStreamWrite((OutputStream)outputStream, echostr_decrypt);
                return;
            }
            catch (AesException e) {
                e.printStackTrace();
            }
        } else if (echostr != null) {
            this.outputStreamWrite((OutputStream)outputStream, echostr);
            return;
        }
        EventMessage eventMessage = null;
        if (isAes) {
            try {
                String postData = StreamUtils.copyToString((InputStream)inputStream, (Charset)Charset.forName("utf-8"));
                String xmlData = wxBizMsgCrypt.decryptMsg(postData);
                eventMessage = (EventMessage)XMLConverUtil.convertToObject(EventMessage.class, (String)xmlData);
            }
            catch (AesException e) {
                e.printStackTrace();
            }
        } else {
            if (!signature.equals(SignatureUtil.generateEventMessageSignature((String)this.token, (String)timestamp, (String)nonce))) {
                System.out.println("The request signature is invalid");
                return;
            }
            if (inputStream != null) {
                eventMessage = (EventMessage)XMLConverUtil.convertToObject(EventMessage.class, (InputStream)inputStream);
            }
        }
        if (eventMessage == null) {
            return;
        }
        String key = eventMessage.getFromUserName() + "__" + eventMessage.getToUserName() + "__" + eventMessage.getMsgId() + "__" + eventMessage.getCreateTime();
        if (expireKey.exists(key)) {
            return;
        }
        expireKey.add(key);
        XMLTextMessage xmlTextMessage = new XMLTextMessage(eventMessage.getFromUserName(), eventMessage.getToUserName(), "\u4f60\u597d");
        xmlTextMessage.outputStreamWrite((OutputStream)outputStream, wxBizMsgCrypt);
    }

    private boolean outputStreamWrite(OutputStream outputStream, String text) {
        try {
            outputStream.write(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

