/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.mp.example;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kr.weitao.wechat.mp.bean.message.EventMessage;
import kr.weitao.wechat.mp.bean.xmlmessage.XMLTextMessage;
import kr.weitao.wechat.mp.support.ExpireKey;
import kr.weitao.wechat.mp.support.expirekey.DefaultExpireKey;
import kr.weitao.wechat.mp.util.SignatureUtil;
import kr.weitao.wechat.mp.util.XMLConverUtil;

public class ReceiveServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static ExpireKey expireKey = new DefaultExpireKey();
    private String token = "test";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream inputStream = request.getInputStream();
        ServletOutputStream outputStream = response.getOutputStream();
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        if (echostr != null) {
            this.outputStreamWrite((OutputStream)outputStream, echostr);
            return;
        }
        if (!signature.equals(SignatureUtil.generateEventMessageSignature((String)this.token, (String)timestamp, (String)nonce))) {
            System.out.println("The request signature is invalid");
            return;
        }
        if (inputStream != null) {
            EventMessage eventMessage = (EventMessage)XMLConverUtil.convertToObject(EventMessage.class, (InputStream)inputStream);
            String key = eventMessage.getFromUserName() + "__" + eventMessage.getToUserName() + "__" + eventMessage.getMsgId() + "__" + eventMessage.getCreateTime();
            if (expireKey.exists(key)) {
                return;
            }
            expireKey.add(key);
            XMLTextMessage xmlTextMessage = new XMLTextMessage(eventMessage.getFromUserName(), eventMessage.getToUserName(), "\u4f60\u597d");
            xmlTextMessage.outputStreamWrite((OutputStream)outputStream);
            return;
        }
        this.outputStreamWrite((OutputStream)outputStream, "");
    }

    private boolean outputStreamWrite(OutputStream outputStream, String text) {
        try {
            outputStream.write(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

