/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.mp.client;

import kr.weitao.wechat.mp.bean.BaseResult;
import kr.weitao.wechat.mp.bean.paymch.MchBase;
import kr.weitao.wechat.mp.util.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultErrorHandler {
    private static Logger logger = LoggerFactory.getLogger(ResultErrorHandler.class);

    private boolean isError(Object result) {
        if (result != null) {
            MchBase mchBase;
            if (result instanceof BaseResult) {
                BaseResult baseResult = (BaseResult)result;
                return !baseResult.isSuccess();
            }
            if (result instanceof MchBase && ("FAIL".equalsIgnoreCase((mchBase = (MchBase)result).getReturn_code()) || "FAIL".equalsIgnoreCase(mchBase.getResult_code()))) {
                return true;
            }
        }
        return false;
    }

    protected void doHandle(String uriId, HttpUriRequest request, Object result) {
        if (this.isError(result)) {
            String content = null;
            if (request instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase request_base = (HttpEntityEnclosingRequestBase)request;
                HttpEntity entity = request_base.getEntity();
                if (entity.getContentType().toString().indexOf(ContentType.MULTIPART_FORM_DATA.getMimeType()) == -1) {
                    try {
                        content = EntityUtils.toString((HttpEntity)entity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (logger.isErrorEnabled()) {
                    logger.error("URI[{}] {} Content:{} Result:{}", new Object[]{uriId, request.getURI(), content == null ? "multipart_form_data" : content, result == null ? null : JsonUtil.toJSONString((Object)result)});
                }
            }
            this.handle(uriId, request.getURI().toString(), content, result);
        }
    }

    protected abstract void handle(String var1, String var2, String var3, Object var4);
}

