/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.mp.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kr.weitao.wechat.mp.client.HttpClientFactory;
import kr.weitao.wechat.mp.client.JsonResponseHandler;
import kr.weitao.wechat.mp.client.LocalResponseHandler;
import kr.weitao.wechat.mp.client.ResultErrorHandler;
import kr.weitao.wechat.mp.client.XmlResponseHandler;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class LocalHttpClient {
    private static final Logger log = LogManager.getLogger(LocalHttpClient.class);
    private static int timeout = 8000;
    private static int retryExecutionCount = 2;
    protected static CloseableHttpClient httpClient = HttpClientFactory.createHttpClient((int)100, (int)10, (int)timeout, (int)retryExecutionCount);
    private static Map<String, CloseableHttpClient> httpClient_mchKeyStore = new HashMap();
    private static ResultErrorHandler resultErrorHandler;

    public static void setTimeout(int timeout) {
        LocalHttpClient.timeout = timeout;
    }

    public static void setRetryExecutionCount(int retryExecutionCount) {
        LocalHttpClient.retryExecutionCount = retryExecutionCount;
    }

    public static void setResultErrorHandler(ResultErrorHandler resultErrorHandler) {
        LocalHttpClient.resultErrorHandler = resultErrorHandler;
    }

    public static void init(int maxTotal, int maxPerRoute) {
        try {
            httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        httpClient = HttpClientFactory.createHttpClient((int)maxTotal, (int)maxPerRoute, (int)timeout, (int)retryExecutionCount);
    }

    public static void initMchKeyStore(String mch_id, String keyStoreFilePath) {
        try {
            LocalHttpClient.initMchKeyStore((String)mch_id, (InputStream)new FileInputStream(new File(keyStoreFilePath)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void initMchKeyStore(String mch_id, InputStream inputStream) {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(inputStream, mch_id.toCharArray());
            inputStream.close();
            CloseableHttpClient httpClient = HttpClientFactory.createKeyMaterialHttpClient((KeyStore)keyStore, (String)mch_id, (int)timeout, (int)retryExecutionCount);
            httpClient_mchKeyStore.put(mch_id, httpClient);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CloseableHttpResponse execute(HttpUriRequest request) {
        LocalHttpClient.loggerRequest((HttpUriRequest)request);
        try {
            return httpClient.execute(request, (HttpContext)HttpClientContext.create());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T execute(HttpUriRequest request, ResponseHandler<T> responseHandler) {
        String uriId = LocalHttpClient.loggerRequest((HttpUriRequest)request);
        if (responseHandler instanceof LocalResponseHandler) {
            LocalResponseHandler lrh = (LocalResponseHandler)responseHandler;
            lrh.setUriId(uriId);
        }
        try {
            Object t = httpClient.execute(request, responseHandler, (HttpContext)HttpClientContext.create());
            if (resultErrorHandler != null) {
                resultErrorHandler.doHandle(uriId, request, t);
            }
            return (T)t;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T executeJsonResult(HttpUriRequest request, Class<T> clazz) {
        return (T)LocalHttpClient.execute((HttpUriRequest)request, (ResponseHandler)JsonResponseHandler.createResponseHandler(clazz));
    }

    public static <T> T executeXmlResult(HttpUriRequest request, Class<T> clazz) {
        return (T)LocalHttpClient.execute((HttpUriRequest)request, (ResponseHandler)XmlResponseHandler.createResponseHandler(clazz));
    }

    public static <T> T executeXmlResult(HttpUriRequest request, Class<T> clazz, String sign_type, String key) {
        return (T)LocalHttpClient.execute((HttpUriRequest)request, (ResponseHandler)XmlResponseHandler.createResponseHandler(clazz, (String)sign_type, (String)key));
    }

    public static <T> T keyStoreExecuteXmlResult(String mch_id, HttpUriRequest request, Class<T> clazz) {
        return (T)LocalHttpClient.keyStoreExecuteXmlResult((String)mch_id, (HttpUriRequest)request, clazz, null, null);
    }

    public static <T> T keyStoreExecuteXmlResult(String mch_id, HttpUriRequest request, Class<T> clazz, String sign_type, String key) {
        String uriId = LocalHttpClient.loggerRequest((HttpUriRequest)request);
        ResponseHandler responseHandler = XmlResponseHandler.createResponseHandler(clazz, (String)sign_type, (String)key);
        if (responseHandler instanceof LocalResponseHandler) {
            LocalResponseHandler lrh = (LocalResponseHandler)responseHandler;
            lrh.setUriId(uriId);
        }
        try {
            Object t = ((CloseableHttpClient)httpClient_mchKeyStore.get(mch_id)).execute(request, responseHandler, (HttpContext)HttpClientContext.create());
            if (resultErrorHandler != null) {
                resultErrorHandler.doHandle(uriId, request, t);
            }
            return (T)t;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return null;
        }
    }

    private static String loggerRequest(HttpUriRequest request) {
        String id = UUID.randomUUID().toString();
        if (log.isInfoEnabled() || log.isDebugEnabled()) {
            if (request instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase request_base = (HttpEntityEnclosingRequestBase)request;
                HttpEntity entity = request_base.getEntity();
                String content = null;
                if (entity.getContentType().toString().indexOf(ContentType.MULTIPART_FORM_DATA.getMimeType()) == -1) {
                    try {
                        content = EntityUtils.toString((HttpEntity)entity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error(e.getMessage());
                    }
                }
                log.info("URI[{}] {} {} ContentLength:{} Content:{}", (Object)id, (Object)request.getURI().toString(), (Object)entity.getContentType(), (Object)entity.getContentLength(), (Object)(content == null ? "multipart_form_data" : content));
            } else {
                log.info("URI[{}] {}", (Object)id, (Object)request.getURI().toString());
            }
        }
        return id;
    }
}

