/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.controller.wx;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.wechat.service.wx.WxService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5fae\u4fe1\u7ed1\u5b9a", description="\u4e2a\u4eba\u5fae\u4fe1\u670d\u52a1", tags={"wxService"})
@RestController
@RefreshScope
@RequestMapping(value={"/wxAuth"})
public class WxController {
    private static final Logger log = LogManager.getLogger(WxController.class);
    @Autowired
    WxService wxService;

    @ApiOperation(value="\u5fae\u4fe1\u767b\u5165\u9a8c\u8bc1")
    @RequestMapping(value={"/checkLogin"}, method={RequestMethod.POST})
    public DataResponse checkLogin(@RequestBody DataRequest dataRequest) {
        return this.wxService.checkLogin(dataRequest);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e8c\u7ef4\u7801")
    @RequestMapping(value={"/genQrcode"}, method={RequestMethod.POST})
    public DataResponse genQrcode(@RequestBody DataRequest dataRequest) {
        return this.wxService.genQrcode(dataRequest);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u8054\u7cfb\u4eba")
    @RequestMapping(value={"/getContactList"}, method={RequestMethod.POST})
    public DataResponse getContactList(@RequestBody DataRequest dataRequest) {
        return this.wxService.getContactList(dataRequest);
    }

    @ApiOperation(value="\u83b7\u53d6\u72b6\u6001")
    @RequestMapping(value={"/getState"}, method={RequestMethod.POST})
    public DataResponse getState(@RequestBody DataRequest dataRequest) {
        return this.wxService.getState(dataRequest);
    }

    @PostMapping(value={"/logout"})
    @ApiOperation(value="\u5fae\u4fe1\u6ce8\u9500")
    public DataResponse loginOut(@RequestBody DataRequest dataRequest) {
        return this.wxService.userLogout(dataRequest);
    }

    @ApiOperation(value="\u4e0a\u4f20\u670b\u53cb\u5708\u56fe\u7247")
    @RequestMapping(value={"/snsUploadImg"}, method={RequestMethod.POST})
    public DataResponse snsUploadImg(@RequestBody DataRequest dataRequest) {
        return this.wxService.snsUploadImg(dataRequest);
    }

    @ApiOperation(value="\u53d1\u5e03\u670b\u53cb\u5708")
    @RequestMapping(value={"/snsPublish"}, method={RequestMethod.POST})
    public DataResponse snsPublish(@RequestBody DataRequest dataRequest) {
        return this.wxService.snsPublish(dataRequest);
    }

    @ApiOperation(value="\u5220\u9664\u670b\u53cb\u5708")
    @RequestMapping(value={"/snsRemove"}, method={RequestMethod.POST})
    public DataResponse snsRemove(@RequestBody DataRequest dataRequest) {
        return this.wxService.snsRemove(dataRequest);
    }

    @ApiOperation(value="\u83b7\u53d6\u5728\u7ebf\u7528\u6237")
    @RequestMapping(value={"/getOnlineUsers"}, method={RequestMethod.POST})
    public DataResponse getOnlineUsers(@RequestBody DataRequest dataRequest) {
        return this.wxService.getOnlineUsers(dataRequest);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4e8c\u7ef4\u7801")
    @RequestMapping(value={"/getUserQrcode"}, method={RequestMethod.POST})
    public DataResponse getUserQrcode(@RequestBody DataRequest dataRequest) {
        return this.wxService.getUserQrcode(dataRequest);
    }

    @ApiOperation(value="\u53d1\u9001\u804a\u5929\u6d88\u606f")
    @RequestMapping(value={"/sendMsg"}, method={RequestMethod.POST})
    public DataResponse sendMsg(@RequestBody DataRequest dataRequest) {
        return this.wxService.sendMsg(dataRequest);
    }

    @RequestMapping(value={"/getEnterpriseWechat/token"}, method={RequestMethod.POST})
    public DataResponse getToken(@RequestBody DataRequest dataRequest) {
        return this.wxService.getEnterPriceWechatToken(dataRequest);
    }

    @ApiOperation(value="\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u7684code2session")
    @RequestMapping(value={"/getQYCode2Session"}, method={RequestMethod.POST})
    public DataResponse getQYCode2Session(@RequestBody DataRequest dataRequest) {
        return this.wxService.getQYCode2Session(dataRequest);
    }

    @ApiOperation(value="\u63a8\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f")
    @RequestMapping(value={"sendQYMsg"}, method={RequestMethod.POST})
    public DataResponse sendQYMsg(@RequestBody DataRequest dataRequest) {
        return this.wxService.sendQYMsg(dataRequest);
    }
}

