/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.controller.menu;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.wechat.mp.bean.BaseResult;
import kr.weitao.wechat.mp.bean.menu.MenuButtons;
import kr.weitao.wechat.service.mp.MenuService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wechat"})
@Api(value="\u83dc\u5355", description="\u53d1\u5e03\u83dc\u5355", tags={"Menu"})
public class MenuController {
    private static final Logger log = LogManager.getLogger(MenuController.class);
    @Autowired
    MenuService menuService;

    @ApiOperation(value="\u5fae\u4fe1\u83dc\u5355\u53d1\u5e03")
    @ApiImplicitParam(name="menu", value="\u8bf7\u6c42\u4f53", required=true)
    @RequestMapping(value={"/public/publish"}, method={RequestMethod.POST})
    public DataResponse publish(@RequestBody DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String publicAppid = data_jo.getString("public_appid");
        log.debug("------>\u53d1\u5e03\u83dc\u5355\uff1a" + dataRequest.toString());
        MenuButtons menu = (MenuButtons)JSONObject.parseObject((String)data_jo.getJSONObject("menu").toString(), MenuButtons.class);
        log.debug("------>menu:" + JSON.toJSONString((Object)menu));
        DataResponse dataResponse = new DataResponse();
        if (menu == null || StringUtils.isNull((Object)publicAppid)) {
            log.error("menu or appid is null");
            dataResponse.setMsg("\u83dc\u5355\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a").setStatus(Status.FAILED).setId(dataRequest.getId());
            return dataResponse;
        }
        String result = this.menuService.publish(menu, publicAppid);
        BaseResult baseResult = (BaseResult)JSON.parseObject((String)result, BaseResult.class);
        log.debug("-------->result:" + result);
        if ("0".equals(baseResult.getErrcode())) {
            dataResponse.setStatus(Status.SUCCESS).setMsg(baseResult.getErrmsg()).setId(dataRequest.getId());
        }
        return dataResponse;
    }

    public String getMenu(String publicAppid) {
        return this.menuService.getMenu(publicAppid);
    }
}

