/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.controller.authorize;

import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.DisposeRetrunUtil;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.common.util.XML;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.common.util.wxencrypt.WXBizMsgCrypt;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.wechat.controller.authorize.WechatPublicController;
import kr.weitao.wechat.mp.bean.component.ComponentReceiveXML;
import kr.weitao.wechat.mp.util.XMLConverUtil;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PlatformManager;
import kr.weitao.wechat.service.authorize.WeixinAuthorizeUrl;
import kr.weitao.wechat.service.authorize.impl.AuthorizeEvent;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(description="\u516c\u4f17\u53f7", tags={"Wechat"})
@RestController
@RequestMapping(value={"/wechat"})
public class WechatPublicController {
    private static final Logger log = LogManager.getLogger(WechatPublicController.class);
    @Autowired
    AuthorizeEvent authorizeEvent;
    @Value(value="${component.appid}")
    String component_appid;
    @Autowired
    GetWechatInfo getWechatInfo;
    @Autowired
    PlatformManager platformManager;
    @Autowired
    MongoTemplate mongo_template;

    @RequestMapping(value={"/public/authorize/callback"}, method={RequestMethod.GET, RequestMethod.POST})
    public DataResponse publicAuthorizeCallback(@RequestBody DataRequest request) {
        DataResponse response = new DataResponse();
        JSONObject data = request.getData();
        JSONObject get_param = data.getJSONObject("get_param");
        JSONObject post_patam = data.getJSONObject("post_param");
        String authCode = get_param.getString("auth_code");
        if (StringUtils.isNull((Object)authCode)) {
            log.error("authCode is null");
            response.setStatus(Status.FAILED);
            response.setMsg("\u516c\u4f17\u53f7\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return response;
        }
        int expiresIn = get_param.getIntValue("expires_in");
        StringBuffer authorizeXml = new StringBuffer();
        authorizeXml.append("<xml>").append("<AppId>").append(this.component_appid).append("</AppId>").append("<AuthorizationCode>").append(authCode).append("</AuthorizationCode>").append("<AuthorizationCodeExpiredTime>").append(expiresIn).append("</AuthorizationCodeExpiredTime>").append("</xml>");
        ComponentReceiveXML arxml = (ComponentReceiveXML)XMLConverUtil.convertToObject(ComponentReceiveXML.class, (String)authorizeXml.toString());
        try {
            this.authorizeEvent.dispose(arxml, null, null);
            response.setStatus(Status.SUCCESS);
            response.setMsg("success");
        }
        catch (CommonException e) {
            response.setStatus(Status.FAILED);
            response.setMsg(e.getMessage());
            log.error("open event error:" + e.getMessage(), (Throwable)e);
        }
        return response;
    }

    @ApiOperation(value="\u83b7\u53d6\u516c\u4f17\u53f7\u6388\u6743\u4fe1\u606f(\u5df2\u6d4b)", notes="")
    @RequestMapping(value={"/public/authorize/getAuhtorizeUrl"}, method={RequestMethod.POST})
    public DataResponse getAuhtorizeUrl(@RequestBody DataRequest request) {
        WeixinAuthorizeUrl get_authorize_url;
        DataResponse response = new DataResponse();
        JSONObject data = request.getData();
        String bean_name = null;
        if (data == null || data.isEmpty()) {
            log.error("order info can not be null");
            throw new CommonException("\u8ba2\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject post_patam = data.getJSONObject("post_param");
        bean_name = post_patam.getString("method");
        if (StringUtils.isNull((Object)bean_name)) {
            bean_name = "weixinPayAuthorizeUrl";
        }
        if ((get_authorize_url = (WeixinAuthorizeUrl)SpringUtils.getBean((String)bean_name)) == null) {
            log.error("not find bean by name:" + bean_name);
            return response.setStatus(Status.FAILED).setCode("-1").setCode("\u5904\u7406\u5931\u8d25");
        }
        JSONObject result_data = null;
        try {
            result_data = get_authorize_url.getUrl(data);
        }
        catch (CommonException e) {
            log.error("get authorize url error:" + e.getLocalizedMessage(), (Throwable)e);
            return response.setStatus(Status.FAILED).setCode(e.getCode()).setMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("get authorize url error:" + e.getLocalizedMessage(), (Throwable)e);
            return response.setStatus(Status.FAILED).setCode("-1").setMsg("\u5904\u7406\u5931\u8d25");
        }
        return response.setStatus(Status.SUCCESS).setCode("0").setMsg("success").setData(result_data);
    }

    @ApiOperation(value="\u83b7\u53d6\u516c\u4f17\u4fe1\u606f", notes="{\n<br>  \"access_key\": \"string\",\n<br>  \"data\": {\"public_appid\":\"wx522b2ca5873f6b03\"},\n<br>  \"id\": \"string\",\n<br>  \"method\": \"string\",\n<br>  \"sign\": \"string\",\n<br>  \"source\": \"BIZVANE\",\n<br>  \"timestamp\": \"string\"\n<br>}")
    @RequestMapping(value={"/getInfo"}, method={RequestMethod.POST})
    public DataResponse getInfo(@RequestBody DataRequest datarequest) {
        JSONObject web_data = datarequest.getData();
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(datarequest.getId());
        if (!web_data.containsKey((Object)"public_appid") || StringUtils.isNull((Object)web_data.getString("public_appid"))) {
            dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u516c\u4f17\u53f7\u53c2\u6570\u4e0d\u5b58\u5728");
            return dataResponse;
        }
        String public_appid = web_data.getString("public_appid");
        JSONObject publicInfo = this.getWechatInfo.getPublicInfo(public_appid);
        if (publicInfo == null) {
            dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u516c\u4f17\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728");
            return dataResponse;
        }
        JSONObject response_data = new JSONObject();
        response_data.put("nick_name", (Object)publicInfo.getString("nick_name"));
        response_data.put("access_token", (Object)publicInfo.getString("authorizer_access_token"));
        dataResponse.setCode("0").setStatus(Status.SUCCESS).setMsg("success").setData(response_data);
        return dataResponse;
    }

    @RequestMapping(value={"/public/event/{appid}", "/mp/event/{appid}"}, method={RequestMethod.GET, RequestMethod.POST})
    public DataResponse doPublicEvent(@PathVariable(value="appid") String appid, HttpServletRequest request) {
        DataResponse response = new DataResponse();
        DataRequest dataRequest = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject event_jo = dataRequest.getData();
        log.debug("-----6666666:" + event_jo);
        if (event_jo == null) {
            JSONObject result_jo = new JSONObject();
            result_jo.put("message", (Object)"success");
            response.setStatus(Status.FAILED).setData(result_jo);
            return response;
        }
        if ((event_jo = this.decryptMsg(event_jo)) == null) {
            JSONObject result_jo = new JSONObject();
            result_jo.put("message", (Object)"success");
            response.setStatus(Status.FAILED).setData(result_jo);
            return response;
        }
        JSONObject reply_xml = this.networkReleaseCheck(appid, event_jo);
        if (reply_xml != null && "0".equals(reply_xml.getString("code")) && StringUtils.isNotNull((Object)reply_xml.getString("message"))) {
            JSONObject result_jo = new JSONObject();
            result_jo.put("message", (Object)"success");
            response.setStatus(Status.FAILED).setData(result_jo);
            return response;
        }
        event_jo.put("public_appid", (Object)appid);
        log.debug("-------->doPublicEvent public event:" + event_jo);
        if ("event".equals(event_jo.getString("MsgType"))) {
            String eventKey;
            if ("MASSSENDJOBFINISH".equals(event_jo.getString("Event"))) {
                String msg_id = event_jo.getString("MsgID");
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"msg_id").is((Object)msg_id));
                Update update = new Update();
                BasicDBObject update_obj = new BasicDBObject();
                for (String key : event_jo.keySet()) {
                    update_obj.put((Object)key, event_jo.get((Object)key));
                }
                update.set("result", (Object)update_obj);
                this.mongo_template.upsert(query, update, "log_wx_mass");
            } else if ("subscribe".equals(event_jo.getString("Event"))) {
                eventKey = event_jo.getString("EventKey");
                String open_id = event_jo.getString("FromUserName");
                String app_user_name = event_jo.getString("ToUserName");
                BasicDBObject fansScan = new BasicDBObject();
                fansScan.put((Object)"open_id", (Object)open_id);
                fansScan.put((Object)"app_user_name", (Object)app_user_name);
                fansScan.put((Object)"app_id", (Object)appid);
                fansScan.put((Object)"scan_time", (Object)TimeUtils.getCurrentTimeInString());
                this.mongo_template.getCollection("log_fans").save((DBObject)fansScan);
            } else if ("SCAN".equals(event_jo.getString("Event"))) {
                eventKey = event_jo.getString("EventKey");
                String open_id = event_jo.getString("FromUserName");
                String app_user_name = event_jo.getString("ToUserName");
                BasicDBObject query = new BasicDBObject();
                query.put((Object)"open_id", (Object)open_id);
                query.put((Object)"app_id", (Object)appid);
                DBObject fans = this.mongo_template.getCollection("log_fans").findOne((DBObject)query);
                if (fans == null) {
                    BasicDBObject fansScan = new BasicDBObject();
                    fansScan.put((Object)"open_id", (Object)open_id);
                    fansScan.put((Object)"app_user_name", (Object)app_user_name);
                    fansScan.put((Object)"app_id", (Object)appid);
                    fansScan.put((Object)"scan_time", (Object)TimeUtils.getCurrentTimeInString());
                    this.mongo_template.getCollection("log_fans").save((DBObject)fansScan);
                }
            } else if ("unsubscribe".equals(event_jo.getString("Event"))) {
                String open_id = event_jo.getString("FromUserName");
                BasicDBObject query = new BasicDBObject();
                query.put((Object)"open_id", (Object)open_id);
                query.put((Object)"app_id", (Object)appid);
                this.mongo_template.getCollection("log_fans").remove((DBObject)query);
            }
        } else if ("text".equals(event_jo.getString("MsgType"))) {
            // empty if block
        }
        JSONObject result_jo = new JSONObject();
        result_jo.put("message", (Object)"success");
        response.setStatus(Status.FAILED).setData(result_jo);
        return response;
    }

    private JSONObject getMesssageFromRequest(HttpServletRequest request) {
        JSONObject jo = null;
        String charset = request.getCharacterEncoding();
        charset = StringUtils.isNull((Object)charset) ? "iso8859-1" : charset;
        ServletInputStream inputStream = null;
        try {
            inputStream = request.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bis = null;
            byte[] buf = new byte[1024];
            bis = new BufferedInputStream((InputStream)inputStream);
            int len = 0;
            while ((len = bis.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            inputStream.close();
            String message = baos.toString(charset);
            String msg_signature = request.getParameter("msg_signature");
            String timestamp = request.getParameter("timestamp");
            String nonce = request.getParameter("nonce");
            String signature = request.getParameter("signature");
            String echostr = request.getParameter("echostr");
            jo = new JSONObject();
            jo.put("msg_signature", (Object)msg_signature);
            jo.put("timestamp", (Object)timestamp);
            jo.put("nonce", (Object)nonce);
            jo.put("signature", (Object)signature);
            jo.put("echostr", (Object)echostr);
            jo.put("xmlmessage", (Object)message);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("ReceiveWxEventController getMesssageFromRequest error:" + e.getMessage());
        }
        return jo;
    }

    private JSONObject decryptMsg(JSONObject message_jo) {
        JSONObject post_param = message_jo.getJSONObject("post_param");
        JSONObject get_param = message_jo.getJSONObject("get_param");
        String xmlmessage = message_jo.getString("xmlmessage");
        String encrypt = post_param.getString("Encrypt");
        String ToUserName = post_param.getString("ToUserName");
        String msg_signature = get_param.getString("msg_signature");
        String timestamp = get_param.getString("timestamp");
        String nonce = get_param.getString("nonce");
        String signature = get_param.getString("signature");
        String echostr = get_param.getString("echostr");
        JSONObject jo = null;
        try {
            JSONObject platJo = this.getWechatInfo.getOpenInfo(this.component_appid);
            this.platformManager.setDef_wx_platform(platJo);
            log.debug("------component_appid:" + this.component_appid + "," + this.platformManager.getToken());
            WXBizMsgCrypt pc = new WXBizMsgCrypt(this.platformManager.getToken(), this.platformManager.getNewEncodingAeskey(), this.component_appid);
            boolean issuccess = pc.verifyMsg(msg_signature, timestamp, nonce, encrypt);
            log.debug("-----issuccess1:" + issuccess);
            if (!issuccess) {
                pc = new WXBizMsgCrypt(this.platformManager.getToken(), this.platformManager.getOldEncodingAeskey(), this.component_appid);
                issuccess = pc.verifyMsg(msg_signature, timestamp, nonce, encrypt);
            }
            log.debug("-----issuccess2:" + issuccess);
            if (StringUtils.isNotNull((Object)echostr)) {
                try {
                    pc.verifyUrl(signature, timestamp, nonce, echostr);
                }
                catch (Exception e) {
                    log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
                    return null;
                }
            }
            String result = pc.decryptMsg(encrypt);
            log.debug("-----result:" + result);
            jo = XML.toJSONObject((String)result);
            log.debug("------jo:" + jo.toString());
        }
        catch (Exception e) {
            log.debug("999999:" + e.getLocalizedMessage());
            e.printStackTrace();
        }
        return jo;
    }

    public JSONObject networkReleaseCheck(String public_appid, JSONObject xml_jo) {
        String rxml = "";
        if ("wx570bc396a51b8ff8".equalsIgnoreCase(public_appid)) {
            String msgType = xml_jo.getString("MsgType");
            String touser = xml_jo.getString("ToUserName");
            String fromuser = xml_jo.getString("FromUserName");
            String tstr = String.valueOf(System.currentTimeMillis() / 1000L);
            String nstr = RandomStringUtils.randomAlphanumeric((int)43);
            JSONObject platJo = this.getWechatInfo.getOpenInfo(this.component_appid);
            this.platformManager.setDef_wx_platform(platJo);
            try {
                WXBizMsgCrypt pc = new WXBizMsgCrypt(this.platformManager.getToken(), this.platformManager.getNewEncodingAeskey(), this.platformManager.getAppid());
                if ("event".equalsIgnoreCase(msgType)) {
                    String resultxml = "<xml><ToUserName><![CDATA[" + fromuser + "]]></ToUserName><FromUserName><![CDATA[" + touser + "]]></FromUserName><CreateTime>" + tstr + "</CreateTime><MsgType><![CDATA[text]]></MsgType><Content><![CDATA[" + xml_jo.getString("Event") + "from_callback]]></Content></xml>";
                    rxml = pc.encryptMsg(resultxml, tstr, nstr);
                } else if ("TESTCOMPONENT_MSG_TYPE_TEXT".equalsIgnoreCase(xml_jo.getString("Content"))) {
                    String resultxml = "<xml><ToUserName><![CDATA[" + fromuser + "]]></ToUserName><FromUserName><![CDATA[" + touser + "]]></FromUserName><CreateTime>" + tstr + "</CreateTime><MsgType><![CDATA[text]]></MsgType><Content><![CDATA[TESTCOMPONENT_MSG_TYPE_TEXT_callback]]></Content></xml>";
                    rxml = pc.encryptMsg(resultxml, tstr, nstr);
                } else if (xml_jo.getString("Content").startsWith("QUERY_AUTH_CODE:")) {
                    rxml = "";
                    String contnet = xml_jo.getString("Content");
                    String authorizedcode = contnet.replace("QUERY_AUTH_CODE:", "");
                    new Thread((Runnable)new PublishThread(this, authorizedcode, fromuser)).start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return DisposeRetrunUtil.getReturnJo((String)"0", (String)rxml);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

