/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.wechat.controller.authorize;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import kr.weitao.common.exception.AesException;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.XML;
import kr.weitao.common.util.wxencrypt.WXBizMsgCrypt;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.wechat.open.GetWechatInfo;
import kr.weitao.wechat.open.PlatformManager;
import kr.weitao.wechat.service.authorize.WxAuthorize;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wechat"})
@Api(value="\u6388\u6743", description="\u5f00\u653e\u5e73\u53f0\u4fe1\u606f", tags={"wechat"})
public class WechatOpenController {
    private static final Logger log = LogManager.getLogger(WechatOpenController.class);
    @Value(value="${component.appid}")
    String component_appid;
    @Value(value="${weixin.server.domain}")
    String server_domin;
    @Autowired
    @Qualifier(value="wxAuthorizeImpl")
    WxAuthorize wx;
    @Autowired
    GetWechatInfo getWechatInfo;
    @Autowired
    PlatformManager platformManager;

    @ApiOperation(value="\u5f00\u653e\u5e73\u53f0\u6388\u6743", notes="")
    @RequestMapping(value={"/open/authorize"}, method={RequestMethod.POST})
    public DataResponse authorize(@RequestBody DataRequest request) {
        DataResponse response = new DataResponse();
        JSONObject data = request.getData();
        JSONObject get_param = data.getJSONObject("get_param");
        JSONObject post_patam = data.getJSONObject("post_param");
        String encrypt_type = get_param.getString("encrypt_type");
        String msg_signature = get_param.getString("msg_signature");
        WXBizMsgCrypt wxBizMsgCrypt = null;
        boolean isAes = "aes".equalsIgnoreCase(encrypt_type);
        if (isAes) {
            try {
                String openAppid = post_patam.getString("AppId");
                JSONObject platJo = this.getWechatInfo.getOpenInfo(openAppid);
                PlatformManager pm = new PlatformManager();
                pm.setDef_wx_platform(platJo);
                log.info("platJo:" + platJo);
                wxBizMsgCrypt = new WXBizMsgCrypt(pm.getToken(), pm.getNewEncodingAeskey(), pm.getAppid());
                log.info("PlatformManager:" + pm.toString());
            }
            catch (AesException e) {
                log.error("error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (wxBizMsgCrypt != null) {
            String signature = get_param.getString("signature");
            String timestamp = get_param.getString("timestamp");
            String nonce = get_param.getString("nonce");
            String echostr = get_param.getString("echostr");
            String data_xml = null;
            try {
                data_xml = XML.toString((Object)post_patam, (String)"xml");
                log.info("msg_signature:" + msg_signature + ",timestamp:" + timestamp + ",nonce:" + nonce + ",data_xml:" + data_xml);
                data_xml = wxBizMsgCrypt.decryptMsg(msg_signature, timestamp, nonce, data_xml);
                log.debug("data:" + data);
            }
            catch (Exception e) {
                log.error("decrypt errro:" + e.getLocalizedMessage(), (Throwable)e);
                response.setStatus(Status.FAILED).setCode("-1");
                return response;
            }
            String resultStr = null;
            try {
                resultStr = this.wx.authorize(data_xml);
            }
            catch (Exception e) {
                log.error("open event error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        response.setStatus(Status.FAILED).setCode("-1");
        return response;
    }

    @RequestMapping(value={"/open/getAuhtorizeUrl"}, method={RequestMethod.GET, RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u9884\u6388\u6743\u7801")
    @ApiImplicitParam(name="menu", value="\u8bf7\u6c42\u4f53", required=true, dataType="datarequest")
    public DataResponse getAuhtorizeUrl(@RequestBody DataRequest request) {
        DataResponse response = new DataResponse();
        DataResponse dataResponse = new DataResponse();
        JSONObject resultJo = new JSONObject();
        if (StringUtils.isNull((Object)this.component_appid)) {
            log.error("openAppid is null");
            resultJo.put("code", (Object)"-10");
            resultJo.put("message", (Object)"\u5f00\u653e\u5e73\u53f0APPID\u4e0d\u80fd\u4e3a\u7a7a");
            dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u5f00\u653e\u5e73\u53f0APPID\u4e0d\u80fd\u4e3a\u7a7a");
            return dataResponse;
        }
        try {
            String preCode = this.wx.getPreAuthorizeCode(this.component_appid);
            log.info("server_domin:" + this.server_domin);
            resultJo.put("preAuthorizeCode", (Object)preCode);
            StringBuffer auth_url = new StringBuffer("https://mp.weixin.qq.com/cgi-bin/componentloginpage?component_appid=");
            auth_url.append(this.component_appid);
            auth_url.append("&pre_auth_code=");
            auth_url.append(preCode);
            auth_url.append("&redirect_uri=");
            auth_url.append(this.server_domin);
            auth_url.append("/wechat/public/authorize/callback");
            resultJo.put("authorize_url", (Object)auth_url.toString());
            JSONObject result_data = new JSONObject();
            result_data.put("message", (Object)resultJo);
            dataResponse.setStatus(Status.SUCCESS);
            dataResponse.setCode("0");
            dataResponse.setMsg("success");
            dataResponse.setData(result_data);
        }
        catch (CommonException e) {
            log.error("get open precode error:" + e.getMessage(), (Throwable)e);
            dataResponse.setStatus(Status.FAILED);
            dataResponse.setMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("get open precode error:" + e.getLocalizedMessage(), (Throwable)e);
            dataResponse.setStatus(Status.FAILED);
            dataResponse.setMsg("\u83b7\u53d6\u9884\u6388\u6743\u7801\u5931\u8d25");
        }
        return dataResponse;
    }

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u5e73\u53f0Token")
    @RequestMapping(value={"/open/info"}, method={RequestMethod.POST})
    public DataResponse getOpenInfo(@RequestBody DataRequest dataRequest) {
        JSONObject data_jo = dataRequest.getData();
        String open_appid = data_jo.getString("open_appid");
        JSONObject platJo = this.getWechatInfo.getOpenInfo(open_appid);
        this.platformManager.setDef_wx_platform(platJo);
        JSONObject return_jo = new JSONObject();
        return_jo.put("token", (Object)this.platformManager.getToken());
        return_jo.put("new_encoding_aeskey", (Object)this.platformManager.getNewEncodingAeskey());
        return_jo.put("old_encoding_aeskey", (Object)this.platformManager.getOldEncodingAeskey());
        DataResponse dataResponse = new DataResponse();
        dataResponse.setId(dataRequest.getId()).setMsg("success").setStatus(Status.SUCCESS).setData(return_jo);
        return dataResponse;
    }
}

