/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLConverUtil {
    private static Logger logger = LoggerFactory.getLogger(XMLConverUtil.class);
    private static Map<Class<?>, Marshaller> M_MAP = new ConcurrentHashMap();
    private static Map<Class<?>, Unmarshaller> U_MAP = new ConcurrentHashMap();

    public static <T> T convertToObject(Class<T> clazz, String xml) {
        return XMLConverUtil.convertToObject(clazz, new StringReader(xml));
    }

    public static <T> T convertToObject(Class<T> clazz, InputStream inputStream) {
        return XMLConverUtil.convertToObject(clazz, new InputStreamReader(inputStream));
    }

    public static <T> T convertToObject(Class<T> clazz, InputStream inputStream, Charset charset) {
        return XMLConverUtil.convertToObject(clazz, new InputStreamReader(inputStream, charset));
    }

    public static <T> T convertToObject(Class<T> clazz, Reader reader) {
        try {
            if (!U_MAP.containsKey(clazz)) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                U_MAP.put(clazz, unmarshaller);
            }
            return (T)U_MAP.get(clazz).unmarshal(reader);
        }
        catch (JAXBException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static String convertToXML(Object object) {
        try {
            if (!M_MAP.containsKey(object.getClass())) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new CharacterEscapeHandler(){

                    public void escape(char[] ac, int i, int j, boolean flag, Writer writer) throws IOException {
                        writer.write(ac, i, j);
                    }
                });
                M_MAP.put(object.getClass(), marshaller);
            }
            StringWriter stringWriter = new StringWriter();
            M_MAP.get(object.getClass()).marshal(object, (Writer)stringWriter);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> convertToMap(String xml) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            NodeList childNodes;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader sr = new StringReader(xml);
            InputSource is = new InputSource(sr);
            Document document = db.parse(is);
            Element root = document.getDocumentElement();
            if (root != null && (childNodes = root.getChildNodes()) != null && childNodes.getLength() > 0) {
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node node = childNodes.item(i);
                    if (node == null || node.getNodeType() != 1) continue;
                    map.put(node.getNodeName(), node.getTextContent());
                }
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return map;
    }
}

