/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TimeUtils {
    private static final Logger log = LogManager.getLogger(TimeUtils.class);
    public static final SimpleDateFormat DATE_FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat DATE_FORMAT_DATE_NO = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat DATETIME_FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat DATETIME_FORMAT_DATE_NO = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final SimpleDateFormat DATETIME_FORMAT_DATE_no = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final SimpleDateFormat MONTH_FORMAT = new SimpleDateFormat("yyyyMM");
    public static final SimpleDateFormat FORMAT_DATE = new SimpleDateFormat("MMdd");
    public static final SimpleDateFormat FORMAT_MONTH = new SimpleDateFormat("MM");
    public static final SimpleDateFormat FORMAT_YEAR = new SimpleDateFormat("yyyy");

    public static String monthFirstDay(String time, SimpleDateFormat simpleDateFormat) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(MONTH_FORMAT.parse(time));
        calendar.set(5, calendar.getActualMinimum(5));
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }

    public static long getDistanceTimes(String str1, String str2) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long day = 0L;
        long hour = 0L;
        long min = 0L;
        long sec = 0L;
        try {
            Date one = df.parse(str1);
            Date two = df.parse(str2);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            hour = diff / 3600000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return hour;
    }

    public static long getDistanceTimes(String str1, String str2, String type) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long value = 0L;
        long day = 0L;
        long hour = 0L;
        long min = 0L;
        long sec = 0L;
        try {
            Date one = df.parse(str1);
            Date two = df.parse(str2);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            day = diff / 86400000L;
            hour = diff / 3600000L;
            min = diff / 60000L;
            sec = diff / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if ("day".equals(type)) {
            value = day;
        }
        if ("hour".equals(type)) {
            value = hour;
        }
        if ("min".equals(type)) {
            value = min;
        }
        if ("sec".equals(type)) {
            value = sec;
        }
        return value;
    }

    public static String monthLastDay(String time) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(MONTH_FORMAT.parse(time));
        calendar.set(5, calendar.getActualMaximum(5));
        return DATE_FORMAT_DATE_NO.format(calendar.getTime());
    }

    public static Date getLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return date;
    }

    public static Date getNextDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        date = calendar.getTime();
        return date;
    }

    public static Date getLastDate(Date date, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, i);
        return cal.getTime();
    }

    public static Date getLastDateByDay(Date date, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, i);
        return cal.getTime();
    }

    public static String getTime(long timeInMillis, SimpleDateFormat dateFormat) {
        return dateFormat.format(new Date(timeInMillis));
    }

    public static String getTime(long timeInMillis) {
        return TimeUtils.getTime(timeInMillis, DATETIME_FORMAT_DATE);
    }

    public static long getCurrentTimeInLong() {
        return System.currentTimeMillis();
    }

    public static int getCurrentYear() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        return year;
    }

    public static int getCurrentMonth() {
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2) + 1;
        return month;
    }

    public static int getCurrentDay() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(5);
        return day;
    }

    public static String getCurrentTimeInString() {
        return TimeUtils.getTime(TimeUtils.getCurrentTimeInLong());
    }

    public static String getCurrentTimeInString(SimpleDateFormat dateFormat) {
        return TimeUtils.getTime(TimeUtils.getCurrentTimeInLong(), dateFormat);
    }

    public static boolean compareDateTime(String firstStr, String secondStr, SimpleDateFormat simpleDateFormat) {
        long secondLongTime;
        Date firstDate = null;
        Date secondDate = null;
        try {
            firstDate = simpleDateFormat.parse(firstStr);
            secondDate = simpleDateFormat.parse(secondStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (firstDate == null || secondDate == null) {
            return false;
        }
        long firstLongTime = firstDate.getTime();
        return firstLongTime < (secondLongTime = secondDate.getTime());
    }

    public static String getTimeBeforDay(int beforDay, SimpleDateFormat simpleDateFormat) {
        Calendar c = Calendar.getInstance();
        int day = c.get(5) - beforDay;
        c.set(5, day);
        return simpleDateFormat.format(c.getTime());
    }

    public static String getTimeBefore(int beforDay, String date, SimpleDateFormat simpleDateFormat) throws Exception {
        Date days = simpleDateFormat.parse(date);
        Calendar c = Calendar.getInstance();
        c.setTime(days);
        int day = c.get(5) - beforDay;
        c.set(5, day);
        return simpleDateFormat.format(c.getTime());
    }

    public static String getHourAfter(double afterHour, String date, SimpleDateFormat simpleDateFormat) throws Exception {
        Date days = simpleDateFormat.parse(date);
        Calendar c = Calendar.getInstance();
        c.setTime(days);
        int a_hour = (int)Math.floor(afterHour);
        int a_min = (int)(60.0 * (afterHour - (double)a_hour));
        int hour = c.get(10) + a_hour;
        int min = c.get(12) + a_min;
        c.set(10, hour);
        c.set(12, min);
        return simpleDateFormat.format(c.getTime());
    }

    public static String getTimeBeforeByType(int before, String date, SimpleDateFormat simpleDateFormat, String type) throws Exception {
        Date days = simpleDateFormat.parse(date);
        Calendar c = Calendar.getInstance();
        c.setTime(days);
        if ("month".equals(type)) {
            c.add(2, before);
        } else if ("year".equals(type)) {
            c.add(1, before);
        }
        return simpleDateFormat.format(c.getTime());
    }

    public static int calculateDateInDay(String date1, String date2, SimpleDateFormat simpleDateFormat) throws ParseException {
        Date now = simpleDateFormat.parse(date1);
        Date date = simpleDateFormat.parse(date2);
        long l = now.getTime() - date.getTime();
        long day = l / 86400000L;
        return (int)day;
    }

    public static int calculateDateInHour(String date1, String date2, SimpleDateFormat simpleDateFormat) throws ParseException {
        Date now = simpleDateFormat.parse(date1);
        Date date = simpleDateFormat.parse(date2);
        long l = now.getTime() - date.getTime();
        long day = l / 3600000L;
        return (int)day;
    }

    public static String getWeek(String date) throws Exception {
        Date time = DATE_FORMAT_DATE.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        String monday = DATE_FORMAT_DATE.format(cal.getTime());
        cal.add(5, 1);
        String tuesday = DATE_FORMAT_DATE.format(cal.getTime());
        cal.add(5, 1);
        String wednesday = DATE_FORMAT_DATE.format(cal.getTime());
        cal.add(5, 1);
        String thursday = DATE_FORMAT_DATE.format(cal.getTime());
        cal.add(5, 1);
        String friday = DATE_FORMAT_DATE.format(cal.getTime());
        cal.add(5, 1);
        String saturday = DATE_FORMAT_DATE.format(cal.getTime());
        cal.add(5, 1);
        String sunday = DATE_FORMAT_DATE.format(cal.getTime());
        return monday + "," + tuesday + "," + wednesday + "," + thursday + "," + friday + "," + saturday + "," + sunday;
    }

    public static int dayForWeek(String date) throws Exception {
        Date time = DATE_FORMAT_DATE.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int dayForWeek = 0;
        dayForWeek = cal.get(7) == 1 ? 7 : cal.get(7) - 1;
        return dayForWeek;
    }

    public static int dayForWeek_(String pTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        try {
            c.setTime(format.parse(pTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int dayForWeek = 0;
        dayForWeek = c.get(7) == 1 ? 7 : c.get(7) - 1;
        return dayForWeek - 1;
    }

    public static Map getFirstday_Lastday_Month(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        Date theDate = calendar.getTime();
        GregorianCalendar gcLast = (GregorianCalendar)Calendar.getInstance();
        gcLast.setTime(theDate);
        gcLast.set(5, 1);
        String day_first = df.format(gcLast.getTime());
        StringBuffer str = new StringBuffer().append(day_first).append(" 00:00:00");
        day_first = str.toString();
        calendar.add(2, 2);
        calendar.set(5, 1);
        calendar.add(5, -1);
        String day_last = df.format(calendar.getTime());
        StringBuffer endStr = new StringBuffer().append(day_last);
        day_last = endStr.toString();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", day_first);
        map.put("last", day_last);
        return map;
    }

    public static String getLastDateByDate(String getDate) {
        String last = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String str = getDate;
            Date date = df.parse(str);
            Map map = TimeUtils.getFirstday_Lastday_Month(date);
            last = map.get("last").toString();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return last;
    }

    private static Date getMonthStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int index = calendar.get(5);
        calendar.add(5, 1 - index);
        return calendar.getTime();
    }

    private static Date getMonthEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        int index = calendar.get(5);
        calendar.add(5, -index);
        return calendar.getTime();
    }

    public static List<String> getMonthAllDays(String getDate) {
        ArrayList<String> dateList = new ArrayList<String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String str = getDate;
            Date d = sdf.parse(str);
            Date date = TimeUtils.getMonthStart(d);
            Date monthEnd = TimeUtils.getMonthEnd(d);
            while (!date.after(monthEnd)) {
                dateList.add(sdf.format(date));
                date = TimeUtils.getNextDay(date);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return dateList;
    }

    public static List<String> getDates(Calendar p_start, Calendar p_end, String type) {
        ArrayList<String> result = new ArrayList<String>();
        Calendar temp = p_start;
        p_end.add(6, 1);
        while (temp.before(p_end)) {
            result.add(DATE_FORMAT_DATE.format(temp.getTime()));
            if ("month".equals(type)) {
                temp.add(2, 1);
                continue;
            }
            temp.add(6, 1);
        }
        return result;
    }

    public static List<String> getDaysByTwoDate(String startDate, String endDate, String type) {
        List<String> dates = new ArrayList<String>();
        try {
            GregorianCalendar dayc1 = new GregorianCalendar();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date daystart = df.parse(startDate);
            dayc1.setTime(daystart);
            GregorianCalendar dayc2 = new GregorianCalendar();
            Date dayend = df.parse(endDate);
            dayc2.setTime(dayend);
            ((Calendar)dayc2).add(2, 0);
            dates = TimeUtils.getDates(dayc1, dayc2, type);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return dates;
    }

    public static int getYearWeek(String time) throws ParseException {
        Calendar ca = Calendar.getInstance();
        SimpleDateFormat dsf = new SimpleDateFormat("yyyyMMdd");
        Date date = dsf.parse(time);
        ca.setTime(date);
        String year = time.substring(0, 4);
        String startDate = year + "0101";
        Date date1 = dsf.parse(startDate);
        Calendar ca1 = Calendar.getInstance();
        ca1.setTime(date1);
        String NextstartDate = Integer.parseInt(year) + 1 + "0101";
        Date date2 = dsf.parse(NextstartDate);
        Calendar ca2 = Calendar.getInstance();
        ca2.setTime(date2);
        int weekDay = ca1.get(7);
        int nextWeekDay = ca2.get(7);
        int days = ca.get(6);
        int intervalDays = 7 - (weekDay - 2);
        int okDay = weekDay - 1;
        int koDay = nextWeekDay - 1;
        if (intervalDays == 8) {
            intervalDays = 1;
        }
        if (okDay == 0) {
            okDay = 7;
        }
        if (koDay == 0) {
            koDay = 7;
        }
        if (okDay > 4) {
            if (days - intervalDays <= 0) {
                return TimeUtils.getYearWeek(Integer.parseInt(year) - 1 + "1231");
            }
            if (ca.get(3) == 1) {
                if (koDay >= 4) {
                    return 1;
                }
                return (days - intervalDays - 1) / 7 + 1;
            }
            return (days - intervalDays - 1) / 7 + 1;
        }
        if (days - intervalDays <= 0) {
            return 1;
        }
        if (ca.get(3) == 1) {
            if (koDay >= 4) {
                return (days - intervalDays - 1) / 7 + 2;
            }
            return 1;
        }
        return (days - intervalDays - 1) / 7 + 2;
    }

    public static String convertTime(String time) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setMinimalDaysInFirstWeek(7);
        c.setTime(format.parse(time));
        String a_time_Y = String.valueOf(c.get(1));
        String a_time_W = TimeUtils.getYearWeek(time) >= 10 ? String.valueOf(TimeUtils.getYearWeek(time)) : "0" + String.valueOf(TimeUtils.getYearWeek(time));
        String a_time_M = c.get(2) >= 9 ? String.valueOf(c.get(2) + 1) : "0" + String.valueOf(c.get(2) + 1);
        String a_time_D = time.substring(6);
        return a_time_Y + "," + a_time_M + "," + a_time_W + "," + a_time_D;
    }

    public static boolean timeRange(String start_time, String end_time) throws Exception {
        long time = System.currentTimeMillis();
        boolean is_ture = false;
        if (StringUtils.isNull(start_time)) {
            return is_ture;
        }
        if (StringUtils.isNull(end_time)) {
            is_ture = time >= DATETIME_FORMAT_DATE.parse(start_time).getTime();
            return is_ture;
        }
        is_ture = time >= DATETIME_FORMAT_DATE.parse(start_time).getTime() && time <= DATETIME_FORMAT_DATE.parse(end_time).getTime();
        return is_ture;
    }

    public static boolean isTheDay(String day) {
        String time;
        return (day = day.substring(4)).equals(time = TimeUtils.getCurrentTimeInString(FORMAT_DATE));
    }

    public static boolean isTheMonth(String day) {
        String time = TimeUtils.getCurrentTimeInString(FORMAT_MONTH);
        return (day = day.substring(4, 6)).equals(time);
    }

    public static boolean BTheYear(String day) {
        String time = TimeUtils.getCurrentTimeInString(FORMAT_YEAR);
        return Integer.parseInt(time) > Integer.parseInt(day);
    }

    public static String getBeforeTime(int i) {
        Date date = new Date();
        Calendar dar = Calendar.getInstance();
        dar.setTime(date);
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dar.add(11, i);
        return dft.format(dar.getTime());
    }

    public static void main(String[] args) throws Exception {
        long a = 1539745006L;
        System.out.println(TimeUtils.getTime(a * 1000L));
    }

    public static LocalDateTime parse(String date_time_str, String format) {
        LocalDateTime ldt = null;
        if (StringUtils.isNull(date_time_str)) {
            return ldt;
        }
        if (StringUtils.isNull(format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        ldt = LocalDateTime.parse(date_time_str, DateTimeFormatter.ofPattern(format));
        return ldt;
    }

    public static String getCron(Date date) {
        String dateFormat = "ss mm HH dd MM ? yyyy";
        return TimeUtils.formatDateByPattern(date, dateFormat);
    }

    public static LocalDate parse(String date_str) {
        LocalDate ld = null;
        try {
            ld = LocalDate.parse(date_str);
        }
        catch (Exception e) {
            log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("\u65f6\u95f4\u8f6c\u6362\u5931\u8d25");
        }
        return ld;
    }

    public static String getWeekOfYear(String date_str) {
        int week = 0;
        if (StringUtils.isNull(date_str)) {
            throw new CommonException("\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date date = null;
        try {
            date = DATE_FORMAT_DATE.parse(date_str);
        }
        catch (Exception e) {
            log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("\u65f6\u95f4\u683c\u5f0f\u6709\u8bef");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        week = calendar.get(3);
        String week_no = null;
        week_no = week < 10 ? "0" + week : week + "";
        int year = calendar.getWeekYear();
        return year + "-" + week_no;
    }
}

