/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import kr.weitao.common.util.HttpClient;
import okhttp3.Response;

public class TecentMapUtils {
    private static double EARTH_RADIUS = 6378.137;
    private static String TecentMap_AK = "AARBZ-SGZCP-GGLD3-V7VZI-3S5H6-H6B7R";
    private static String TecentMap_SK = "qo3WjnzPo3nPPvmoxnJsUjYJFjRgnCT";
    private static String TecentMap_Url = "https://apis.map.qq.com";

    public JSONObject GeoCoords(String coords) {
        HttpClient httpClient = new HttpClient();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("get_poi", "0");
        map.put("key", TecentMap_AK);
        map.put("location", coords);
        JSONObject object = null;
        try {
            String paramsStr = TecentMapUtils.toQueryString(map);
            String wholeStr = new String("/ws/geocoder/v1/?" + paramsStr);
            String sn = TecentMapUtils.MD5(wholeStr + TecentMap_SK);
            String url = TecentMap_Url + wholeStr + "&sn=" + sn;
            Response result = httpClient.get(url);
            String returns = result.body().string();
            object = JSONObject.parseObject((String)returns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    public String getAddress(String address) {
        HttpClient httpClient = new HttpClient();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("key", TecentMap_AK);
        map.put("address", address);
        String latLng = "";
        JSONObject object = null;
        try {
            JSONObject result1;
            String paramsStr = TecentMapUtils.toQueryString(map);
            String wholeStr = new String("/ws/geocoder/v1/?" + paramsStr);
            String sn = TecentMapUtils.MD5(wholeStr + TecentMap_SK);
            String url = TecentMap_Url + wholeStr + "&sn=" + sn;
            Response result = httpClient.get(url);
            String returns = result.body().string();
            object = JSONObject.parseObject((String)returns);
            if (object != null && null != object.getJSONObject("result") && (result1 = object.getJSONObject("result")).containsKey((Object)"location")) {
                JSONObject location = result1.getJSONObject("location");
                latLng = location.getString("lat") + "," + location.getString("lng");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return latLng;
    }

    public JSONObject getCityList() {
        HttpClient httpClient = new HttpClient();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("key", TecentMap_AK);
        JSONObject object = null;
        try {
            String paramsStr = TecentMapUtils.toQueryString(map);
            String wholeStr = new String("/ws/district/v1/list?" + paramsStr);
            String sn = TecentMapUtils.MD5(wholeStr + TecentMap_SK);
            String url = TecentMap_Url + wholeStr + "&sn=" + sn;
            Response result = httpClient.get(url);
            String returns = result.body().string();
            object = JSONObject.parseObject((String)returns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    public JSONObject getDistance(String from, String to) {
        HttpClient httpClient = new HttpClient();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("key", TecentMap_AK);
        map.put("mode", "driving");
        map.put("from", from);
        map.put("to", to);
        JSONObject object = null;
        try {
            String paramsStr = TecentMapUtils.toQueryString(map);
            String wholeStr = new String("/ws/distance/v1/?" + paramsStr);
            String sn = TecentMapUtils.MD5(wholeStr + TecentMap_SK);
            String url = TecentMap_Url + wholeStr + "&sn=" + sn;
            Response result = httpClient.get(url);
            String returns = result.body().string();
            object = JSONObject.parseObject((String)returns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    public static String toQueryString(Map<?, ?> data) throws UnsupportedEncodingException {
        StringBuffer queryString = new StringBuffer();
        for (Map.Entry<?, ?> pair : data.entrySet()) {
            queryString.append(pair.getKey() + "=");
            queryString.append(URLEncoder.encode((String)pair.getValue(), "UTF-8") + "&");
        }
        if (queryString.length() > 0) {
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    public static String MD5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        TecentMapUtils tecentMapUtils = new TecentMapUtils();
        System.out.println("======" + tecentMapUtils.getDistance("31.99226,118.7787", "31.98488,118.79867;31.97758,118.74806"));
    }
}

