/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import kr.weitao.common.util.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestUtils {
    private static final Logger log = LogManager.getLogger(RestUtils.class);
    private static final int TIME_OUT = 6000;

    public static String sendRequest(String apiURL, Map<String, String> params, String method) throws Exception {
        String queryString = null == params ? "" : RestUtils.delimit(params.entrySet(), true);
        return RestUtils.sendRequest_buff(apiURL, queryString, method);
    }

    public static String sendRequest_buff(String apiURL, String params, String method) throws Exception {
        return RestUtils.sendRequest_buff(apiURL, params, method, false);
    }

    public static String sendRequest_buff(String apiURL, String params, String method, boolean keepAlive) throws Exception {
        log.info("url->" + apiURL);
        Authenticator.setDefault(new MyAuthenticator());
        if (StringUtils.isNotNull(params)) {
            log.info("params :" + (params.length() > 3000 ? params.substring(0, 3000) : params));
        }
        method = StringUtils.valueOf(method, "POST");
        HttpURLConnection conn = (HttpURLConnection)new URL(apiURL).openConnection();
        conn.setRequestMethod(method.toUpperCase());
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        if (keepAlive) {
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setConnectTimeout(180000);
        } else {
            conn.setConnectTimeout(6000);
        }
        conn.setDoInput(true);
        if ("post".equalsIgnoreCase(method)) {
            conn.setUseCaches(false);
        }
        if (StringUtils.isNotNull(params)) {
            conn.setDoOutput(true);
            conn.getOutputStream().write(params.getBytes("utf-8"));
        }
        conn.connect();
        if (conn.getResponseCode() != 200) {
            log.error("server status->" + conn.getResponseCode());
            throw new Exception("\u8bf7\u6c42url\u5931\u8d25");
        }
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        bis = new BufferedInputStream(conn.getInputStream());
        int len = 0;
        while ((len = bis.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        String charset = RestUtils.getChareset(conn.getContentType());
        String resultString = baos.toString(charset);
        conn.disconnect();
        return resultString;
    }

    public static String getChareset(String contentType) {
        int i = contentType == null ? -1 : contentType.indexOf("charset=");
        return i == -1 ? "UTF-8" : contentType.substring(i + 8);
    }

    public static String delimit(Collection<Map.Entry<String, String>> entries, boolean doEncode) throws UnsupportedEncodingException {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        boolean notFirst = false;
        for (Map.Entry<String, String> entry : entries) {
            if (notFirst) {
                buffer.append("&");
            } else {
                notFirst = true;
            }
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            buffer.append(doEncode ? URLEncoder.encode(entry.getKey(), "UTF8") : entry.getKey()).append("=").append((Object)(doEncode ? URLEncoder.encode(value.toString(), "UTF8") : value));
        }
        return buffer.toString();
    }

    public static String sendRequest(String apiURL, Map<String, String> params, String method, File file) throws Exception {
        if (file == null || !file.exists()) {
            throw new Exception("file is not exists!");
        }
        String queryString = null == params ? "" : RestUtils.delimit(params.entrySet(), true);
        return RestUtils.sendRequest_buff(apiURL, queryString, method, new FileInputStream(file), file.length(), file.getName(), new MimetypesFileTypeMap().getContentType(file));
    }

    public static String sendRequest_buff(String apiURL, String params, String method, InputStream in, long file_length, String file_name, String contentType) throws Exception {
        String line;
        int bytes;
        String boundary = "----------" + System.currentTimeMillis();
        HttpURLConnection conn = (HttpURLConnection)new URL(apiURL).openConnection();
        conn.setRequestMethod(method);
        conn.setConnectTimeout(6000);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestMethod(method);
        conn.setUseCaches(false);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        if (StringUtils.isNotNull(params)) {
            conn.getOutputStream().write(params.getBytes("utf-8"));
        }
        conn.connect();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("--").append(boundary).append("\r\n");
        strBuf.append("Content-Disposition: form-data; name=\"media\"; filelength=\"" + file_length + "\"; filename=\"" + file_name + "\"\r\n");
        strBuf.append("Content-Type:" + contentType + "\r\n\r\n");
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        ((OutputStream)out).write(strBuf.toString().getBytes("utf-8"));
        byte[] bufferOut = new byte[1024];
        while ((bytes = in.read(bufferOut)) != -1) {
            ((OutputStream)out).write(bufferOut, 0, bytes);
        }
        in.close();
        ((OutputStream)out).write(("\r\n--" + boundary + "--\r\n").getBytes("utf-8"));
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        conn.disconnect();
        if (conn.getResponseCode() != 200) {
            log.error("server status->" + conn.getResponseCode());
            throw new Exception("\u8bf7\u6c42url\u5931\u8d25");
        }
        String charset = RestUtils.getChareset(conn.getContentType());
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        reader.close();
        conn.disconnect();
        log.info("RestUtils result-->" + buffer.toString());
        return buffer.toString();
    }

    private static String toCustomString(Map ht) {
        String LINE_SEPARATOR = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        for (Object key : ht.keySet()) {
            Object v = ht.get(key);
            if (v == null) {
                buf.append(key + ":=" + null + LINE_SEPARATOR);
                break;
            }
            if (v instanceof Collection) {
                v = RestUtils.toString(((Collection)v).toArray());
            } else if (v.getClass().isArray()) {
                v = RestUtils.toString((Object[])v);
            }
            buf.append(key + ":=" + v + LINE_SEPARATOR);
        }
        return buf.toString();
    }

    public static String toString(Object[] s) {
        try {
            if (s == null || s.length == 0) {
                return "null";
            }
            if (s.length == 1) {
                return s[0] + "";
            }
            String ret = "";
            for (int i = 0; i < s.length - 1; ++i) {
                if (s[i].getClass().isArray()) {
                    ret = ret + RestUtils.toString((Object[])s[i]) + ",";
                }
                ret = ret + s[i] + ",";
            }
            ret = ret + s[s.length - 1];
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "internal error";
        }
    }

    static class MyAuthenticator
    extends Authenticator {
        MyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String username = "guest";
            String password = "guest";
            return new PasswordAuthentication(username, password.toCharArray());
        }
    }
}

