/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadExcelUtils {
    private Logger logger = LoggerFactory.getLogger(ReadExcelUtils.class);
    private Workbook wb;
    private Sheet sheet;
    private Row row;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadExcelUtils(String filepath) {
        if (filepath == null) {
            return;
        }
        String ext = filepath.substring(filepath.lastIndexOf("."));
        FileInputStream is = null;
        try {
            is = new FileInputStream(filepath);
            this.wb = ".xls".equals(ext) ? new HSSFWorkbook((InputStream)is) : (".xlsx".equals(ext) ? new XSSFWorkbook((InputStream)is) : null);
        }
        catch (FileNotFoundException e) {
            this.logger.error("FileNotFoundException", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("IOException", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public String[] readExcelTitle() throws Exception {
        if (this.wb == null) {
            throw new Exception("Workbook\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        this.sheet = this.wb.getSheetAt(0);
        this.row = this.sheet.getRow(0);
        int colNum = this.row.getPhysicalNumberOfCells();
        System.out.println("colNum:" + colNum);
        String[] title = new String[colNum];
        for (int i = 0; i < colNum; ++i) {
            title[i] = this.row.getCell(i).getCellFormula();
        }
        return title;
    }

    public Map<Integer, Map<Integer, Object>> readExcelContent() throws Exception {
        if (this.wb == null) {
            throw new Exception("Workbook\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        HashMap<Integer, Map<Integer, Object>> content = new HashMap<Integer, Map<Integer, Object>>();
        this.sheet = this.wb.getSheetAt(0);
        int rowNum = this.sheet.getLastRowNum();
        this.row = this.sheet.getRow(0);
        int colNum = this.row.getPhysicalNumberOfCells();
        for (int i = 1; i <= rowNum; ++i) {
            this.row = this.sheet.getRow(i);
            HashMap<Integer, Object> cellValue = new HashMap<Integer, Object>();
            for (int j = 0; j < colNum; ++j) {
                Object obj = this.getCellFormatValue(this.row.getCell(j));
                cellValue.put(j, obj);
            }
            content.put(i, cellValue);
        }
        return content;
    }

    private Object getCellFormatValue(Cell cell) {
        Object cellvalue = "";
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: 
                case 2: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        cellvalue = date;
                        break;
                    }
                    cellvalue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    cellvalue = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    cellvalue = "";
                    break;
                }
            }
        } else {
            cellvalue = "";
        }
        return cellvalue;
    }

    public static void main(String[] args) {
        try {
            String filepath = "/Users/maoweidong/livingData/\u5de5\u4f5c\u7c3f1.xlsx";
            ReadExcelUtils excelReader = new ReadExcelUtils(filepath);
            Map<Integer, Map<Integer, Object>> map = excelReader.readExcelContent();
            System.out.println("\u83b7\u5f97Excel\u8868\u683c\u7684\u5185\u5bb9:");
            if (map.get(1).get(79).toString().contains("E")) {
                BigDecimal bd = new BigDecimal(map.get(1).get(79).toString());
                String str = bd.toPlainString();
                System.out.println(str);
            }
            System.out.println(map.get(1).get(79).toString());
        }
        catch (FileNotFoundException e) {
            System.out.println("\u672a\u627e\u5230\u6307\u5b9a\u8def\u5f84\u7684\u6587\u4ef6!");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

