/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.weitao.common.util.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NumberUtil {
    private static final Logger log = LogManager.getLogger(NumberUtil.class);

    public static String keepPrecision(String number, int precision) {
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)number)) {
            if (!NumberUtil.isNumeric(number) && !NumberUtil.isNumeric2(number)) {
                number = "0";
            }
            BigDecimal bg = new BigDecimal(number);
            return bg.setScale(precision, 4).toPlainString();
        }
        return "0";
    }

    public static String keepPrecision(String number) {
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)number)) {
            if (!NumberUtil.isNumeric(number) && !NumberUtil.isNumeric2(number)) {
                number = "0";
            }
            BigDecimal bg = new BigDecimal(number);
            return bg.setScale(2, 4).toPlainString();
        }
        return "0";
    }

    public static String keepPrecision(Number number, int precision) {
        return NumberUtil.keepPrecision(String.valueOf(number), precision);
    }

    public static String keepPrecision(double number, int precision) {
        BigDecimal bg = BigDecimal.valueOf(number);
        return bg.setScale(precision, 4).toPlainString();
    }

    public static String keepPrecision(double number) {
        BigDecimal bg = BigDecimal.valueOf(number);
        return bg.setScale(2, 4).toPlainString();
    }

    public static double round(Object number, int precision) {
        BigDecimal bg = null;
        try {
            bg = new BigDecimal(StringUtils.valueOf(number));
        }
        catch (Exception e) {
            log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            return 0.0;
        }
        return bg.setScale(precision, 4).doubleValue();
    }

    public static double round(String number, int precision) {
        BigDecimal bg = new BigDecimal(number);
        return bg.setScale(precision, 4).doubleValue();
    }

    public static double round(double number, int precision) {
        BigDecimal bg = BigDecimal.valueOf(number);
        return bg.setScale(precision, 4).doubleValue();
    }

    public static double round(double number) {
        BigDecimal bg = BigDecimal.valueOf(number);
        return bg.setScale(2, 4).doubleValue();
    }

    public static float keepPrecision(float number, int precision) {
        BigDecimal bg = BigDecimal.valueOf(number);
        return bg.setScale(precision, 4).floatValue();
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isNumeric2(String str) {
        Pattern pattern = Pattern.compile("-?[0-9]+.?[0-9]+");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static int getInt(Object value, int default_value) {
        if (value == null) {
            return default_value;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return default_value;
            }
            try {
                return Integer.parseInt(strVal);
            }
            catch (Exception e) {
                log.error("parseInt error:" + e.getLocalizedMessage(), (Throwable)e);
                return default_value;
            }
        }
        return default_value;
    }
}

