/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.Sheet;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class LuploadHelper {
    public static File lupload(HttpServletRequest request, MultipartFile file) {
        String path = request.getSession().getServletContext().getRealPath("lupload");
        String fileName = file.getOriginalFilename();
        System.out.println(path);
        File targetFile = new File(path, fileName);
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        try {
            file.transferTo(targetFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return targetFile;
    }

    public static File lupload2_zip(HttpServletRequest request, MultipartFile file) {
        String path = request.getSession().getServletContext().getRealPath("lupload");
        String fileName = file.getOriginalFilename();
        System.out.println(path);
        File targetFile = new File(path, fileName);
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        try {
            file.transferTo(targetFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return targetFile;
    }

    public static String CheckOnly(Cell[] cells) {
        String result = "0";
        int cellCount = 0;
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (Cell cell : cells) {
            if (cell.getContents().toString().trim().equals("")) continue;
            Integer num = (Integer)map.get(cell.getContents().toString().trim());
            num = null == num ? 1 : num + 1;
            map.put(cell.getContents().toString().trim(), num);
            ++cellCount;
        }
        if (cellCount != map.size()) {
            result = "1";
        }
        return result;
    }

    public static JSONObject getRepeatValue(Cell[] cells) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        JSONObject object = new JSONObject();
        for (int i = 0; i < cells.length; ++i) {
            Cell cell = cells[i];
            String key = cell.getContents().toString().trim();
            if (key.equals("")) continue;
            String value = i + "";
            if (map.containsKey(key)) {
                value = ((String)map.get(key)).toString();
                object.put(key, (Object)(value + "," + i));
            }
            map.put(key, value);
        }
        return object;
    }

    public static String CheckStringOnly(String[] strs) {
        String result = "";
        int strCount = 0;
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (String str : strs) {
            if (str.trim().equals("")) continue;
            Integer num = (Integer)map.get(str.trim());
            num = null == num ? 1 : num + 1;
            map.put(str.trim(), num);
            ++strCount;
        }
        if (strCount != map.size()) {
            result = "\u5b58\u5728\u91cd\u590d\u503c";
        }
        return result;
    }

    public static String checkDate(String date) {
        String el = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)";
        Pattern p = Pattern.compile(el);
        Matcher m = p.matcher(date);
        boolean b = m.matches();
        if (b) {
            return date;
        }
        return "\u5bfc\u5165\u683c\u5f0f\u9519\u8bef";
    }

    public static String getCellTypeForDate(Cell cellObject, String target_type) {
        String dateStr = "\u683c\u5f0f\u9519\u8bef";
        if (cellObject.getContents().toString().trim().equals("")) {
            dateStr = "";
        } else if (cellObject.getType() == CellType.DATE) {
            DateCell cellValue = (DateCell)cellObject;
            Date dt = cellValue.getDate();
            SimpleDateFormat formatter = null;
            formatter = target_type.equals("Y") ? new SimpleDateFormat("yyyy") : (target_type.equals("M") ? new SimpleDateFormat("yyyy-MM") : new SimpleDateFormat("yyyy-MM-dd"));
            dateStr = formatter.format(dt);
        } else {
            dateStr = cellObject.getContents().toString().trim();
        }
        return dateStr;
    }

    public static int getRightRows(Sheet sheet) {
        int rsRows;
        int rsCols = sheet.getColumns();
        int afterRows = rsRows = sheet.getRows();
        for (int i = 1; i < rsRows; ++i) {
            int nullCellNum = 0;
            for (int j = 0; j < rsCols; ++j) {
                String val = sheet.getCell(0, i).getContents().toString().trim();
                if (!StringUtils.isBlank((String)(val = StringUtils.trimToEmpty((String)val)))) continue;
                ++nullCellNum;
            }
            if (nullCellNum < rsCols) continue;
            --afterRows;
        }
        return afterRows;
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                System.out.println("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u6210\u529f\uff01");
                return true;
            }
            System.out.println("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u5931\u8d25\uff01");
            return false;
        }
        System.out.println("\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u5931\u8d25\uff1a" + fileName + "\u4e0d\u5b58\u5728\uff01");
        return false;
    }

    public static boolean deleteDirectory(String dir) {
        File dirFile;
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(dirFile = new File(dir)).exists() || !dirFile.isDirectory()) {
            System.out.println("\u5220\u9664\u76ee\u5f55\u5931\u8d25\uff1a" + dir + "\u4e0d\u5b58\u5728\uff01");
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = LuploadHelper.deleteFile(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = LuploadHelper.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            System.out.println("\u5220\u9664\u76ee\u5f55\u5931\u8d25\uff01");
            return false;
        }
        if (dirFile.delete()) {
            System.out.println("\u5220\u9664\u76ee\u5f55" + dir + "\u6210\u529f\uff01");
            return true;
        }
        return false;
    }
}

