/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFuture;

public class KafkaUtil {
    public static final String SUCCESS_CODE = "00000";
    public static final String SUCCESS_MES = "\u6210\u529f";
    public static final String KAFKA_SEND_ERROR_CODE = "30001";
    public static final String KAFKA_NO_RESULT_CODE = "30002";
    public static final String KAFKA_NO_OFFSET_CODE = "30003";
    public static final String KAFKA_SEND_ERROR_MES = "\u53d1\u9001\u6d88\u606f\u8d85\u65f6,\u8054\u7cfb\u76f8\u5173\u6280\u672f\u4eba\u5458";
    public static final String KAFKA_NO_RESULT_MES = "\u672a\u67e5\u8be2\u5230\u8fd4\u56de\u7ed3\u679c,\u8054\u7cfb\u76f8\u5173\u6280\u672f\u4eba\u5458";
    public static final String KAFKA_NO_OFFSET_MES = "\u672a\u67e5\u5230\u8fd4\u56de\u6570\u636e\u7684offset,\u8054\u7cfb\u76f8\u5173\u6280\u672f\u4eba\u5458";

    public static Map<String, Object> checkKafkaRecord(ListenableFuture<SendResult<String, String>> res) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (res != null) {
            try {
                SendResult r = (SendResult)res.get();
                Long offsetIndex = r.getRecordMetadata().offset();
                if (offsetIndex != null && offsetIndex >= 0L) {
                    m.put("code", SUCCESS_CODE);
                    m.put("message", SUCCESS_MES);
                    return m;
                }
                m.put("code", KAFKA_NO_OFFSET_CODE);
                m.put("message", KAFKA_NO_OFFSET_MES);
                return m;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                m.put("code", KAFKA_SEND_ERROR_CODE);
                m.put("message", KAFKA_SEND_ERROR_MES);
                return m;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                m.put("code", KAFKA_SEND_ERROR_CODE);
                m.put("message", KAFKA_SEND_ERROR_MES);
                return m;
            }
        }
        m.put("code", KAFKA_NO_RESULT_CODE);
        m.put("message", KAFKA_NO_RESULT_MES);
        return m;
    }
}

