/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class JSONArraySortUtil {
    public static JSONArray sortDesc(JSONArray jsonArray, final String key) {
        Collections.sort(jsonArray, new Comparator<Object>(){
            private String KEY_NAME;
            {
                this.KEY_NAME = key;
            }

            @Override
            public int compare(Object a, Object b) {
                String valA = new String();
                String valB = new String();
                try {
                    valA = ((JSONObject)a).getString(this.KEY_NAME);
                    valB = ((JSONObject)b).getString(this.KEY_NAME);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return valB.compareTo(valA);
            }
        });
        return jsonArray;
    }

    public static JSONArray sortAesc(JSONArray jsonArray, final String key) {
        Collections.sort(jsonArray, new Comparator<Object>(){
            private String KEY_NAME;
            {
                this.KEY_NAME = key;
            }

            @Override
            public int compare(Object a, Object b) {
                String valA = new String();
                String valB = new String();
                try {
                    valA = ((JSONObject)a).getString(this.KEY_NAME);
                    valB = ((JSONObject)b).getString(this.KEY_NAME);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return valA.compareTo(valB);
            }
        });
        return jsonArray;
    }

    public static JSONArray sortDesc(JSONArray jsonArray, final String key, String type) {
        int i;
        JSONArray sortedJsonArray = new JSONArray();
        JSONArray jsonArr = JSONArray.parseArray((String)jsonArray.toJSONString());
        ArrayList<JSONObject> jsonValues = new ArrayList<JSONObject>();
        for (i = 0; i < jsonArr.size(); ++i) {
            jsonValues.add(jsonArr.getJSONObject(i));
        }
        Collections.sort(jsonValues, new Comparator<JSONObject>(){
            private String KEY_NAME;
            {
                this.KEY_NAME = key;
            }

            @Override
            public int compare(JSONObject a, JSONObject b) {
                Double valA = 0.0;
                Double valB = 0.0;
                try {
                    valA = a.getDouble(this.KEY_NAME);
                    valB = b.getDouble(this.KEY_NAME);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return valB.compareTo(valA);
            }
        });
        for (i = 0; i < jsonArr.size(); ++i) {
            sortedJsonArray.add(jsonValues.get(i));
        }
        return sortedJsonArray;
    }

    public static JSONArray sortAesc(JSONArray jsonArray, final String key, String type) {
        int i;
        JSONArray sortedJsonArray = new JSONArray();
        ArrayList<JSONObject> jsonValues = new ArrayList<JSONObject>();
        for (i = 0; i < jsonArray.size(); ++i) {
            jsonValues.add(jsonArray.getJSONObject(i));
        }
        Collections.sort(jsonValues, new Comparator<JSONObject>(){
            private String KEY_NAME;
            {
                this.KEY_NAME = key;
            }

            @Override
            public int compare(JSONObject a, JSONObject b) {
                Double valA = 0.0;
                Double valB = 0.0;
                try {
                    valA = a.getDouble(this.KEY_NAME);
                    valB = b.getDouble(this.KEY_NAME);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return valA.compareTo(valB);
            }
        });
        for (i = 0; i < jsonArray.size(); ++i) {
            sortedJsonArray.add(jsonValues.get(i));
        }
        return sortedJsonArray;
    }

    public static JSONArray jsonArraysortTwo(JSONArray jsonArray, final String key, String type) {
        int i;
        JSONArray sortedJsonArray = new JSONArray();
        JSONArray jsonArr = JSONArray.parseArray((String)jsonArray.toJSONString());
        ArrayList<JSONObject> jsonValues = new ArrayList<JSONObject>();
        for (i = 0; i < jsonArr.size(); ++i) {
            jsonValues.add(jsonArr.getJSONObject(i));
        }
        Collections.sort(jsonValues, new Comparator<JSONObject>(){
            private String KEY_NAME;
            {
                this.KEY_NAME = key;
            }

            @Override
            public int compare(JSONObject a, JSONObject b) {
                Double valA = 0.0;
                Double valB = 0.0;
                try {
                    String vala = a.getString(this.KEY_NAME);
                    vala = vala.contains("\u4ee5\u4e0a") ? vala.substring(0, vala.indexOf("\u4ee5")) : vala.substring(0, vala.indexOf("-"));
                    String valb = b.getString(this.KEY_NAME);
                    valb = valb.contains("\u4ee5\u4e0a") ? valb.substring(0, valb.indexOf("\u4ee5")) : valb.substring(0, valb.indexOf("-"));
                    valA = Double.valueOf(vala);
                    valB = Double.valueOf(valb);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return valB.compareTo(valA);
            }
        });
        for (i = 0; i < jsonArr.size(); ++i) {
            sortedJsonArray.add(jsonValues.get(i));
        }
        return sortedJsonArray;
    }

    public static int bisectionSearch(int value, int[] array) {
        int minIndex = 0;
        int curIndex = 0;
        int maxIndex = array.length - 1;
        int count = 0;
        int result = -1;
        if (value == array[maxIndex]) {
            result = maxIndex;
        } else if (value == array[minIndex]) {
            result = minIndex;
        } else {
            while (true) {
                if (2 > maxIndex - minIndex) {
                    result = -1;
                    break;
                }
                curIndex = minIndex + (maxIndex - minIndex) / 2;
                if (array[curIndex] == value) {
                    result = curIndex;
                    break;
                }
                if (array[curIndex] < value) {
                    minIndex = curIndex;
                } else {
                    maxIndex = curIndex;
                }
                ++count;
            }
        }
        System.out.println("loops = " + count);
        return result;
    }
}

