/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.MapUtils;
import org.apache.kafka.common.errors.ApiException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpClient {
    private static final Logger log = LogManager.getLogger(HttpClient.class);
    private long time_out = 600L;
    OkHttpClient okHttpClient = new OkHttpClient();
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType XML = MediaType.parse((String)"text/xml; charset=utf-8");

    public void setTime_out(long time_out) {
        this.time_out = time_out;
    }

    public Response get(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response response = this.okHttpClient.newCall(request).execute();
        return response;
    }

    public Response post(Request request) throws IOException {
        Response response = this.okHttpClient.newCall(request).execute();
        return response;
    }

    public Response post(String url, String json) throws IOException {
        return this.post(url, null, json);
    }

    public Response post(String url, Map<String, String> head, String json) throws IOException {
        Request request;
        Response response;
        Request.Builder request_builder = new Request.Builder();
        request_builder.url(url);
        if (MapUtils.isNotEmpty(head)) {
            for (Map.Entry<String, String> entry : head.entrySet()) {
                request_builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (StringUtils.isNotNull(json)) {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
            request_builder.post(body);
        }
        if (MapUtils.isNotEmpty(head)) {
            for (Map.Entry entry : head.entrySet()) {
                request_builder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ((response = this.okHttpClient.newCall(request = request_builder.build()).execute()).isSuccessful()) {
            return response;
        }
        throw new IOException("Unexpected code " + response);
    }

    public Response delete(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).delete(body).build();
        Response response = this.okHttpClient.newCall(request).execute();
        return response;
    }

    public Response put(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).put(body).build();
        Response response = this.okHttpClient.newCall(request).execute();
        return response;
    }

    public String send(String url, Map<String, String> head) {
        return this.sendBufferByHead(url, head);
    }

    public String send(String url, RequestBody param) {
        Response response = this.send(url, null, param, null);
        return this.getResult(response);
    }

    public String send(String url, Map<String, String> head, RequestBody param) {
        Response response = this.send(url, head, param, null);
        return this.getResult(response);
    }

    public String sendBufferByUrl(String url) {
        Response response = this.sendByUrl(url);
        return this.getResult(response);
    }

    public String sendBufferByHead(String url, Map<String, String> head) {
        Response response = this.sendByHead(url, head);
        return this.getResult(response);
    }

    public String sendBufferByParam(String url, Map<String, String> param) {
        Response response = this.sendByParam(url, param);
        return this.getResult(response);
    }

    public String sendBufferByHeadParam(String url, Map<String, String> head, Map<String, String> param) {
        Response response = this.sendByHeadParam(url, head, param);
        return this.getResult(response);
    }

    public String sendBufferAll(String url, Map<String, String> head, Map<String, String> param, Map<String, String> certificate) {
        Response response = this.sendAll(url, head, param, certificate);
        return this.getResult(response);
    }

    public Response sendByUrl(String url) {
        return this.sendByHead(url, null);
    }

    public Response sendByHead(String url, Map<String, String> head) {
        return this.sendByHeadParam(url, head, null);
    }

    public Response sendByParam(String url, Map<String, String> param) {
        return this.sendByHeadParam(url, null, param);
    }

    public Response sendByHeadParam(String url, Map<String, String> head, Map<String, String> param) {
        return this.sendAll(url, head, param, null);
    }

    public Response sendAll(String url, Map<String, String> head, Map<String, String> param, Map<String, String> certificate) {
        FormBody body = null;
        if (MapUtils.isNotEmpty(param)) {
            FormBody.Builder form_builder = new FormBody.Builder();
            for (Map.Entry<String, String> param_entry : param.entrySet()) {
                form_builder.addEncoded(param_entry.getKey(), param_entry.getValue());
            }
            body = form_builder.build();
        }
        return this.send(url, head, (RequestBody)body, certificate);
    }

    private Response send(String url, Map<String, String> head, RequestBody param, Map<String, String> certificate) {
        if (StringUtils.isNull(url)) {
            log.error("url mast not be null");
            throw new CommonException("\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Request.Builder request_builder = new Request.Builder();
        request_builder.url(url);
        if (MapUtils.isNotEmpty(head)) {
            for (Map.Entry<String, String> head_entry : head.entrySet()) {
                request_builder.addHeader(head_entry.getKey(), head_entry.getValue());
            }
        }
        if (param != null) {
            request_builder.post(param);
        }
        Request request = request_builder.build();
        Response response = null;
        OkHttpClient httpClient = this.getHttpClient(certificate);
        try {
            response = httpClient.newCall(request).execute();
        }
        catch (Exception e) {
            log.error("error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("\u8fde\u63a5\u5931\u8d25");
        }
        if (response.isSuccessful()) {
            return response;
        }
        throw new CommonException("\u8bf7\u6c42\u5931\u8d25");
    }

    private OkHttpClient getHttpClient(Map<String, String> certificate) {
        OkHttpClient.Builder http_client_builder = new OkHttpClient.Builder();
        if (MapUtils.isNotEmpty(certificate)) {
            String file_path = certificate.get("file_path");
            if (StringUtils.isNull(file_path)) {
                log.error("certificate file path mast not be null");
                throw new CommonException("\u8bc1\u4e66\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String password = certificate.get("password");
            if (StringUtils.isNull(password)) {
                log.error("certificate password mast not be null");
                throw new CommonException("\u8bc1\u4e66\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            KeyStore keyStore = null;
            FileInputStream instream = null;
            try {
                keyStore = KeyStore.getInstance("PKCS12");
            }
            catch (Exception e) {
                log.error("keystore instance error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("\u521d\u59cb\u5316\u8bc1\u4e66\u5b9e\u4f8b\u5931\u8d25");
            }
            File f = new File(file_path);
            if (f == null || !f.exists()) {
                log.debug("certificate file not find:" + file_path);
                throw new ApiException("\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u8bd5");
            }
            try {
                instream = new FileInputStream(f);
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("\u52a0\u8f7d\u8bc1\u4e66\u6587\u4ef6\u5931\u8d25");
            }
            try {
                keyStore.load(instream, password.toCharArray());
            }
            catch (Exception e) {
                log.error("get keyStore error->" + e.getLocalizedMessage(), (Throwable)e);
                throw new ApiException("\u83b7\u53d6\u8bc1\u4e66KEY\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5");
            }
            finally {
                try {
                    instream.close();
                }
                catch (Exception e) {
                    log.debug("fileinputstream colse error->" + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            KeyManagerFactory kmf = null;
            try {
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            }
            catch (Exception e) {
                log.error("KeyManagerFactory instance error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("\u5bc6\u94a5\u5de5\u5382\u5b9e\u4f8b\u5316\u9519\u8bef");
            }
            try {
                kmf.init(keyStore, password.toCharArray());
            }
            catch (Exception e) {
                log.error("init KeyManagerFactory error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("\u521d\u59cb\u5316\u5bc6\u94a5\u5de5\u5382\u9519\u8bef");
            }
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLS");
            }
            catch (Exception e) {
                log.error("SSLContext instance error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("SSLContext \u5b9e\u4f8b\u5316\u9519\u8bef");
            }
            try {
                sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
            }
            catch (Exception e) {
                log.error("init SSLContext error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("SSLContext \u521d\u59cb\u5316\u9519\u8bef");
            }
            http_client_builder.socketFactory((SocketFactory)sslContext.getSocketFactory());
        }
        http_client_builder.connectTimeout(this.time_out, TimeUnit.SECONDS);
        return http_client_builder.build();
    }

    public RequestBody getRequestBody(MediaType type, String param) {
        RequestBody body = null;
        if (StringUtils.isNotNull(param)) {
            body = RequestBody.create((MediaType)type, (String)param);
        }
        return body;
    }

    private String getResult(Response response) {
        String result = null;
        try {
            result = response.body().string();
        }
        catch (Exception e) {
            log.error("get response result error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("\u83b7\u53d6\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u5f02\u5e38");
        }
        return result;
    }
}

