/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ExportFile {
    static String save_file_path = "/tmp/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject exportFile(JSONArray fileData, String[] colNames, String user_id, String[] titleName) {
        String path = save_file_path;
        JSONObject input_object = new JSONObject();
        InputStream is = null;
        try {
            JSONArray data_array = ExportFile.cutArray(fileData);
            if (data_array.size() > 0) {
                String zip_path;
                File zipfile;
                ArrayList<File> srcfile = new ArrayList<File>();
                for (int i = 0; i < data_array.size(); ++i) {
                    JSONArray data = data_array.getJSONArray(i);
                    ByteArrayOutputStream byteArray = ExportFile.saveFile(data, colNames, titleName);
                    String save_path = path + ExportFile.fileName() + ".csv";
                    File file = new File(save_path);
                    if (file.exists()) continue;
                    file.createNewFile();
                    DataOutputStream to = new DataOutputStream(new FileOutputStream(file));
                    byteArray.writeTo(to);
                    srcfile.add(file);
                }
                if (srcfile.size() > 0 && !(zipfile = new File(zip_path = path + "ZIP" + user_id + "-" + ExportFile.fileName() + ".zip")).exists()) {
                    is = new FileInputStream(ExportFile.zipFiles(srcfile, zipfile));
                    input_object.put("file_name", (Object)zipfile.getName());
                    input_object.put("file_input", (Object)is);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return input_object;
    }

    public static JSONArray cutArray(JSONArray array) throws Exception {
        int blockSize = 30000;
        JSONArray arrays = new JSONArray();
        if (null != array && blockSize > 0) {
            int listSize = array.size();
            if (listSize <= blockSize) {
                arrays.add((Object)array);
                return arrays;
            }
            int batchSize = listSize / blockSize;
            int remain = listSize % blockSize;
            for (int i = 0; i < batchSize; ++i) {
                int fromIndex = i * blockSize;
                int toIndex = fromIndex + blockSize;
                arrays.add((Object)array.subList(fromIndex, toIndex));
            }
            if (remain > 0) {
                arrays.add((Object)array.subList(listSize - remain, listSize));
            }
        }
        return arrays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream saveFile(JSONArray fileData, String[] colNames, String[] titleName) {
        SXSSFWorkbook wb = null;
        try {
            LinkedList<Object[]> excelContent = new LinkedList<Object[]>();
            if (fileData.size() > 0) {
                for (int i = 0; i < fileData.size(); ++i) {
                    JSONObject details_object = fileData.getJSONObject(i);
                    String[] form_key = new String[colNames.length];
                    if (details_object.size() > 0) {
                        for (int k = 0; k < colNames.length; ++k) {
                            String key = colNames[k].trim();
                            String value = "";
                            if (!org.apache.commons.lang.StringUtils.isNotBlank((String)key) || !details_object.containsKey((Object)key)) continue;
                            form_key[k] = value = details_object.getString(key);
                        }
                    }
                    if (form_key.length <= 0) continue;
                    excelContent.add(form_key);
                }
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            wb = new SXSSFWorkbook();
            SXSSFSheet sheet = wb.createSheet();
            if (titleName.length > 0) {
                ExportFile.creaTableName(sheet, titleName);
            }
            if (excelContent.size() > 0) {
                ExportFile.createExcelContent(sheet, excelContent);
            }
            wb.write((OutputStream)os);
            ByteArrayOutputStream byteArrayOutputStream = os;
            return byteArrayOutputStream;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                    wb = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void creaTableName(SXSSFSheet sheet, String[] name) {
        int count = name.length;
        SXSSFRow colRow = sheet.createRow(0);
        for (int i = 0; i < count; ++i) {
            SXSSFCell cell = colRow.createCell(i, 1);
            cell.setCellValue((RichTextString)new XSSFRichTextString(name[i].trim()));
        }
    }

    public static void createExcelContent(SXSSFSheet sheet, List<Object[]> datalist) {
        int startIndex = sheet.getLastRowNum() + 1;
        for (int i = 0; i < datalist.size(); ++i) {
            SXSSFRow colRow = sheet.createRow(startIndex + i);
            Object[] datas = datalist.get(i);
            if (null == datas || datas.length <= 0) continue;
            for (int j = 0; j < datas.length; ++j) {
                SXSSFCell cell = colRow.createCell(j, 1);
                if (null == datas[j] || datas[j].equals("")) continue;
                cell.setCellValue((RichTextString)new XSSFRichTextString(datas[j].toString()));
            }
        }
    }

    public static String fileName() {
        String fileName = "";
        String time = TimeUtils.getTime(System.currentTimeMillis(), TimeUtils.DATETIME_FORMAT_DATE_NO);
        String random = StringUtils.randomNumber(6);
        fileName = time + random;
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zipFiles(List<File> srcfile, File zipfile) {
        byte[] buf = new byte[1024];
        ZipOutputStream out = null;
        FileInputStream in = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zipfile));
            for (int i = 0; i < srcfile.size(); ++i) {
                int len;
                File file = srcfile.get(i);
                in = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(file.getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return zipfile;
    }
}

