/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import org.apache.commons.lang.StringUtils;

public class EmojiUtil {
    public static void main(String[] args) throws Exception {
        byte[] testbytes = new byte[]{105, 111, 115, -30, -102, -67, 32, 36, -18, -128, -104, 32, 36, -16, -97, -113, -128, 32, 36, -18, -112, -86};
        String tmpstr = new String(testbytes, "utf-8");
        System.out.println(EmojiUtil.filterEmoji(tmpstr));
        System.out.println("containsEmoji2: " + EmojiUtil.containsEmoji("tetete11\u4ec0\u4e4866789@#\uffe5*\uff08&*\uff09*%"));
        System.out.println(EmojiUtil.containsEmoji(tmpstr));
    }

    public static boolean containsEmoji(String source) {
        if (StringUtils.isBlank((String)source)) {
            return false;
        }
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (EmojiUtil.isNotEmojiCharacter(codePoint)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public static String filterEmoji(String source) {
        if (StringUtils.isBlank((String)source)) {
            return source;
        }
        if (!EmojiUtil.containsEmoji(source)) {
            return source;
        }
        StringBuilder buf = new StringBuilder();
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (!EmojiUtil.isNotEmojiCharacter(codePoint)) continue;
            buf.append(codePoint);
        }
        return buf.toString().trim();
    }
}

