/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import kr.weitao.common.util.HttpClient;
import okhttp3.Response;

public class BaiduMapUtils {
    private static double EARTH_RADIUS = 6378.137;
    private static String BaiduMap_AK = "QGskGCbgRGfjbMPRPwQfVOYOYQoEvsYK";
    private static String BaiduMap_SK = "8vFHGqKgZ7ebMxeKv4uvZxXXkvLlpVxy";
    private static String BaiduMap_Url = "http://api.map.baidu.com";

    public static final JSONArray ConvertCoords(String coords, String from, String to) throws Exception {
        JSONArray array = new JSONArray();
        HttpClient httpClient = new HttpClient();
        String url = "http://api.map.baidu.com/geoconv/v1/?coords=" + coords + "&from=" + from + "&to=" + to + "&ak=" + BaiduMap_AK;
        Response result = httpClient.get(url);
        JSONObject obj = JSONObject.parseObject((String)result.body().string());
        if (obj.get((Object)"status").toString().equals("0")) {
            array = obj.getJSONArray("result");
        }
        return array;
    }

    public static double GetDistance(String latitude1, String longitude1, String latitude2, String longitude2) {
        double lat1 = Double.parseDouble(latitude1);
        double lat2 = Double.parseDouble(latitude2);
        double lng1 = Double.parseDouble(longitude1);
        double lng2 = Double.parseDouble(longitude2);
        double radLat1 = Math.toRadians(lat1);
        double radLat2 = Math.toRadians(lat2);
        double a = radLat1 - radLat2;
        double b = Math.toRadians(lng1) - Math.toRadians(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        return s *= EARTH_RADIUS;
    }

    public JSONObject GeoCoords(String coords) {
        HttpClient httpClient = new HttpClient();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("location", coords);
        map.put("output", "json");
        map.put("coordtype", "wgs84ll");
        map.put("latest_admin", "1");
        map.put("ak", BaiduMap_AK);
        JSONObject object = null;
        try {
            String paramsStr = BaiduMapUtils.toQueryString(map);
            String wholeStr = new String("/geocoder/v2/?" + paramsStr);
            String tempStr = URLEncoder.encode(wholeStr, "UTF-8");
            String sn = BaiduMapUtils.MD5(tempStr + BaiduMap_SK);
            String url = BaiduMap_Url + wholeStr + "&sn=" + sn;
            Response result = httpClient.get(url);
            String returns = result.body().string();
            object = JSONObject.parseObject((String)returns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    public static String toQueryString(Map<?, ?> data) throws UnsupportedEncodingException {
        StringBuffer queryString = new StringBuffer();
        for (Map.Entry<?, ?> pair : data.entrySet()) {
            queryString.append(pair.getKey() + "=");
            queryString.append(URLEncoder.encode((String)pair.getValue(), "UTF-8") + "&");
        }
        if (queryString.length() > 0) {
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    public static String MD5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public void main(String[] args) throws Exception {
        System.out.println("======" + this.GeoCoords("114.21892734521,29.575429778924"));
    }
}

