/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.common.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.UUID;
import kr.weitao.common.util.MD5Util;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AliCDNUrlAuth {
    @Value(value="${spring.profiles.active}")
    private String active;
    static final String KEY = "fVBDvtwPAtaYRYxE3HvRbZiBfGXtrX";
    @Value(value="${oss.oss_domain}")
    String OSS_DOMAIN;

    public String getAuthURLA1(String url) {
        boolean isHttpUrl = url.startsWith("http");
        long timestamp = System.currentTimeMillis() / 1000L;
        String rand = UUID.randomUUID().toString().replaceAll("-", "");
        String finalURL = null;
        if (isHttpUrl) {
            String protocol = null;
            String host = null;
            String port = "";
            String path = null;
            String query = null;
            String auth = null;
            try {
                URL urlTmp = new URL(url);
                protocol = urlTmp.getProtocol() + "://";
                host = urlTmp.getHost();
                port = urlTmp.getPort() != -1 ? ":" + Integer.toString(urlTmp.getPort()) : "";
                path = urlTmp.getPath();
                query = urlTmp.getQuery() != null ? "&" + urlTmp.getQuery() : "";
                String tmpStr = path + "-" + timestamp + "-" + rand + "-0-" + KEY;
                auth = timestamp + "-" + rand + "-0-" + MD5Util.getMD5Str32(tmpStr).toLowerCase();
                finalURL = protocol + host + port + path + "?auth_key=" + auth + query;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        } else {
            String[] urlArray = url.split("\\?");
            String path = url.split("\\?")[0];
            String query = "";
            if (urlArray.length > 1) {
                query = "&" + url.split("\\?")[1];
            }
            String tmpStr = path + "-" + timestamp + "-" + rand + "-0-" + KEY;
            String auth = timestamp + "-" + rand + "-0-" + MD5Util.getMD5Str32(tmpStr).toLowerCase();
            finalURL = path + "?auth_key=" + auth + query;
        }
        return finalURL;
    }

    public String getAuthURLA(String url) {
        if (!url.startsWith("http")) {
            if (url.startsWith("/")) {
                url = URLEncoder.encode(url.substring(1, url.length()));
            }
            url = URLEncoder.encode(url);
            if ("dev".equals(this.active)) {
                url = this.OSS_DOMAIN + "/" + url;
            } else {
                url = this.OSS_DOMAIN + "/" + url;
                if (!url.contains("?x-oss-process=style/compact")) {
                    url = url + "?x-oss-process=style/compact";
                }
            }
        } else if (!"dev".equals(this.active) && url.contains("oss-cn-shanghai") && !url.contains("?x-oss-process=style/compact")) {
            url = url + "?x-oss-process=style/compact";
        }
        return url;
    }

    public String getAuthURLAV2(String url) {
        if (!url.startsWith("http")) {
            if (url.startsWith("/")) {
                url = URLEncoder.encode(url.substring(1, url.length()));
            }
            url = URLEncoder.encode(url);
            url = "dev".equals(this.active) ? this.OSS_DOMAIN + "/" + url : this.OSS_DOMAIN + "/" + url;
        } else if ("dev".equals(this.active) || url.contains("oss-cn-shanghai")) {
            // empty if block
        }
        return url;
    }

    public String getAuthUrl(String url) {
        if (!url.startsWith("http")) {
            if (url.startsWith("/")) {
                url = URLEncoder.encode(url.substring(1, url.length()));
            }
            url = URLEncoder.encode(url);
            if ("dev".equals(this.active)) {
                url = this.getAuthURLA(this.OSS_DOMAIN + "/" + url);
            } else {
                url = this.getAuthURLA(this.OSS_DOMAIN + "/" + url);
                if (!url.contains("?x-oss-process=style/compact")) {
                    url = url + "?x-oss-process=style/compact";
                }
            }
        } else if (!"dev".equals(this.active) && url.contains("oss-cn-shanghai") && !url.contains("?x-oss-process=style/compact")) {
            url = url + "?x-oss-process=style/compact";
        }
        return url;
    }

    public String cleanAuthUrl(String image_url) {
        if (image_url.startsWith(this.OSS_DOMAIN)) {
            image_url = image_url.replace(this.OSS_DOMAIN + "/", "");
            image_url = image_url.split("\\?")[0];
            image_url = URLDecoder.decode(image_url);
            return image_url;
        }
        if (image_url.startsWith(this.OSS_DOMAIN)) {
            image_url = image_url.replace(this.OSS_DOMAIN + "/", "");
            image_url = image_url.split("\\?")[0];
            image_url = URLDecoder.decode(image_url);
            return image_url;
        }
        return image_url;
    }

    public void main(String[] args) {
        long timestamp = System.currentTimeMillis() / 1000L;
        this.getAuthURLA("https://cdn.weitao.kr/goods_imgs/5a41e339ca2d3c138289175d/1523613488wtk0.jpg");
    }
}

