/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata.table;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import io.shardingsphere.core.metadata.table.ColumnMetaData;
import io.shardingsphere.core.metadata.table.TableMetaData;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.column.ColumnDefinitionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.column.position.ColumnAfterPositionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.column.position.ColumnFirstPositionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.column.position.ColumnPositionSegment;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.AlterTableStatement;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.CreateTableStatement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class TableMetaDataFactory {
    public static TableMetaData newInstance(CreateTableStatement createTableStatement) {
        return new TableMetaData(Lists.transform(createTableStatement.getColumnDefinitions(), (Function)new Function<ColumnDefinitionSegment, ColumnMetaData>(){

            public ColumnMetaData apply(ColumnDefinitionSegment input) {
                return new ColumnMetaData(input.getColumnName(), input.getDataType(), input.isPrimaryKey());
            }
        }));
    }

    public static TableMetaData newInstance(AlterTableStatement alterTableStatement, TableMetaData oldTableMetaData) {
        List<ColumnMetaData> result = TableMetaDataFactory.createColumnMetaDataList(alterTableStatement.getModifiedColumnDefinitions(), alterTableStatement.isDropPrimaryKey(), oldTableMetaData);
        result.addAll(TableMetaDataFactory.createColumnMetaDataList(alterTableStatement.getAddedColumnDefinitions(), alterTableStatement.isDropPrimaryKey()));
        TableMetaDataFactory.changeColumnDefinitionPositions(alterTableStatement.getChangedPositionColumns(), result);
        TableMetaDataFactory.dropColumnDefinitions(alterTableStatement.getDroppedColumnNames(), result);
        return new TableMetaData(result);
    }

    private static List<ColumnMetaData> createColumnMetaDataList(Map<String, ColumnDefinitionSegment> modifiedColumnDefinitions, boolean dropPrimaryKey, TableMetaData oldTableMetaData) {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        for (ColumnMetaData each : oldTableMetaData.getColumns().values()) {
            ColumnMetaData columnMetaData;
            if (modifiedColumnDefinitions.containsKey(each.getColumnName())) {
                ColumnDefinitionSegment columnDefinition = modifiedColumnDefinitions.get(each.getColumnName());
                columnMetaData = new ColumnMetaData(columnDefinition.getColumnName(), columnDefinition.getDataType(), !dropPrimaryKey && columnDefinition.isPrimaryKey());
            } else {
                columnMetaData = new ColumnMetaData(each.getColumnName(), each.getDataType(), !dropPrimaryKey && each.isPrimaryKey());
            }
            result.add(columnMetaData);
        }
        return result;
    }

    private static List<ColumnMetaData> createColumnMetaDataList(Collection<ColumnDefinitionSegment> addedColumnDefinitions, boolean dropPrimaryKey) {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        for (ColumnDefinitionSegment each : addedColumnDefinitions) {
            result.add(new ColumnMetaData(each.getColumnName(), each.getDataType(), !dropPrimaryKey && each.isPrimaryKey()));
        }
        return result;
    }

    private static void changeColumnDefinitionPositions(Collection<ColumnPositionSegment> changedPositionColumns, List<ColumnMetaData> columnMetaDataList) {
        for (ColumnPositionSegment each : changedPositionColumns) {
            if (each instanceof ColumnFirstPositionSegment) {
                TableMetaDataFactory.changeColumnDefinitionPosition((ColumnFirstPositionSegment)each, columnMetaDataList);
                continue;
            }
            TableMetaDataFactory.changeColumnDefinitionPosition((ColumnAfterPositionSegment)each, columnMetaDataList);
        }
    }

    private static void changeColumnDefinitionPosition(ColumnFirstPositionSegment columnFirstPositionSegment, List<ColumnMetaData> columnMetaDataList) {
        Optional<ColumnMetaData> columnMetaData = TableMetaDataFactory.find(columnFirstPositionSegment.getColumnName(), columnMetaDataList);
        if (columnMetaData.isPresent()) {
            columnMetaDataList.remove(columnMetaData.get());
            columnMetaDataList.add(0, (ColumnMetaData)columnMetaData.get());
        }
    }

    private static void changeColumnDefinitionPosition(ColumnAfterPositionSegment columnAfterPositionSegment, List<ColumnMetaData> columnMetaDataList) {
        Optional<ColumnMetaData> columnMetaData = TableMetaDataFactory.find(columnAfterPositionSegment.getColumnName(), columnMetaDataList);
        Optional<ColumnMetaData> afterColumnMetaData = TableMetaDataFactory.find(columnAfterPositionSegment.getAfterColumnName(), columnMetaDataList);
        if (columnMetaData.isPresent() && afterColumnMetaData.isPresent()) {
            columnMetaDataList.remove(columnMetaData.get());
            columnMetaDataList.add(columnMetaDataList.indexOf(afterColumnMetaData.get()) + 1, (ColumnMetaData)columnMetaData.get());
        }
    }

    private static Optional<ColumnMetaData> find(String columnName, List<ColumnMetaData> columnMetaDataList) {
        for (ColumnMetaData each : columnMetaDataList) {
            if (!columnName.equals(each.getColumnName())) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    private static void dropColumnDefinitions(Collection<String> droppedColumnNames, List<ColumnMetaData> columnMetaDataList) {
        LinkedList<ColumnMetaData> droppedColumnMetaDataList = new LinkedList<ColumnMetaData>();
        for (ColumnMetaData each : columnMetaDataList) {
            if (!droppedColumnNames.contains(each.getColumnName())) continue;
            droppedColumnMetaDataList.add(each);
        }
        columnMetaDataList.removeAll(droppedColumnMetaDataList);
    }
}

